/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.googleDrive;

import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class GoogleDriveSendFileFolderTask
extends Task {
    private static final String taskName = "GoogleDriveSendFolder";
    private final String targetFolderId;
    private final File sourceDir;
    private final boolean forceExcludedDirs;
    private final boolean createRootDirInTargetDir;
    private final String rootDirInTargetDirName;
    private long dirSize = 0L;
    private final ArrayList<CompletableFuture<Void>> tasks = new ArrayList();
    private final ArrayList<GoogleDriveUploadProgressListener> progressListeners = new ArrayList();

    public GoogleDriveSendFileFolderTask(File sourceDir, String targetDirId, String rootDirInTargetDirName, boolean createRootDirInTargetDir, boolean forceExcludedDirs, boolean setLocked, List<Permissions> permissions, CommandSender sender) {
        super(taskName, setLocked, permissions, sender);
        this.sourceDir = sourceDir;
        this.targetFolderId = targetDirId;
        this.createRootDirInTargetDir = createRootDirInTargetDir;
        this.forceExcludedDirs = forceExcludedDirs;
        this.rootDirInTargetDirName = rootDirInTargetDirName;
    }

    @Override
    public void run() {
        try {
            block14: {
                if (this.setLocked) {
                    Backuper.lock(this);
                }
                if (!this.isTaskPrepared) {
                    this.prepareTask();
                }
                Logger.getLogger().devLog("GoogleDriveSendFolder task has been started");
                if (!GoogleDriveUtils.isAuthorized(this.sender)) {
                    Logger.getLogger().warn("GoogleDriveSendFolder task failed");
                    Logger.getLogger().devLog("You need to login your Google account to upload files to Google Drive");
                    return;
                }
                if (!this.cancelled) {
                    this.sendFolder(this.sourceDir, this.targetFolderId, true);
                    try {
                        CompletableFuture.allOf(this.tasks.toArray(new CompletableFuture[0])).join();
                    }
                    catch (Exception e) {
                        if (this.cancelled) break block14;
                        Logger.getLogger().warn("GoogleDriveSendFolder task failed", this.sender);
                        Logger.getLogger().warn(this.getClass(), e);
                    }
                }
            }
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong when trying to upload file/folder to Google Drive", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
        finally {
            Logger.getLogger().devLog("GoogleDriveSendFolder task has been finished");
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        this.dirSize = this.forceExcludedDirs ? Utils.getFileFolderByteSize(this.sourceDir) : Utils.getFileFolderByteSizeExceptExcluded(this.sourceDir);
    }

    private void sendFolder(File localDirToSend, String remoteFolderId, boolean firstDir) {
        if (remoteFolderId == null) {
            Logger.getLogger().warn(this.getClass(), "remoteFolderId is null, let developer know!", this.sender);
            return;
        }
        if (this.cancelled) {
            return;
        }
        if (!localDirToSend.exists()) {
            Logger.getLogger().warn("Something went wrong while trying to send files from " + localDirToSend.getAbsolutePath());
            Logger.getLogger().warn("Directory " + localDirToSend.getAbsolutePath() + " does not exist", this.sender);
            return;
        }
        boolean isExcludedDirectory = Utils.isExcludedDirectory(localDirToSend, this.sender);
        if (isExcludedDirectory && !this.forceExcludedDirs) {
            return;
        }
        if (localDirToSend.isFile() && !localDirToSend.getName().equals("session.lock")) {
            try {
                String currentRemoteFolderId = remoteFolderId;
                GoogleDriveUploadProgressListener progressListener = new GoogleDriveUploadProgressListener();
                this.progressListeners.add(progressListener);
                CompletableFuture<Void> task = CompletableFuture.runAsync(() -> {
                    if (!firstDir) {
                        GoogleDriveUtils.uploadFile(localDirToSend, currentRemoteFolderId, progressListener, this.sender);
                    } else {
                        GoogleDriveUtils.uploadFile(localDirToSend, this.rootDirInTargetDirName, currentRemoteFolderId, (MediaHttpUploaderProgressListener)progressListener, this.sender);
                    }
                });
                this.tasks.add(task);
            }
            catch (Exception e) {
                Logger.getLogger().warn("Something went wrong while uploading file \"" + localDirToSend.getAbsolutePath() + "\" to the Google Drive", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
            }
        }
        if (localDirToSend.isDirectory() && localDirToSend.listFiles() != null) {
            if (this.createRootDirInTargetDir || !firstDir) {
                remoteFolderId = firstDir ? GoogleDriveUtils.createFolder(this.rootDirInTargetDirName, remoteFolderId, this.sender) : GoogleDriveUtils.createFolder(localDirToSend.getName(), remoteFolderId, this.sender);
            }
            for (File file : localDirToSend.listFiles()) {
                this.sendFolder(file, remoteFolderId, false);
            }
        }
    }

    @Override
    public long getTaskCurrentProgress() {
        long currentProgress = 0L;
        for (GoogleDriveUploadProgressListener progressListener : this.progressListeners) {
            currentProgress += progressListener.getBytesUploaded();
        }
        return currentProgress;
    }

    @Override
    public long getTaskMaxProgress() {
        return this.dirSize;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (CompletableFuture<Void> task : this.tasks) {
            task.cancel(true);
        }
    }

    static class GoogleDriveUploadProgressListener
    implements MediaHttpUploaderProgressListener {
        long progress = 0L;

        GoogleDriveUploadProgressListener() {
        }

        @Override
        public void progressChanged(MediaHttpUploader mediaHttpUploader) {
            this.progress = mediaHttpUploader.getNumBytesUploaded();
        }

        public long getBytesUploaded() {
            return this.progress;
        }
    }
}

