/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.local.folder;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class CopyFilesToFolderTask
extends Task {
    private static final String taskName = "CopyFiles";
    private final File sourceDirToCopy;
    private final File targetDir;
    private final boolean forceExcludedDirs;
    private final boolean createRootDirInTargetDir;
    private final ArrayList<CompletableFuture<Void>> copyTasks = new ArrayList();

    public CopyFilesToFolderTask(File sourceDirToCopy, File targetDir, boolean createRootDirInTargetDir, boolean forceExcludedDirs, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.sourceDirToCopy = sourceDirToCopy;
        this.targetDir = targetDir;
        this.forceExcludedDirs = forceExcludedDirs;
        this.createRootDirInTargetDir = createRootDirInTargetDir;
    }

    @Override
    public void run() {
        if (this.setLocked) {
            Backuper.lock(this);
        }
        try {
            Logger.getLogger().devLog("CopyFiles task has been started");
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            if (!this.cancelled) {
                if (this.createRootDirInTargetDir) {
                    this.unsafeCopyFilesInDir(this.targetDir.toPath().resolve(this.sourceDirToCopy.getName()).toFile(), this.sourceDirToCopy);
                } else {
                    this.unsafeCopyFilesInDir(this.targetDir, this.sourceDirToCopy);
                }
                try {
                    CompletableFuture.allOf(this.copyTasks.toArray(new CompletableFuture[0])).join();
                }
                catch (Exception e) {
                    Logger.getLogger().warn("Failed to copy files into target dir", this.sender);
                    Logger.getLogger().warn(this.getClass(), e);
                }
            }
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong while running CopyFiles task");
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    private void unsafeCopyFilesInDir(File destDir, File sourceDir) {
        if (this.cancelled) {
            return;
        }
        if (!sourceDir.exists()) {
            Logger.getLogger().warn("Something went wrong while copying files from " + sourceDir.getAbsolutePath());
            Logger.getLogger().warn("Directory " + sourceDir.getAbsolutePath() + " does not exist", this.sender);
            return;
        }
        boolean isExcludedDirectory = Utils.isExcludedDirectory(sourceDir, this.sender);
        if (isExcludedDirectory && !this.forceExcludedDirs) {
            return;
        }
        if (!this.cancelled && sourceDir.isFile() && !sourceDir.getName().equals("session.lock")) {
            CompletableFuture<Void> copyTask = CompletableFuture.runAsync(() -> {
                try {
                    Files.copy(sourceDir.toPath(), destDir.toPath(), new CopyOption[0]);
                    this.incrementCurrentProgress(Files.size(sourceDir.toPath()));
                }
                catch (SecurityException e) {
                    Logger.getLogger().warn("Backup Directory is not allowed to modify! " + sourceDir.getName(), this.sender);
                    Logger.getLogger().warn("BackupTask", (Exception)e);
                }
                catch (Exception e) {
                    Logger.getLogger().devWarn(this.getClass(), "Something went wrong while trying to copy file! " + sourceDir.getName());
                    Logger.getLogger().devWarn(this.getClass(), Arrays.toString(e.getStackTrace()));
                }
            });
            this.copyTasks.add(copyTask);
        }
        if (sourceDir.listFiles() != null) {
            if (!destDir.exists() && !destDir.mkdirs()) {
                Logger.getLogger().warn("Failed to create dir: " + destDir.getPath(), this.sender);
            }
            for (File file : Objects.requireNonNull(sourceDir.listFiles())) {
                this.unsafeCopyFilesInDir(destDir.toPath().resolve(file.getName()).toFile(), file);
            }
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        this.maxProgress = this.forceExcludedDirs ? Utils.getFileFolderByteSize(this.sourceDirToCopy) : Utils.getFileFolderByteSizeExceptExcluded(this.sourceDirToCopy);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (CompletableFuture<Void> task : this.copyTasks) {
            task.cancel(true);
        }
    }
}

