/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.local.folder;

import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class DeleteDirTask
extends Task {
    private static final String taskName = "DeleteDir";
    private final File dirToDelete;

    public DeleteDirTask(File dirToDelete, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.dirToDelete = dirToDelete;
    }

    @Override
    public void run() {
        if (this.setLocked) {
            Backuper.lock(this);
        }
        try {
            Logger.getLogger().devLog("DeleteDir task has been started");
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            this.deleteDir(this.dirToDelete);
            Logger.getLogger().devLog("DeleteDir task has been finished");
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong while running DeleteDirTask", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    private void deleteDir(File dir) {
        if (this.cancelled) {
            return;
        }
        if (!dir.exists()) {
            Logger.getLogger().warn("Directory " + dir.getAbsolutePath() + " does not exist");
            return;
        }
        if (!this.cancelled && dir.isFile()) {
            long fileByteSize = 0L;
            try {
                fileByteSize = Files.size(dir.toPath());
            }
            catch (Exception e) {
                Logger.getLogger().warn("Failed to get file size before deletion", this.sender);
                Logger.getLogger().warn(DeleteDirTask.class, e);
            }
            if (!dir.delete()) {
                Logger.getLogger().warn("Can not delete file " + dir.getName(), this.sender);
            }
            this.incrementCurrentProgress(fileByteSize);
        } else if (dir.isDirectory()) {
            for (File file : Objects.requireNonNull(dir.listFiles())) {
                this.deleteDir(file);
            }
            if (!dir.delete()) {
                Logger.getLogger().warn("Can not delete directory " + dir.getName(), this.sender);
            }
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        this.maxProgress = Utils.getFileFolderByteSize(this.dirToDelete);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }
}

