/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.local.zip.tozip;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.common.BaseAddLocalDirsToZipTask;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class AddDirToZipTask
extends BaseAddLocalDirsToZipTask {
    private static final String taskName = "AddDirToZip";
    private File targetZipFileDir;

    public AddDirToZipTask(List<File> sourceDirsToAdd, File targetZipFile, boolean createRootDirInTargetZIP, boolean forceExcludedDirs, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, sourceDirsToAdd, createRootDirInTargetZIP, forceExcludedDirs, setLocked, permission, sender);
        this.targetZipFileDir = targetZipFile;
        this.sender = sender;
    }

    @Override
    public void run() {
        if (this.setLocked) {
            Backuper.lock(this);
        }
        try {
            Logger.getLogger().devLog("AddDirToZip task has been started");
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            if (this.targetZipFileDir != null && !this.targetZipFileDir.exists() && !this.targetZipFileDir.createNewFile()) {
                Logger.getLogger().devLog("Failed to create file " + this.targetZipFileDir.getAbsolutePath());
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.targetZipFileDir));){
                for (File sourceDirToAdd : this.sourceDirsToAdd) {
                    if (this.cancelled) {
                        break;
                    }
                    if (this.createRootDirInTargetZIP) {
                        File parent = sourceDirToAdd.getParentFile();
                        parent = parent == null ? new File("") : parent;
                        this.addDirToZip(zipOutputStream, sourceDirToAdd, parent.toPath());
                        continue;
                    }
                    this.addDirToZip(zipOutputStream, sourceDirToAdd, sourceDirToAdd.toPath());
                }
            }
            catch (Exception e) {
                Logger.getLogger().warn("AddDirToZip task failed", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
                Backuper.unlock();
            }
            Logger.getLogger().devLog("AddDirToZip task has been finished");
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong while running AddDirToZip task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    @Override
    protected int getZipCompressionLevel() {
        return Config.getInstance().getLocalConfig().getZipCompressionLevel();
    }
}

