/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.local.zip.unzip;

import java.io.File;
import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.local.folder.DeleteDirTask;
import ru.dvdishka.backuper.backend.tasks.local.zip.unzip.UnpackZipTask;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class ConvertZipToFolderTask
extends Task {
    private static final String taskName = "UnZip";
    private final File sourceZipFileDir;
    private UnpackZipTask unpackZipTask;
    private DeleteDirTask deleteDirTask;
    private final long deleteProgressMultiplier = 1L;
    private final long unZipProgressMultiplier = 50L;

    public ConvertZipToFolderTask(File sourceZipFileDir, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.sourceZipFileDir = sourceZipFileDir;
    }

    @Override
    public void run() {
        if (this.setLocked) {
            Backuper.lock(this);
        }
        try {
            Logger.getLogger().devLog("ZipToFolder task has been started");
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            if (!this.cancelled) {
                this.unpackZipTask.run();
            }
            if (!this.cancelled) {
                this.deleteDirTask.run();
            }
            if (!this.cancelled) {
                Logger.getLogger().devLog("The Rename \"in progress\" Folder/ZIP local task has been started");
                if (!new File(this.sourceZipFileDir.getPath().replace(".zip", "") + " in progress").renameTo(new File(this.sourceZipFileDir.getPath().replace(".zip", "")))) {
                    Logger.getLogger().warn("The Rename \"in progress\" ZIP local task has been finished with an exception!", this.sender);
                }
                Logger.getLogger().devLog("The Rename \"in progress\" Folder/ZIP local task has been finished");
            }
            Logger.getLogger().devLog("ZipToFolder task has been finished");
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong while running ZipToFolder task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        this.unpackZipTask = new UnpackZipTask(this.sourceZipFileDir, new File(this.sourceZipFileDir.getPath().replace(".zip", "") + " in progress"), false, this.permissions, this.sender);
        this.deleteDirTask = new DeleteDirTask(this.sourceZipFileDir, false, (List<Permissions>)this.permissions, this.sender);
    }

    @Override
    public long getTaskCurrentProgress() {
        if (this.unpackZipTask == null || this.deleteDirTask == null) {
            return 0L;
        }
        return this.unpackZipTask.getTaskCurrentProgress() * 50L + this.deleteDirTask.getTaskCurrentProgress() * 1L;
    }

    @Override
    public long getTaskMaxProgress() {
        if (this.unpackZipTask == null || this.deleteDirTask == null) {
            return 100L;
        }
        return this.unpackZipTask.getTaskMaxProgress() * 50L + this.deleteDirTask.getTaskMaxProgress() * 1L;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.deleteDirTask.cancel();
        this.unpackZipTask.cancel();
    }
}

