/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.common.BaseAddLocalDirsToZipTask;
import ru.dvdishka.backuper.backend.utils.SftpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class SftpAddLocalDirsToZipTask
extends BaseAddLocalDirsToZipTask {
    private static final String taskName = "SftpAddLocalDirToZip";
    private String targetZipPath;
    private Session sshSession;
    private ChannelSftp sftpChannel;

    public SftpAddLocalDirsToZipTask(List<File> sourceDirsToAdd, String targetZipPath, boolean createRootDirInTargetZIP, boolean forceExcludedDirs, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, sourceDirsToAdd, createRootDirInTargetZIP, forceExcludedDirs, setLocked, permission, sender);
        this.targetZipPath = targetZipPath;
        this.sender = sender;
    }

    @Override
    protected int getZipCompressionLevel() {
        return Config.getInstance().getSftpConfig().getZipCompressionLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.setLocked) {
            Backuper.lock(this);
        }
        try {
            Logger.getLogger().devLog("SftpAddLocalDirToZip task has been started");
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            if (!this.cancelled) {
                Pair<Session, ChannelSftp> sessionChannelSftpPair = SftpUtils.createChannel(this.sender);
                if (sessionChannelSftpPair == null) {
                    return;
                }
                this.sshSession = sessionChannelSftpPair.getLeft();
                this.sftpChannel = sessionChannelSftpPair.getRight();
                if (this.sftpChannel == null) {
                    return;
                }
                this.sftpChannel.connect(10000);
            }
            OutputStream outputStream = this.sftpChannel.put(this.targetZipPath);
            ZipOutputStream targetZipOutputStream = new ZipOutputStream(outputStream);
            try {
                for (File sourceDirToAdd : this.sourceDirsToAdd) {
                    if (this.cancelled) {
                        break;
                    }
                    if (this.createRootDirInTargetZIP) {
                        File parent = sourceDirToAdd.getParentFile();
                        parent = parent == null ? new File("") : parent;
                        this.addDirToZip(targetZipOutputStream, sourceDirToAdd, parent.toPath());
                        continue;
                    }
                    this.addDirToZip(targetZipOutputStream, sourceDirToAdd, sourceDirToAdd.toPath());
                }
            }
            catch (Exception e) {
                Logger.getLogger().warn("SftpAddLocalDirToZip task failed", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
                Backuper.unlock();
            }
            finally {
                targetZipOutputStream.finish();
                targetZipOutputStream.close();
                outputStream.close();
                this.sftpChannel.exit();
                this.sshSession.disconnect();
            }
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong while running SftpAddLocalDirToZip task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
        finally {
            Logger.getLogger().devLog("SftpAddLocalDirToZip task has been finished");
        }
    }
}

