/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;

public class FtpUtils {
    private static boolean enabled;
    private static String backupsFolder;
    private static String username;
    private static String address;
    private static String password;
    private static String pathSeparatorSymbol;
    private static int port;
    private static ArrayList<FTPClient> ftps;

    public static void init() {
        enabled = Config.getInstance().getFtpConfig().isEnabled();
        backupsFolder = Config.getInstance().getFtpConfig().getBackupsFolder();
        username = Config.getInstance().getFtpConfig().getUsername();
        address = Config.getInstance().getFtpConfig().getAddress();
        password = Config.getInstance().getFtpConfig().getPassword();
        pathSeparatorSymbol = Config.getInstance().getFtpConfig().getPathSeparatorSymbol();
        port = Config.getInstance().getFtpConfig().getPort();
    }

    public static boolean checkConnection(CommandSender sender) {
        if (!Config.getInstance().getFtpConfig().isEnabled()) {
            return false;
        }
        try {
            FTPClient ftp = FtpUtils.getClient(sender);
            boolean connected = ftp != null;
            ftp.disconnect();
            return connected;
        }
        catch (Exception e) {
            Logger.getLogger().devWarn(FtpUtils.class, e);
            return false;
        }
    }

    public static FTPClient getClient(CommandSender sender) {
        try {
            int cnt = 0;
            for (FTPClient client : ftps) {
                if (!client.isConnected()) continue;
                ++cnt;
            }
            FTPClient ftp = new FTPClient();
            if (Config.getInstance().isBetterLogging()) {
                // empty if block
            }
            ftp.setConnectTimeout(10000);
            ftp.setDefaultTimeout(30000);
            ftp.setDataTimeout(30000);
            ftp.setControlKeepAliveTimeout(30000L);
            ftp.setControlEncoding("UTF-8");
            ftp.connect(address, port);
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                ftp.disconnect();
                throw new IOException("Exception in connecting to FTP Server");
            }
            ftp.enterLocalPassiveMode();
            ftp.login(username, password);
            reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                ftp.disconnect();
                throw new IOException("Failed to login FTP Server");
            }
            ftp.setFileType(2, 2);
            ftp.setFileTransferMode(10);
            ftp.setListHiddenFiles(true);
            ftps.add(ftp);
            return ftp;
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to connect to FTP(S) server", sender);
            Logger.getLogger().warn("FtpUtils:createFtpChannel", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> ls(String path, CommandSender sender) {
        FTPClient ftp = FtpUtils.getClient(sender);
        try {
            ftp.changeWorkingDirectory(path);
            FTPFile[] files = ftp.listFiles();
            ftp.changeWorkingDirectory("");
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.stream(files).map(FTPFile::getName).collect(Collectors.toList()));
            return arrayList;
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to get file list from FTP(S) server", sender);
            Logger.getLogger().warn("FtpUtils:ls", e);
            ArrayList<String> arrayList = null;
            return arrayList;
        }
        finally {
            try {
                ftp.disconnect();
            }
            catch (Exception e) {
                Logger.getLogger().warn("FtpUtils; renameFile", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> ls(FTPClient ftp, String path, CommandSender sender) {
        try {
            ftp.changeWorkingDirectory(path);
            FTPFile[] files = ftp.listFiles();
            ftp.changeWorkingDirectory("");
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.stream(files).map(FTPFile::getName).collect(Collectors.toList()));
            return arrayList;
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to get file list from FTP(S) server", sender);
            Logger.getLogger().warn("FtpUtils:ls", e);
            ArrayList<String> arrayList = null;
            return arrayList;
        }
        finally {
            try {
                ftp.disconnect();
            }
            catch (Exception e) {
                Logger.getLogger().warn("FtpUtils; renameFile", e);
            }
        }
    }

    public static String resolve(String path, String fileName) {
        if (!((String)path).endsWith(pathSeparatorSymbol)) {
            path = (String)path + pathSeparatorSymbol;
        }
        return (String)path + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDirByteSize(String remoteFilePath, CommandSender sender) {
        FTPClient ftp = FtpUtils.getClient(sender);
        if (ftp == null) {
            return 0L;
        }
        try {
            long size;
            long l = size = FtpUtils.getFileFolderByteSize(ftp, remoteFilePath, sender);
            return l;
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to get dir size \"" + remoteFilePath + "\" from FTP(S) server", sender);
            Logger.getLogger().warn("FtpUtils; getDirByteSize", e);
            long l = 0L;
            return l;
        }
        finally {
            try {
                ftp.disconnect();
            }
            catch (Exception e) {
                Logger.getLogger().warn("FtpUtils; renameFile", e);
            }
        }
    }

    private static long getFileFolderByteSize(FTPClient ftp, String remoteFilePath, CommandSender sender) {
        long dirSize = 0L;
        try {
            ftp.changeWorkingDirectory("");
            FTPFile currentDir = ftp.mlistFile(remoteFilePath);
            if (currentDir.isFile()) {
                dirSize += currentDir.getSize();
            }
            if (currentDir.isDirectory()) {
                boolean dr = ftp.changeWorkingDirectory(remoteFilePath);
                FTPFile[] files = ftp.listFiles();
                if (!dr) {
                    Logger.getLogger().warn("Failed to get file list from FTP(S) server", sender);
                    return 0L;
                }
                for (FTPFile file : files) {
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    dirSize += FtpUtils.getFileFolderByteSize(ftp, FtpUtils.resolve(remoteFilePath, file.getName()), sender);
                }
            }
            ftp.changeWorkingDirectory("");
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to get dir size \"" + remoteFilePath + "\" from FTP(S) server", sender);
            Logger.getLogger().warn("FtpUtils; getFileFolderByteSize", e);
        }
        return dirSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFolder(String remoteFolderPath, CommandSender sender) {
        FTPClient ftp = FtpUtils.getClient(sender);
        try {
            ftp.mkd(remoteFolderPath);
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to create remote folder + \"" + remoteFolderPath + "\" on FTP(S) server", sender);
            Logger.getLogger().warn("FtpUtils; createRemoteFolder", e);
        }
        finally {
            try {
                ftp.disconnect();
            }
            catch (Exception e) {
                Logger.getLogger().warn("FtpUtils; renameFile", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFolder(FTPClient ftp, String remoteFolderPath, CommandSender sender) {
        try {
            ftp.mkd(remoteFolderPath);
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to create remote folder + \"" + remoteFolderPath + "\" on FTP(S) server", sender);
            Logger.getLogger().warn("FtpUtils; createRemoteFolder", e);
        }
        finally {
            try {
                ftp.disconnect();
            }
            catch (Exception e) {
                Logger.getLogger().warn("FtpUtils; renameFile", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameFile(String path, String newPath, CommandSender sender) {
        FTPClient ftp = FtpUtils.getClient(sender);
        try {
            ftp.rename(path, newPath);
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to rename file on FTP(S) server \"" + path + "\" to \"" + newPath + "\"", sender);
            Logger.getLogger().warn("FtpUtils; renameFile", e);
        }
        finally {
            try {
                ftp.disconnect();
            }
            catch (Exception e) {
                Logger.getLogger().warn("FtpUtils; renameFile", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameFile(FTPClient ftp, String path, String newPath, CommandSender sender) {
        try {
            ftp.rename(path, newPath);
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to rename file on FTP(S) server \"" + path + "\" to \"" + newPath + "\"", sender);
            Logger.getLogger().warn("FtpUtils; renameFile", e);
        }
        finally {
            try {
                ftp.disconnect();
            }
            catch (Exception e) {
                Logger.getLogger().warn("FtpUtils; renameFile", e);
            }
        }
    }

    static {
        ftps = new ArrayList();
    }
}

