/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.utils;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.media.MediaHttpDownloaderProgressListener;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.FileList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.fluent.Request;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.utils.ObfuscateUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;

public class GoogleDriveUtils {
    private static File tokensFolder;
    private static Credential credential;
    private static final String authServiceUrl = "https://auth.backuper-mc.com";
    private static final String APPLICATION_NAME = "BACKUPER";
    private static final JsonFactory JSON_FACTORY;
    private static final List<String> DRIVE_SCOPES;
    private static final NetHttpTransport NET_HTTP_TRANSPORT;
    private static final int RETRIES = 10;
    private static final int RATE_LIMIT_DELAY_MILLIS = 10000;
    private static final String FOLDER_MIME_TYPE = "application/vnd.google-apps.folder";
    private static Drive drive;

    public static void init() {
        tokensFolder = Config.getInstance().getGoogleDriveConfig().getTokenFolder();
    }

    public static Credential returnCredentialIfAuthorized(CommandSender sender) {
        try {
            boolean checkConnection = credential == null;
            GoogleClientSecrets clientSecrets = JSON_FACTORY.fromString(ObfuscateUtils.decrypt(IOUtils.toString(Utils.plugin.getResource("google_cred.txt"))), GoogleClientSecrets.class);
            GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(NET_HTTP_TRANSPORT, JSON_FACTORY, clientSecrets, DRIVE_SCOPES).setDataStoreFactory(new FileDataStoreFactory(tokensFolder)).setApprovalPrompt("force").setAccessType("offline").build();
            credential = flow.loadCredential("user");
            if (credential != null && (credential.getRefreshToken() != null || credential.getExpiresInSeconds() == null || credential.getExpiresInSeconds() > 60L)) {
                if (checkConnection) {
                    try {
                        Drive service = new Drive.Builder(NET_HTTP_TRANSPORT, JSON_FACTORY, credential).setApplicationName(APPLICATION_NAME).setHttpRequestInitializer(new HttpRequestInitializer(){

                            @Override
                            public void initialize(HttpRequest httpRequest) throws IOException {
                                credential.initialize(httpRequest);
                                httpRequest.setConnectTimeout(18000000);
                                httpRequest.setReadTimeout(18000000);
                            }
                        }).build();
                        com.google.api.services.drive.model.File driveFile = (com.google.api.services.drive.model.File)service.files().get("").execute();
                        driveFile.getName();
                    }
                    catch (GoogleJsonResponseException e) {
                        if (e.getStatusCode() != 404) {
                            credential = null;
                            return null;
                        }
                    }
                    catch (Exception e) {
                        credential = null;
                        return null;
                    }
                }
                return credential;
            }
            credential = null;
            return null;
        }
        catch (Exception e) {
            Logger.getLogger().warn(GoogleDriveUtils.class, "Failed to authorize user in Google Drive", sender);
            Logger.getLogger().warn(GoogleDriveUtils.class, e);
            credential = null;
            return null;
        }
    }

    public static boolean isAuthorized(CommandSender sender) {
        return GoogleDriveUtils.returnCredentialIfAuthorized(sender) != null;
    }

    public static Credential authorizeForced(CommandSender sender) throws IOException {
        credential = null;
        GoogleClientSecrets clientSecrets = JSON_FACTORY.fromString(ObfuscateUtils.decrypt(IOUtils.toString(Utils.plugin.getResource("google_cred.txt"))), GoogleClientSecrets.class);
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(NET_HTTP_TRANSPORT, JSON_FACTORY, clientSecrets, DRIVE_SCOPES).setDataStoreFactory(new FileDataStoreFactory(tokensFolder)).setAccessType("offline").setApprovalPrompt("force").build();
        credential = new MyAuthorizationCodeInstalledApp(flow).authorize("user", true, sender);
        return credential;
    }

    public static Drive getService(CommandSender sender) {
        if (drive != null) {
            return drive;
        }
        final Credential credential = GoogleDriveUtils.returnCredentialIfAuthorized(sender);
        if (credential == null) {
            return null;
        }
        drive = new Drive.Builder(NET_HTTP_TRANSPORT, JSON_FACTORY, credential).setApplicationName(APPLICATION_NAME).setHttpRequestInitializer(new HttpRequestInitializer(){

            @Override
            public void initialize(HttpRequest httpRequest) throws IOException {
                credential.initialize(httpRequest);
                httpRequest.setConnectTimeout(18000000);
                httpRequest.setReadTimeout(18000000);
            }
        }).build();
        return drive;
    }

    public static String uploadFile(File file, String parentFolderId, MediaHttpUploaderProgressListener progressListener, CommandSender sender) {
        return GoogleDriveUtils.uploadFile(file, file.getName(), parentFolderId, progressListener, sender);
    }

    public static void addProperty(String fileId, String key, String value, CommandSender sender) {
        int retriesCompleted = 0;
        while (retriesCompleted < 10) {
            try {
                Drive service = GoogleDriveUtils.getService(sender);
                Map<String, String> appProperties = ((com.google.api.services.drive.model.File)service.files().get(fileId).setFields("appProperties").execute()).getAppProperties();
                appProperties.put(key, value);
                service.files().update(fileId, new com.google.api.services.drive.model.File().setAppProperties(appProperties)).setFields("appProperties").execute();
                return;
            }
            catch (Exception e) {
                GoogleDriveUtils.handleException(e, sender);
                if (++retriesCompleted != 10) continue;
                return;
            }
        }
    }

    public static String uploadFile(File file, String fileName, String parentFolderId, MediaHttpUploaderProgressListener progressListener, CommandSender sender) {
        if (!file.exists()) {
            Logger.getLogger().warn(GoogleDriveUtils.class, "File does not exist: " + file.getAbsolutePath(), sender);
            return null;
        }
        int retriesCompleted = 0;
        while (retriesCompleted < 10) {
            try {
                Drive service = GoogleDriveUtils.getService(sender);
                HashMap<String, String> fileAppProperties = new HashMap<String, String>();
                fileAppProperties.put("backuper", "true");
                com.google.api.services.drive.model.File driveFileMeta = new com.google.api.services.drive.model.File();
                driveFileMeta.setAppProperties(fileAppProperties);
                driveFileMeta.setName(fileName);
                if (!Objects.equals(parentFolderId, "")) {
                    driveFileMeta.setParents(List.of(parentFolderId));
                }
                FileContent driveFileContent = new FileContent("", file);
                Drive.Files.Create driveFileCreate = service.files().create(driveFileMeta, driveFileContent).setUploadType("resumable").setFields("id, parents, appProperties");
                driveFileCreate.getMediaHttpUploader().setChunkSize(262144);
                driveFileCreate.getMediaHttpUploader().setProgressListener(progressListener);
                com.google.api.services.drive.model.File driveFile = (com.google.api.services.drive.model.File)driveFileCreate.execute();
                return driveFile.getId();
            }
            catch (Exception e) {
                GoogleDriveUtils.handleException(e, sender);
                if (++retriesCompleted != 10) continue;
                return null;
            }
        }
        return null;
    }

    public static String uploadFile(InputStream inputStream, String fileName, String parentFolderId, MediaHttpUploaderProgressListener progressListener, CommandSender sender) {
        int retriesCompleted = 0;
        while (retriesCompleted < 10) {
            try {
                Drive service = GoogleDriveUtils.getService(sender);
                HashMap<String, String> fileAppProperties = new HashMap<String, String>();
                fileAppProperties.put("backuper", "true");
                com.google.api.services.drive.model.File driveFileMeta = new com.google.api.services.drive.model.File();
                driveFileMeta.setAppProperties(fileAppProperties);
                driveFileMeta.setName(fileName);
                if (!Objects.equals(parentFolderId, "")) {
                    driveFileMeta.setParents(List.of(parentFolderId));
                }
                Drive.Files.Create driveFileCreate = service.files().create(driveFileMeta, new InputStreamContent("", inputStream)).setUploadType("resumable").setFields("id, parents, appProperties");
                driveFileCreate.getMediaHttpUploader().setChunkSize(262144);
                driveFileCreate.getMediaHttpUploader().setProgressListener(progressListener);
                com.google.api.services.drive.model.File driveFile = (com.google.api.services.drive.model.File)driveFileCreate.execute();
                return driveFile.getId();
            }
            catch (Exception e) {
                GoogleDriveUtils.handleException(e, sender);
                if (++retriesCompleted != 10) continue;
                return null;
            }
        }
        return null;
    }

    public static String createFolder(String folderName, String parentFolderId, Map<String, String> properties, CommandSender sender) {
        int retriesCompleted = 0;
        while (retriesCompleted < 10) {
            try {
                Drive service = GoogleDriveUtils.getService(sender);
                properties.put("backuper", "true");
                com.google.api.services.drive.model.File driveFileMeta = new com.google.api.services.drive.model.File();
                driveFileMeta.setName(folderName);
                driveFileMeta.setAppProperties(properties);
                if (!Objects.equals(parentFolderId, "")) {
                    driveFileMeta.setParents(List.of(parentFolderId));
                }
                driveFileMeta.setMimeType(FOLDER_MIME_TYPE);
                return ((com.google.api.services.drive.model.File)service.files().create(driveFileMeta).setFields("appProperties, id, parents").execute()).getId();
            }
            catch (Exception e) {
                GoogleDriveUtils.handleException(e, sender);
                if (++retriesCompleted != 10) continue;
                Logger.getLogger().warn(GoogleDriveUtils.class, "Failed to create folder in Google Drive", sender);
                Logger.getLogger().warn(GoogleDriveUtils.class, e);
                return null;
            }
        }
        return null;
    }

    public static String createFolder(String folderName, String parentFolderId, CommandSender sender) {
        return GoogleDriveUtils.createFolder(folderName, parentFolderId, new HashMap<String, String>(), sender);
    }

    public static void downloadFile(String fileId, File targetFile, MediaHttpDownloaderProgressListener progressListener, CommandSender sender) {
        int completedRetries = 0;
        while (completedRetries < 10) {
            try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
                Drive service = GoogleDriveUtils.getService(sender);
                Drive.Files.Get getDriveFile = service.files().get(fileId);
                getDriveFile.getMediaHttpDownloader().setProgressListener(progressListener);
                getDriveFile.executeMediaAndDownloadTo(outputStream);
                return;
            }
            catch (Exception e) {
                GoogleDriveUtils.handleException(e, sender);
                if (++completedRetries != 10) continue;
                return;
            }
        }
    }

    public static boolean isFolder(String driveFileId, CommandSender sender) throws FileNotFoundException, GoogleJsonResponseException {
        int completedRetries = 0;
        while (completedRetries < 10) {
            try {
                Drive service = GoogleDriveUtils.getService(sender);
                return ((com.google.api.services.drive.model.File)service.files().get(driveFileId).setFields("mimeType").execute()).getMimeType().equals(FOLDER_MIME_TYPE);
            }
            catch (Exception e) {
                GoogleDriveUtils.handleException(e, sender);
                if (++completedRetries != 10) continue;
                throw new FileNotFoundException();
            }
        }
        throw new FileNotFoundException();
    }

    public static List<com.google.api.services.drive.model.File> ls(String driveFileId, String query, CommandSender sender) {
        int completedRetries = 0;
        while (completedRetries < 10) {
            try {
                FileList driveFileList;
                Drive service = GoogleDriveUtils.getService(sender);
                String pageToken = null;
                ArrayList<com.google.api.services.drive.model.File> driveFiles = new ArrayList<com.google.api.services.drive.model.File>();
                do {
                    Drive.Files.List lsRequest = service.files().list().setPageToken(pageToken);
                    Object q = "appProperties has { key='backuper' and value='true' }";
                    if (query != null) {
                        q = (String)q + " and " + query;
                    }
                    if (driveFileId != null && driveFileId.equals("drive")) {
                        lsRequest = lsRequest.setSpaces("drive");
                    }
                    if (driveFileId != null && !driveFileId.isEmpty() && !driveFileId.equals("drive")) {
                        q = (String)q + " and '" + driveFileId + "' in parents";
                    }
                    lsRequest = lsRequest.setQ((String)q);
                    driveFileList = (FileList)lsRequest.execute();
                    driveFiles.addAll(driveFileList.getFiles());
                } while ((pageToken = driveFileList.getNextPageToken()) != null);
                return driveFiles;
            }
            catch (Exception e) {
                GoogleDriveUtils.handleException(e, sender);
                if (++completedRetries != 10) continue;
                return null;
            }
        }
        return null;
    }

    public static List<com.google.api.services.drive.model.File> ls(String driveFileId, CommandSender sender) {
        return GoogleDriveUtils.ls(driveFileId, null, sender);
    }

    public static void renameFile(String fileId, String newName, CommandSender sender) {
        int completedRetries = 0;
        while (completedRetries < 10) {
            try {
                Drive service = GoogleDriveUtils.getService(sender);
                service.files().update(fileId, new com.google.api.services.drive.model.File().setName(newName)).setFields("name").execute();
                return;
            }
            catch (Exception e) {
                GoogleDriveUtils.handleException(e, sender);
                if (++completedRetries != 10) continue;
                return;
            }
        }
    }

    public static void deleteFile(String fileId, CommandSender sender) {
        int completedRetries = 0;
        while (completedRetries < 10) {
            try {
                Drive service = GoogleDriveUtils.getService(sender);
                service.files().delete(fileId).execute();
                return;
            }
            catch (Exception e) {
                GoogleDriveUtils.handleException(e, sender);
                if (++completedRetries != 10) continue;
                return;
            }
        }
    }

    public static com.google.api.services.drive.model.File getFileByName(String fileName, String parentId, CommandSender sender) {
        int completedRetries = 0;
        while (completedRetries < 10) {
            try {
                Object q = "";
                q = (String)q + "name = '" + fileName + "'";
                q = (String)q + " and appProperties has { key='backuper' and value='true' }";
                Drive.Files.List lsRequest = GoogleDriveUtils.getService(sender).files().list();
                if (parentId != null && !parentId.isEmpty()) {
                    q = (String)q + " and '" + Config.getInstance().getGoogleDriveConfig().getBackupsFolderId() + "' in parents";
                }
                lsRequest.setQ((String)q);
                FileList driveFileList = (FileList)lsRequest.execute();
                return !driveFileList.getFiles().isEmpty() ? driveFileList.getFiles().get(0) : null;
            }
            catch (Exception e) {
                GoogleDriveUtils.handleException(e, sender);
                if (++completedRetries != 10) continue;
                return null;
            }
        }
        return null;
    }

    public static long getFileByteSize(String fileId, CommandSender sender) {
        int completedRetries = 0;
        while (completedRetries < 10) {
            try {
                if (GoogleDriveUtils.isFolder(fileId, sender)) {
                    long size = 0L;
                    for (com.google.api.services.drive.model.File file : GoogleDriveUtils.ls(fileId, sender)) {
                        size += GoogleDriveUtils.getFileByteSize(file.getId(), sender);
                    }
                    return size;
                }
                com.google.api.services.drive.model.File driveFile = (com.google.api.services.drive.model.File)GoogleDriveUtils.getService(sender).files().get(fileId).setFields("size").execute();
                Long size = driveFile.getSize();
                return size != null ? size : 0L;
            }
            catch (Exception e) {
                GoogleDriveUtils.handleException(e, sender);
                if (++completedRetries != 10) continue;
                return 0L;
            }
        }
        return 0L;
    }

    public static String getFileName(String fileId, CommandSender sender) {
        int completedRetries = 0;
        while (completedRetries < 10) {
            try {
                return ((com.google.api.services.drive.model.File)GoogleDriveUtils.getService(sender).files().get(fileId).setFields("name").execute()).getName();
            }
            catch (Exception e) {
                GoogleDriveUtils.handleException(e, sender);
                if (++completedRetries != 10) continue;
                return null;
            }
        }
        return null;
    }

    private static void handleException(Exception e, CommandSender sender) {
        if (e instanceof GoogleJsonResponseException) {
            GoogleJsonResponseException googleJsonResponseException = (GoogleJsonResponseException)e;
            if (googleJsonResponseException.getDetails().getCode() == 401) {
                credential = null;
                Logger.getLogger().warn("Failed to authorize user in Google Drive", sender);
                return;
            }
            if (googleJsonResponseException.getDetails().getErrors() != null) {
                if (googleJsonResponseException.getDetails().getErrors().stream().anyMatch(errorInfo -> errorInfo.getReason().equals("storageQuotaExceeded"))) {
                    Logger.getLogger().warn("Your GoogleDrive storage space limit exceeded", sender);
                    return;
                }
                if (googleJsonResponseException.getDetails().getErrors().stream().anyMatch(errorInfo -> errorInfo.getReason().equals("rateLimitExceeded"))) {
                    Logger.getLogger().devWarn(GoogleDriveUtils.class, "Rate limit exceeded, retry in 10 seconds...");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
        }
        Logger.getLogger().warn(GoogleDriveUtils.class, e);
    }

    static {
        credential = null;
        JSON_FACTORY = GsonFactory.getDefaultInstance();
        DRIVE_SCOPES = List.of("https://www.googleapis.com/auth/drive.file");
        NET_HTTP_TRANSPORT = new NetHttpTransport();
        drive = null;
    }

    private static class MyAuthorizationCodeInstalledApp {
        private AuthorizationCodeFlow flow;

        public MyAuthorizationCodeInstalledApp(AuthorizationCodeFlow flow) {
            this.flow = flow;
        }

        protected void onAuthorization(String id, CommandSender sender) {
            String url = "https://auth.backuper-mc.com/authgd?id=" + id;
            Component header = Component.empty().append((Component)Component.text((String)"Account linking"));
            Component message = ((TextComponent)((TextComponent)Component.empty().append(Component.text((String)"Log in to your Google Account:").color(TextColor.fromHexString((String)"#129c9b")))).append((Component)Component.space())).append(((TextComponent)Component.text((String)url).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.OPEN_URL, (String)url))).decorate(TextDecoration.UNDERLINED));
            UIUtils.sendFramedMessage(header, message, sender);
        }

        public Credential authorize(String userId, boolean force, CommandSender sender) throws IOException {
            int t2;
            Credential credential;
            if (!(force || (credential = this.flow.loadCredential(userId)) == null || credential.getRefreshToken() == null && credential.getExpiresInSeconds() != null && credential.getExpiresInSeconds() <= 60L)) {
                return credential;
            }
            String id = this.generateId(sender);
            this.onAuthorization(id, sender);
            String response = null;
            try {
                for (t2 = 0; t2 < 300; ++t2) {
                    String result;
                    try {
                        result = Request.Get("https://auth.backuper-mc.com/getgd?id=" + id).execute().returnContent().asString();
                    }
                    catch (Exception e) {
                        Logger.getLogger().warn(GoogleDriveUtils.class, "Google authentication failed. Probably backuper-mc.com is down, inform developer on GitHub", sender);
                        Logger.getLogger().devWarn(this.getClass(), e);
                        return null;
                    }
                    if (!result.equals("null") && !result.equals("wrong")) {
                        response = result;
                        break;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                Logger.getLogger().warn(GoogleDriveUtils.class, "Failed to get authGD server response", sender);
                Logger.getLogger().warn(this.getClass(), e);
                return null;
            }
            if (t2 >= 300) {
                Logger.getLogger().warn(GoogleDriveUtils.class, "Failed to pass Google authentication because of timeout", sender);
                return null;
            }
            Gson gson = new GsonBuilder().create();
            HashMap responseJson = gson.fromJson(response, HashMap.class);
            TokenResponse tokenResponse = new TokenResponse();
            tokenResponse.setAccessToken((String)responseJson.get("access_token"));
            tokenResponse.setScope((String)responseJson.get("scope"));
            tokenResponse.setTokenType((String)responseJson.get("token_type"));
            tokenResponse.setExpiresInSeconds(((Double)responseJson.get("expires_in")).longValue());
            tokenResponse.setRefreshToken((String)responseJson.get("refresh_token"));
            return this.flow.createAndStoreCredential(tokenResponse, userId);
        }

        private String generateId(CommandSender sender) {
            StringBuilder id = new StringBuilder();
            Random rand = new Random();
            for (int i = 0; i < 16; ++i) {
                int r = rand.nextInt(0, 62);
                if (r < 10) {
                    id.append((char)(48 + r));
                    continue;
                }
                if (r - 10 < 26) {
                    id.append((char)(65 + r - 10));
                    continue;
                }
                id.append((char)(97 + r - 36));
            }
            return id.toString();
        }
    }
}

