/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.utils;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;

public class SftpUtils {
    private static String sshConfigFile;
    private static String authType;
    private static String address;
    private static String username;
    private static String password;
    private static String backupsFolder;
    private static String keyFilePath;
    private static String useKnownHostsFile;
    private static String knownHostsFilePath;
    private static String pathSeparatorSymbol;
    private static int port;

    public static void init() {
        sshConfigFile = Config.getInstance().getSftpConfig().getSshConfigFile();
        authType = Config.getInstance().getSftpConfig().getAuthType();
        address = Config.getInstance().getSftpConfig().getAddress();
        username = Config.getInstance().getSftpConfig().getUsername();
        password = Config.getInstance().getSftpConfig().getPassword();
        backupsFolder = Config.getInstance().getSftpConfig().getBackupsFolder();
        keyFilePath = Config.getInstance().getSftpConfig().getKeyFilePath();
        useKnownHostsFile = Config.getInstance().getSftpConfig().getUseKnownHostsFile();
        knownHostsFilePath = Config.getInstance().getSftpConfig().getKnownHostsFilePath();
        pathSeparatorSymbol = Config.getInstance().getSftpConfig().getPathSeparatorSymbol();
        port = Config.getInstance().getSftpConfig().getPort();
    }

    public static boolean checkConnection(CommandSender sender) {
        if (!Config.getInstance().getSftpConfig().isEnabled()) {
            return false;
        }
        Pair<Session, ChannelSftp> channelSftp = SftpUtils.createChannel(sender);
        boolean connected = channelSftp != null;
        try {
            channelSftp.getLeft().disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            channelSftp.getRight().exit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connected;
    }

    public static Pair<Session, ChannelSftp> createChannel(CommandSender sender) {
        if (!(authType.equals("password") || authType.equals("key") || authType.equals("key_pass"))) {
            Logger.getLogger().warn("Failed to connect to SFTP server", sender);
            Logger.getLogger().warn("Wrong authType: \"" + authType + "\"", sender);
            return null;
        }
        Session sshSession = null;
        ChannelSftp sftpChannel = null;
        try {
            block16: {
                JSch jsch = new JSch();
                try {
                    if (Objects.equals(sshConfigFile, "")) {
                        throw new RuntimeException();
                    }
                    jsch.setConfigRepository(OpenSSHConfig.parseFile(sshConfigFile));
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        Logger.getLogger().warn("Failed to load ssh config specified in config sftp.auth.sshConfigFile", sender);
                    }
                    if (authType.equals("key")) {
                        jsch.addIdentity(keyFilePath);
                    }
                    if (authType.equals("key_pass")) {
                        jsch.addIdentity(keyFilePath, password);
                    }
                    sshSession = jsch.getSession(username, address, port);
                    if (authType.equals("password")) {
                        sshSession.setPassword(password);
                    }
                    Properties config = new Properties();
                    if (useKnownHostsFile.equals("false")) {
                        config.put("StrictHostKeyChecking", "no");
                    } else {
                        config.put("StrictHostKeyChecking", "yes");
                    }
                    sshSession.setConfig(config);
                    if (useKnownHostsFile.equals("false")) break block16;
                    jsch.setKnownHosts(knownHostsFilePath);
                }
            }
            sshSession.connect(15000);
            sftpChannel = (ChannelSftp)sshSession.openChannel("sftp");
            return Pair.of(sshSession, sftpChannel);
        }
        catch (JSchException e) {
            try {
                sshSession.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sftpChannel.exit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getLogger().warn("Failed to connect to SFTP server", sender);
            Logger.getLogger().devWarn("SftpUtils; createSftpChannel", (Exception)e);
            return null;
        }
    }

    public static void createFolder(String remoteFolderPath, CommandSender sender) {
        Pair<Session, ChannelSftp> sessionChannelSftpPair = SftpUtils.createChannel(sender);
        Session session = sessionChannelSftpPair.getLeft();
        ChannelSftp sftpChannel = sessionChannelSftpPair.getRight();
        if (sftpChannel == null) {
            return;
        }
        try {
            sftpChannel.connect(10000);
            sftpChannel.mkdir(remoteFolderPath);
            sftpChannel.exit();
            session.disconnect();
        }
        catch (Exception e) {
            try {
                session.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sftpChannel.exit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getLogger().warn("Failed to create remote folder + \"" + remoteFolderPath + "\"", sender);
            Logger.getLogger().warn("SftpUtils; createRemoteFolder", e);
        }
    }

    public static String resolve(String path, String fileName) {
        if (!((String)path).endsWith(pathSeparatorSymbol)) {
            path = (String)path + pathSeparatorSymbol;
        }
        return (String)path + fileName;
    }

    public static void renameFile(String remoteFilePath, String newFilePath, CommandSender sender) {
        Pair<Session, ChannelSftp> sessionChannelSftpPair = SftpUtils.createChannel(sender);
        Session session = sessionChannelSftpPair.getLeft();
        ChannelSftp sftpChannel = sessionChannelSftpPair.getRight();
        if (sftpChannel == null) {
            return;
        }
        try {
            sftpChannel.connect(10000);
            sftpChannel.rename(remoteFilePath, newFilePath);
            sftpChannel.exit();
            session.disconnect();
        }
        catch (Exception e) {
            try {
                session.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sftpChannel.exit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getLogger().warn("Failed to rename \"" + remoteFilePath + "\" to \"" + newFilePath + "\"", sender);
            Logger.getLogger().warn("SftpUtils; renameRemoteFolder", e);
        }
    }

    public static ArrayList<String> ls(String remoteFolderPath, CommandSender sender) {
        Pair<Session, ChannelSftp> sessionChannelSftpPair = SftpUtils.createChannel(sender);
        Session session = sessionChannelSftpPair.getLeft();
        ChannelSftp sftpChannel = sessionChannelSftpPair.getRight();
        if (sftpChannel == null) {
            return null;
        }
        try {
            sftpChannel.connect(10000);
            Vector<ChannelSftp.LsEntry> ls = sftpChannel.ls(remoteFolderPath);
            ArrayList<String> files = new ArrayList<String>();
            for (ChannelSftp.LsEntry entry : ls) {
                files.add(entry.getFilename());
            }
            sftpChannel.exit();
            session.disconnect();
            return files;
        }
        catch (Exception e) {
            try {
                sftpChannel.exit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                session.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getLogger().warn("Failed to get file list from folder \"" + remoteFolderPath + "\"", sender);
            Logger.getLogger().warn("SftpUtils; ls", e);
            return null;
        }
    }

    public static long getDirByteSize(String remoteFilePath, CommandSender sender) {
        Pair<Session, ChannelSftp> sessionChannelSftpPair = SftpUtils.createChannel(sender);
        Session session = sessionChannelSftpPair.getLeft();
        ChannelSftp sftpChannel = sessionChannelSftpPair.getRight();
        if (sftpChannel == null) {
            return 0L;
        }
        try {
            sftpChannel.connect(10000);
            long size = SftpUtils.getFileFolderByteSize(sftpChannel, remoteFilePath, sender);
            sftpChannel.exit();
            session.disconnect();
            return size;
        }
        catch (Exception e) {
            try {
                session.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sftpChannel.exit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getLogger().warn("Failed to get dir size \"" + remoteFilePath + "\"", sender);
            Logger.getLogger().warn("SftpUtils; getDirByteSize", e);
            return 0L;
        }
    }

    private static long getFileFolderByteSize(ChannelSftp sftpChannel, String remoteFilePath, CommandSender sender) {
        long dirSize = 0L;
        try {
            if (!sftpChannel.stat(remoteFilePath).isDir()) {
                dirSize += sftpChannel.stat(remoteFilePath).getSize();
            } else {
                for (ChannelSftp.LsEntry entry : sftpChannel.ls(remoteFilePath)) {
                    if (entry.getFilename().equals(".") || entry.getFilename().equals("..")) continue;
                    dirSize += SftpUtils.getFileFolderByteSize(sftpChannel, SftpUtils.resolve(remoteFilePath, entry.getFilename()), sender);
                }
            }
        }
        catch (SftpException e) {
            Logger.getLogger().warn("Failed to get dir size \"" + remoteFilePath + "\"", sender);
            Logger.getLogger().warn("SftpUtils; getFileFolderByteSize", (Exception)e);
        }
        return dirSize;
    }
}

