/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.utils;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class UIUtils {
    public static void returnFailure(String message, CommandSender sender) {
        try {
            sender.sendMessage(Component.text((String)message).color((TextColor)NamedTextColor.RED));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void returnFailure(String message, CommandSender sender, TextColor color) {
        try {
            sender.sendMessage(Component.text((String)message).color(color));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void returnSuccess(String message, CommandSender sender) {
        try {
            sender.sendMessage((Component)Component.text((String)message));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void returnSuccess(String message, CommandSender sender, TextColor color) {
        try {
            sender.sendMessage(String.valueOf(color) + message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void returnWarning(String message, CommandSender sender) {
        try {
            sender.sendMessage(Component.text((String)message).color((TextColor)NamedTextColor.RED));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void returnWarning(String message, CommandSender sender, TextColor color) {
        try {
            sender.sendMessage(String.valueOf(color) + message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendMessage(String message, CommandSender sender) {
        try {
            sender.sendMessage(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cancelSound(CommandSender sender) {
        try {
            Class.forName("net.kyori.adventure.sound.Sound").getMethod("sound", new Class[0]);
            sender.playSound((Sound)Sound.sound((Sound)Sound.sound((Key)Key.key((String)"block.anvil.place"), (Sound.Source)Sound.Source.MASTER, (float)50.0f, (float)1.0f)).build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void normalSound(CommandSender sender) {
        try {
            Class.forName("net.kyori.adventure.sound.Sound").getMethod("sound", new Class[0]);
            sender.playSound((Sound)Sound.sound((Sound)Sound.sound((Key)Key.key((String)"ui.button.click"), (Sound.Source)Sound.Source.MASTER, (float)50.0f, (float)1.0f)).build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void successSound(CommandSender sender) {
        try {
            Class.forName("net.kyori.adventure.sound.Sound").getMethod("sound", new Class[0]);
            sender.playSound((Sound)Sound.sound((Sound)Sound.sound((Key)Key.key((String)"entity.player.levelup"), (Sound.Source)Sound.Source.MASTER, (float)50.0f, (float)1.0f)).build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void notificationSound(CommandSender sender) {
        try {
            Class.forName("net.kyori.adventure.sound.Sound").getMethod("sound", new Class[0]);
            sender.playSound((Sound)Sound.sound((Sound)Sound.sound((Key)Key.key((String)"entity.player.levelup"), (Sound.Source)Sound.Source.MASTER, (float)50.0f, (float)50.0f)).build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendFramedMessage(Component message, CommandSender sender) {
        try {
            TextComponent framedMessage = Component.empty();
            if (sender instanceof ConsoleCommandSender) {
                framedMessage = framedMessage.append((Component)Component.newline());
            }
            framedMessage = framedMessage.append(((TextComponent)Component.text((String)"------------------------------------------").decorate(TextDecoration.BOLD)).color(TextColor.color((int)1326711))).append((Component)Component.newline());
            framedMessage = framedMessage.append(message);
            framedMessage = framedMessage.append((Component)Component.newline()).append(((TextComponent)Component.text((String)"------------------------------------------").decorate(TextDecoration.BOLD)).color(TextColor.color((int)1326711)));
            sender.sendMessage((Component)framedMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendFramedMessage(Component message, int dashNumber, CommandSender sender) {
        try {
            TextComponent framedMessage = Component.empty();
            if (sender instanceof ConsoleCommandSender) {
                framedMessage = framedMessage.append((Component)Component.newline());
            }
            framedMessage = framedMessage.append(((TextComponent)Component.text((String)"-".repeat(dashNumber)).decorate(TextDecoration.BOLD)).color(TextColor.color((int)1326711))).append((Component)Component.newline());
            framedMessage = framedMessage.append(message);
            framedMessage = framedMessage.append((Component)Component.newline()).append(((TextComponent)Component.text((String)"-".repeat(dashNumber)).decorate(TextDecoration.BOLD)).color(TextColor.color((int)1326711)));
            sender.sendMessage((Component)framedMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendFramedMessage(Component header, Component message, CommandSender sender) {
        try {
            TextComponent framedMessage = Component.empty();
            if (sender instanceof ConsoleCommandSender) {
                framedMessage = framedMessage.append((Component)Component.newline());
            }
            framedMessage = framedMessage.append(((TextComponent)Component.text((String)"------------------------------------------").decorate(TextDecoration.BOLD)).color(TextColor.color((int)1326711))).append((Component)Component.newline());
            framedMessage = framedMessage.append(header).append((Component)Component.newline());
            framedMessage = framedMessage.append(((TextComponent)Component.text((String)"------------------------------------------").decorate(TextDecoration.BOLD)).color(TextColor.fromHexString((String)"#129c9b"))).append((Component)Component.newline());
            framedMessage = framedMessage.append(message);
            framedMessage = framedMessage.append((Component)Component.newline()).append(((TextComponent)Component.text((String)"------------------------------------------").decorate(TextDecoration.BOLD)).color(TextColor.color((int)1326711)));
            sender.sendMessage((Component)framedMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendFramedMessage(Component header, Component message, int dashNumber, CommandSender sender) {
        try {
            TextComponent framedMessage = Component.empty();
            if (sender instanceof ConsoleCommandSender) {
                framedMessage = framedMessage.append((Component)Component.newline());
            }
            framedMessage = framedMessage.append(((TextComponent)Component.text((String)"-".repeat(dashNumber)).decorate(TextDecoration.BOLD)).color(TextColor.color((int)1326711))).append((Component)Component.newline());
            framedMessage = framedMessage.append(header).append((Component)Component.newline());
            framedMessage = framedMessage.append(((TextComponent)Component.text((String)"-".repeat(dashNumber)).decorate(TextDecoration.BOLD)).color(TextColor.fromHexString((String)"#129c9b"))).append((Component)Component.newline());
            framedMessage = framedMessage.append(message);
            framedMessage = framedMessage.append((Component)Component.newline()).append(((TextComponent)Component.text((String)"-".repeat(dashNumber)).decorate(TextDecoration.BOLD)).color(TextColor.color((int)1326711)));
            sender.sendMessage((Component)framedMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendBackupAlert(long timeSeconds, String afterBackup) {
        boolean restart = false;
        if (afterBackup.equals("STOP")) {
            Logger.getLogger().log(Config.getInstance().getAlertBackupRestartMessage().formatted(timeSeconds));
            restart = true;
        }
        if (afterBackup.equals("RESTART")) {
            Logger.getLogger().log(Config.getInstance().getAlertBackupRestartMessage().formatted(timeSeconds));
            restart = true;
        }
        if (afterBackup.equals("NOTHING")) {
            Logger.getLogger().log(Config.getInstance().getAlertBackupMessage().formatted(timeSeconds));
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission(Permissions.ALERT.getPermission()) || !restart && Config.getInstance().isAlertOnlyServerRestart()) continue;
            TextComponent header = Component.empty();
            header = header.append(Component.text((String)"Alert").decorate(TextDecoration.BOLD));
            TextComponent message = Component.empty();
            message = message.append((Component)Component.text((String)(restart ? Config.getInstance().getAlertBackupRestartMessage() : Config.getInstance().getAlertBackupMessage()).formatted(timeSeconds)));
            UIUtils.sendFramedMessage((Component)header, (Component)message, 15, (CommandSender)player);
            UIUtils.notificationSound((CommandSender)player);
        }
    }
}

