/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public abstract class Command {
    protected CommandSender sender;
    protected CommandArguments arguments;

    protected Command(CommandSender sender, CommandArguments arguments) {
        this.sender = sender;
        this.arguments = arguments;
    }

    public abstract void execute();

    protected void returnSuccess(String message) {
        UIUtils.returnSuccess(message, this.sender);
    }

    protected void returnSuccess(String message, TextColor color) {
        UIUtils.returnSuccess(message, this.sender, color);
    }

    protected void returnFailure(String message) {
        UIUtils.returnFailure(message, this.sender);
    }

    protected void returnFailure(String message, TextColor color) {
        UIUtils.returnFailure(message, this.sender, color);
    }

    protected void returnWarning(String message, TextColor color) {
        UIUtils.returnWarning(message, this.sender, color);
    }

    protected void returnWarning(String message) {
        UIUtils.returnWarning(message, this.sender);
    }

    protected void sendMessage(String message) {
        UIUtils.sendMessage(message, this.sender);
    }

    protected void cancelSound() {
        UIUtils.cancelSound(this.sender);
    }

    protected void buttonSound() {
        UIUtils.normalSound(this.sender);
    }

    protected void successSound() {
        UIUtils.successSound(this.sender);
    }

    protected void notificationSound() {
        UIUtils.notificationSound(this.sender);
    }

    protected void sendFramedMessage(Component message) {
        UIUtils.sendFramedMessage(message, this.sender);
    }

    protected void sendFramedMessage(Component message, int dashNumber) {
        UIUtils.sendFramedMessage(message, dashNumber, this.sender);
    }

    protected void sendFramedMessage(Component header, Component message) {
        UIUtils.sendFramedMessage(header, message, this.sender);
    }

    protected void sendFramedMessage(Component header, Component message, int dashNumber) {
        UIUtils.sendFramedMessage(header, message, dashNumber, this.sender);
    }
}

