/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.list;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.backup.FtpBackup;
import ru.dvdishka.backuper.backend.backup.GoogleDriveBackup;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.backup.SftpBackup;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class ListCommand
extends Command {
    public static ArrayList<ArrayList<TextComponent>> pages;
    private String storage;
    private boolean sendResult = true;
    private HashMap<String, Long> backupNameMbSize = new HashMap();
    private HashMap<String, String> backupNameFileType = new HashMap();

    public ListCommand(String storage, CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
        this.storage = storage;
    }

    public ListCommand(String storage, boolean sendResult, CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
        this.storage = storage;
        this.sendResult = sendResult;
    }

    @Override
    public void execute() {
        File backupsFolder;
        if (this.storage.equals("local") && !Config.getInstance().getLocalConfig().isEnabled() || this.storage.equals("sftp") && !Config.getInstance().getSftpConfig().isEnabled() || this.storage.equals("ftp") && !Config.getInstance().getFtpConfig().isEnabled() || this.storage.equals("googleDrive") && (!Config.getInstance().getGoogleDriveConfig().isEnabled() || !GoogleDriveUtils.isAuthorized(this.sender))) {
            this.cancelSound();
            if (!this.storage.equals("googleDrive")) {
                this.returnFailure(this.storage + " storage is disabled!");
            } else {
                this.returnFailure(this.storage + " storage is disabled or Google account is not linked!");
            }
            return;
        }
        if (this.storage.equals("local") && (!(backupsFolder = new File(Config.getInstance().getLocalConfig().getBackupsFolder())).exists() || backupsFolder.listFiles() == null)) {
            this.returnFailure("Wrong local.backupsFolder config value! (Maybe the specified folder does not exist)");
            this.cancelSound();
            return;
        }
        if (this.sendResult) {
            this.sendMessage("Creating a list of backups may take some time...");
        }
        this.buttonSound();
        int listPageCount = this.getListPageCount();
        if (listPageCount == 0) {
            if (this.sendResult) {
                this.returnFailure("There are no backups yet!");
            }
            this.cancelSound();
            return;
        }
        int pageNumber = (Integer)this.arguments.getOrDefault("pageNumber", (Object)1);
        if (pageNumber < 1 || pageNumber > listPageCount) {
            if (this.sendResult) {
                this.returnFailure("Invalid page number!");
            }
            this.cancelSound();
            return;
        }
        TextComponent header = Component.empty();
        header = header.append(Component.text((String)"Backup list").decorate(TextDecoration.BOLD)).append((Component)Component.space()).append(((TextComponent)Component.text((String)("(" + this.storage + ")")).color(TextColor.fromHexString((String)"#129c9b"))).decorate(TextDecoration.BOLD));
        if (this.sendResult) {
            if (!(this.sender instanceof ConsoleCommandSender)) {
                this.sendFramedMessage((Component)header, this.createListMessage(pageNumber, true), 15);
            } else {
                this.sendFramedMessage((Component)header, this.createListMessage(pageNumber, this.arguments.get("pageNumber") != null), 41);
            }
        }
        this.buttonSound();
    }

    private void updateListPages() {
        ArrayList<Backup> backups = null;
        if (this.storage.equals("local")) {
            backups = this.getSortedDecreaseLocalBackupList();
        }
        if (this.storage.equals("sftp")) {
            backups = this.getSortedDecreaseSftpBackupList();
        }
        if (this.storage.equals("ftp")) {
            backups = this.getSortedDecreaseFtpBackupList();
        }
        if (this.storage.equals("googleDrive")) {
            backups = this.getSortedDecreaseGoogleDriveBackupList();
        }
        if (backups == null) {
            Logger.getLogger().warn("Something went wrong while trying to get backup list!", this.sender);
            return;
        }
        ArrayList pages = new ArrayList();
        for (int i = 1; i <= backups.size(); ++i) {
            if (i % 10 == 1) {
                pages.add(new ArrayList());
            }
            Backup backup = backups.get(i - 1);
            String backupName = backup.getName();
            String backupFormattedName = backup.getFormattedName();
            String backupFileType = backup.getFileType();
            long backupMbSize = backup.getMbSize(this.sender);
            this.backupNameMbSize.put(backupFormattedName, backupMbSize);
            this.backupNameFileType.put(backupFormattedName, backupFileType);
            HoverEvent hoverEvent = HoverEvent.showText((Component)Component.text((String)("(" + this.storage + ") " + backupFileType + " " + backupMbSize + " MB")));
            ClickEvent clickEvent = ClickEvent.runCommand((String)("/backuper menu " + this.storage + " \"" + backupName + "\""));
            ((ArrayList)pages.get((i - 1) / 10)).add((TextComponent)((TextComponent)Component.text((String)backupFormattedName).hoverEvent((HoverEventSource)hoverEvent)).clickEvent(clickEvent));
        }
        ListCommand.pages = pages;
    }

    private Component createListMessage(int pageNumber, boolean pagedListMessage) {
        TextComponent message = Component.empty();
        if (!(this.sender instanceof ConsoleCommandSender)) {
            message = message.append(((TextComponent)((TextComponent)Component.text((String)"<<<<<<<<").decorate(TextDecoration.BOLD)).color(TextColor.fromHexString((String)"#129c9b"))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/backuper list " + this.storage + " " + (pageNumber - 1))))).append(Component.text((String)String.valueOf(pageNumber)).decorate(TextDecoration.BOLD)).append(((TextComponent)((TextComponent)Component.text((String)">>>>>>>>").decorate(TextDecoration.BOLD)).color(TextColor.fromHexString((String)"#129c9b"))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/backuper list " + this.storage + " " + (pageNumber + 1))))).append((Component)Component.newline());
            for (TextComponent backupComponent : pages.get(pageNumber - 1)) {
                message = message.append((Component)Component.space()).append((Component)backupComponent).append((Component)Component.newline());
            }
            message = message.append(((TextComponent)((TextComponent)Component.text((String)"<<<<<<<<").decorate(TextDecoration.BOLD)).color(TextColor.fromHexString((String)"#129c9b"))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/backuper list " + this.storage + " " + (pageNumber - 1))))).append(Component.text((String)String.valueOf(pageNumber)).decorate(TextDecoration.BOLD)).append(((TextComponent)((TextComponent)Component.text((String)">>>>>>>>").decorate(TextDecoration.BOLD)).color(TextColor.fromHexString((String)"#129c9b"))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/backuper list " + this.storage + " " + (pageNumber + 1)))));
        } else {
            int backupIndex = 1;
            if (pagedListMessage) {
                message = message.append(((TextComponent)Component.text((String)"<".repeat(20)).decorate(TextDecoration.BOLD)).color(TextColor.fromHexString((String)"#129c9b"))).append((Component)Component.text((int)pageNumber)).append(((TextComponent)Component.text((String)">".repeat(20)).decorate(TextDecoration.BOLD)).color(TextColor.fromHexString((String)"#129c9b"))).append((Component)Component.newline());
                for (TextComponent backupComponent : pages.get(pageNumber - 1)) {
                    if (backupIndex > 1) {
                        message = message.append((Component)Component.newline());
                    }
                    String backupName = backupComponent.content();
                    message = message.append((Component)Component.text((String)backupName)).append((Component)Component.space()).append((Component)Component.text((String)this.storage)).append((Component)Component.space()).append((Component)Component.text((String)this.backupNameFileType.get(backupName))).append((Component)Component.space()).append((Component)Component.text((long)this.backupNameMbSize.get(backupName))).append((Component)Component.space()).append((Component)Component.text((String)" MB"));
                    ++backupIndex;
                }
                message = message.append((Component)Component.newline()).append(((TextComponent)Component.text((String)"<".repeat(20)).decorate(TextDecoration.BOLD)).color(TextColor.fromHexString((String)"#129c9b"))).append((Component)Component.text((int)pageNumber)).append(((TextComponent)Component.text((String)">".repeat(20)).decorate(TextDecoration.BOLD)).color(TextColor.fromHexString((String)"#129c9b")));
            } else {
                for (ArrayList<TextComponent> page : pages) {
                    for (TextComponent backupComponent : page) {
                        if (backupIndex > 1) {
                            message = message.append((Component)Component.newline());
                        }
                        String backupName = backupComponent.content();
                        message = message.append((Component)Component.text((String)backupComponent.content())).append((Component)Component.space()).append((Component)Component.text((String)this.storage)).append((Component)Component.space()).append((Component)Component.text((String)this.backupNameFileType.get(backupName))).append((Component)Component.space()).append((Component)Component.text((long)this.backupNameMbSize.get(backupName))).append((Component)Component.space()).append((Component)Component.text((String)" MB"));
                        ++backupIndex;
                    }
                }
            }
        }
        return message;
    }

    private int getListPageCount() {
        this.updateListPages();
        return pages.size();
    }

    private ArrayList<Backup> getSortedDecreaseLocalBackupList() {
        ArrayList<Backup> backups = new ArrayList<Backup>(LocalBackup.getBackups());
        this.sortBackupsDecrease(backups);
        return backups;
    }

    private ArrayList<Backup> getSortedDecreaseFtpBackupList() {
        ArrayList<Backup> backups = new ArrayList<Backup>(FtpBackup.getBackups());
        this.sortBackupsDecrease(backups);
        return backups;
    }

    private ArrayList<Backup> getSortedDecreaseSftpBackupList() {
        ArrayList<Backup> backups = new ArrayList<Backup>(SftpBackup.getBackups());
        this.sortBackupsDecrease(backups);
        return backups;
    }

    private ArrayList<Backup> getSortedDecreaseGoogleDriveBackupList() {
        ArrayList<Backup> backups = new ArrayList<Backup>(GoogleDriveBackup.getBackups());
        this.sortBackupsDecrease(backups);
        return backups;
    }

    private void sortBackupsDecrease(ArrayList<Backup> backups) {
        for (int firstBackupsIndex = 0; firstBackupsIndex < backups.size(); ++firstBackupsIndex) {
            for (int secondBackupsIndex = firstBackupsIndex; secondBackupsIndex < backups.size(); ++secondBackupsIndex) {
                if (!backups.get(firstBackupsIndex).getLocalDateTime().isBefore(backups.get(secondBackupsIndex).getLocalDateTime())) continue;
                Backup save = backups.get(firstBackupsIndex);
                backups.set(firstBackupsIndex, backups.get(secondBackupsIndex));
                backups.set(secondBackupsIndex, save);
            }
        }
    }
}

