/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu.copyToGoogleDrive;

import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.backup.GoogleDriveBackup;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.backup.StorageType;
import ru.dvdishka.backuper.backend.common.Scheduler;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.googleDrive.GoogleDriveSendFileFolderTask;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.Permissions;
import ru.dvdishka.backuper.handlers.commands.task.status.StatusCommand;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class CopyToGoogleDriveCommand
extends Command {
    public CopyToGoogleDriveCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public void execute() {
        if (!Config.getInstance().getLocalConfig().isEnabled()) {
            this.cancelSound();
            this.returnFailure("Local storage is disabled");
            return;
        }
        if (!Config.getInstance().getGoogleDriveConfig().isEnabled() || !GoogleDriveUtils.isAuthorized(this.sender)) {
            this.cancelSound();
            this.returnFailure("Google Drive storage is disabled or Google account is not linked!");
            return;
        }
        LocalBackup localBackup = LocalBackup.getInstance((String)this.arguments.get("backupName"));
        if (localBackup == null) {
            this.cancelSound();
            this.returnFailure("Wrong backup name");
            return;
        }
        if (Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("Blocked by another operation!");
            return;
        }
        for (GoogleDriveBackup googleDriveBackup : GoogleDriveBackup.getBackups()) {
            if (!googleDriveBackup.getName().equals(localBackup.getName())) continue;
            this.cancelSound();
            this.returnFailure("Google Drive storage already contains this backup");
            return;
        }
        this.buttonSound();
        StatusCommand.sendTaskStartedMessage("CopyToGoogleDrive", this.sender);
        Scheduler.getScheduler().runAsync(Utils.plugin, () -> {
            String inProgressName = localBackup.getName() + " in progress";
            if (localBackup.getFileType().equals("(ZIP)")) {
                inProgressName = inProgressName + ".zip";
            }
            GoogleDriveSendFileFolderTask task = new GoogleDriveSendFileFolderTask(localBackup.getFile(), Config.getInstance().getGoogleDriveConfig().getBackupsFolderId(), inProgressName, true, true, true, List.of(Permissions.LOCAL_COPY_TO_GOOGLE_DRIVE), this.sender);
            ((Task)task).run();
            if (!task.isCancelled()) {
                GoogleDriveUtils.renameFile(GoogleDriveUtils.getFileByName(inProgressName, Config.getInstance().getGoogleDriveConfig().getBackupsFolderId(), this.sender).getId(), localBackup.getFileName(), this.sender);
                Backup.saveBackupSizeToCache(StorageType.GOOGLE_DRIVE, localBackup.getName(), ((Task)task).getTaskMaxProgress());
            }
            this.sendMessage("CopyToGoogleDrive task completed");
        });
    }
}

