/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu.copyToGoogleDrive;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class CopyToGoogleDriveConfirmationCommand
extends Command {
    public CopyToGoogleDriveConfirmationCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public void execute() {
        if (!Config.getInstance().getLocalConfig().isEnabled()) {
            this.cancelSound();
            this.returnFailure("Local storage is disabled");
            return;
        }
        if (!Config.getInstance().getGoogleDriveConfig().isEnabled() || !GoogleDriveUtils.isAuthorized(this.sender)) {
            this.cancelSound();
            this.returnFailure("Google Drive storage is disabled or Google account is not linked!");
            return;
        }
        LocalBackup localBackup = LocalBackup.getInstance((String)this.arguments.get("backupName"));
        if (localBackup == null) {
            this.cancelSound();
            this.returnFailure("Wrong backup name");
            return;
        }
        String backupName = localBackup.getName();
        String backupFormattedName = localBackup.getFormattedName();
        if (Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("Blocked by another operation!");
            return;
        }
        this.buttonSound();
        long backupSize = localBackup.getMbSize(this.sender);
        String zipFolderBackup = localBackup.getFileType();
        TextComponent header = Component.empty();
        header = header.append(((TextComponent)Component.text((String)"Confirm copying to GoogleDrive").decorate(TextDecoration.BOLD)).color(TextColor.color((int)11542784)));
        TextComponent message = Component.empty();
        message = message.append(Component.text((String)backupFormattedName).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("(local) " + zipFolderBackup + " " + backupSize + " MB"))))).append((Component)Component.newline()).append((Component)Component.newline());
        message = message.append(((TextComponent)((TextComponent)Component.text((String)"[COPY TO GoogleDrive]").clickEvent(ClickEvent.runCommand((String)("/backuper menu local \"" + backupName + "\" copyToSftp")))).color(TextColor.color((int)11542784))).decorate(TextDecoration.BOLD));
        this.sendFramedMessage((Component)header, (Component)message, 15);
    }
}

