/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu.copyToSftp;

import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.backup.SftpBackup;
import ru.dvdishka.backuper.backend.common.Scheduler;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.sftp.SftpSendFileFolderTask;
import ru.dvdishka.backuper.backend.utils.SftpUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.Permissions;
import ru.dvdishka.backuper.handlers.commands.task.status.StatusCommand;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class CopyToSftpCommand
extends Command {
    public CopyToSftpCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public void execute() {
        if (!Config.getInstance().getLocalConfig().isEnabled()) {
            this.cancelSound();
            this.returnFailure("Local storage is disabled");
            return;
        }
        if (!Config.getInstance().getSftpConfig().isEnabled()) {
            this.cancelSound();
            this.returnFailure("SFTP storage is disabled");
            return;
        }
        LocalBackup localBackup = LocalBackup.getInstance((String)this.arguments.get("backupName"));
        if (localBackup == null) {
            this.cancelSound();
            this.returnFailure("Wrong backup name");
            return;
        }
        if (Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("Blocked by another operation!");
            return;
        }
        for (SftpBackup sftpBackup : SftpBackup.getBackups()) {
            if (!sftpBackup.getName().equals(localBackup.getName())) continue;
            this.cancelSound();
            this.returnFailure("Sftp storage already contains this backup");
            return;
        }
        this.buttonSound();
        StatusCommand.sendTaskStartedMessage("CopyToSftp", this.sender);
        Scheduler.getScheduler().runAsync(Utils.plugin, () -> {
            String inProgressName = localBackup.getName() + " in progress";
            if (localBackup.getFileType().equals("(ZIP)")) {
                inProgressName = inProgressName + ".zip";
            }
            SftpSendFileFolderTask task = new SftpSendFileFolderTask(localBackup.getFile(), SftpUtils.resolve(Config.getInstance().getSftpConfig().getBackupsFolder(), inProgressName), false, true, true, List.of(Permissions.LOCAL_COPY_TO_SFTP), this.sender);
            ((Task)task).run();
            if (!task.isCancelled()) {
                SftpUtils.renameFile(SftpUtils.resolve(Config.getInstance().getSftpConfig().getBackupsFolder(), inProgressName), SftpUtils.resolve(Config.getInstance().getSftpConfig().getBackupsFolder(), localBackup.getFileName()), this.sender);
            }
            this.sendMessage("CopyToSftp task completed");
        });
    }
}

