/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu.delete;

import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.ExternalBackup;
import ru.dvdishka.backuper.backend.backup.FtpBackup;
import ru.dvdishka.backuper.backend.backup.GoogleDriveBackup;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.backup.SftpBackup;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.common.Scheduler;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.task.status.StatusCommand;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class DeleteCommand
extends Command {
    private String storage = "";

    public DeleteCommand(String storage, CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
        this.storage = storage;
    }

    @Override
    public void execute() {
        String backupName = (String)this.arguments.get("backupName");
        if (this.storage.equals("local") && !Config.getInstance().getLocalConfig().isEnabled() || this.storage.equals("sftp") && !Config.getInstance().getSftpConfig().isEnabled() || this.storage.equals("ftp") && !Config.getInstance().getFtpConfig().isEnabled() || this.storage.equals("googleDrive") && (!Config.getInstance().getGoogleDriveConfig().isEnabled() || !GoogleDriveUtils.isAuthorized(this.sender))) {
            this.cancelSound();
            if (!this.storage.equals("googleDrive")) {
                this.returnFailure(this.storage + " storage is disabled!");
            } else {
                this.returnFailure(this.storage + " storage is disabled or Google account is not linked!");
            }
            return;
        }
        if (this.storage.equals("local") && !LocalBackup.checkBackupExistenceByName(backupName) || this.storage.equals("sftp") && !SftpBackup.checkBackupExistenceByName(backupName) || this.storage.equals("ftp") && !FtpBackup.checkBackupExistenceByName(backupName) || this.storage.equals("googleDrive") && !GoogleDriveBackup.checkBackupExistenceByName(backupName)) {
            this.cancelSound();
            this.returnFailure("Backup does not exist!");
            return;
        }
        if (Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("Blocked by another operation!");
            return;
        }
        ExternalBackup backup = null;
        if (this.storage.equals("local")) {
            backup = LocalBackup.getInstance(backupName);
        }
        if (this.storage.equals("sftp")) {
            backup = SftpBackup.getInstance(backupName);
        }
        if (this.storage.equals("ftp")) {
            backup = FtpBackup.getInstance(backupName);
        }
        if (this.storage.equals("googleDrive")) {
            backup = GoogleDriveBackup.getInstance(backupName);
        }
        this.buttonSound();
        StatusCommand.sendTaskStartedMessage("Delete", this.sender);
        ExternalBackup finalBackup = backup;
        Scheduler.getScheduler().runAsync(Utils.plugin, () -> {
            try {
                finalBackup.delete(true, this.sender);
                this.successSound();
                this.sendMessage("Delete task completed");
            }
            catch (Exception e) {
                Logger.getLogger().warn("Delete task has been finished with an exception!", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
                this.cancelSound();
            }
        });
    }
}

