/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu.toZIP;

import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.common.Scheduler;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.task.status.StatusCommand;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class ToZIPCommand
extends Command {
    public ToZIPCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public void execute() {
        String backupName = (String)this.arguments.get("backupName");
        if (!Config.getInstance().getLocalConfig().isEnabled()) {
            this.cancelSound();
            this.returnFailure("local storage is disabled!");
            return;
        }
        if (!LocalBackup.checkBackupExistenceByName(backupName)) {
            this.cancelSound();
            this.returnFailure("Backup does not exist!");
            return;
        }
        assert (backupName != null);
        LocalBackup localBackup = LocalBackup.getInstance(backupName);
        if (localBackup.getFileType().equals("(ZIP)")) {
            this.cancelSound();
            this.returnFailure("Backup is already ZIP!");
            return;
        }
        if (Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("Blocked by another operation!");
            return;
        }
        this.buttonSound();
        StatusCommand.sendTaskStartedMessage("ToZIP", this.sender);
        Scheduler.getScheduler().runAsync(Utils.plugin, () -> {
            try {
                localBackup.toZip(true, this.sender);
                this.sendMessage("ToZIP task completed");
            }
            catch (Exception e) {
                this.cancelSound();
                Backuper.unlock();
                Logger.getLogger().warn("Something went wrong while running ToZIP task", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
            }
        });
    }
}

