/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu.toZIP;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class ToZIPConfirmationCommand
extends Command {
    public ToZIPConfirmationCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public void execute() {
        String backupName = (String)this.arguments.get("backupName");
        if (!Config.getInstance().getLocalConfig().isEnabled()) {
            this.cancelSound();
            this.returnFailure("local storage is disabled!");
            return;
        }
        if (!LocalBackup.checkBackupExistenceByName(backupName)) {
            this.cancelSound();
            this.returnFailure("Backup does not exist!");
            return;
        }
        assert (backupName != null);
        LocalBackup localBackup = LocalBackup.getInstance(backupName);
        String backupFormattedName = localBackup.getFormattedName();
        long backupSize = localBackup.getMbSize(this.sender);
        String zipFolderBackup = localBackup.getFileType();
        if (zipFolderBackup.equals("(ZIP)")) {
            this.cancelSound();
            this.returnFailure("Backup is already ZIP!");
            return;
        }
        if (Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("Backup is blocked by another operation!");
            return;
        }
        this.buttonSound();
        TextComponent header = Component.empty();
        header = header.append(((TextComponent)Component.text((String)"Confirm ToZIP").decorate(TextDecoration.BOLD)).color(TextColor.color((int)11542784)));
        TextComponent message = Component.empty();
        message = message.append(Component.text((String)backupFormattedName).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("(local) " + zipFolderBackup + " " + backupSize + " MB"))))).append((Component)Component.newline()).append((Component)Component.newline());
        message = message.append(((TextComponent)((TextComponent)Component.text((String)"[CONVERT BACKUP]").clickEvent(ClickEvent.runCommand((String)("/backuper menu local \"" + backupName + "\" toZIP")))).color(TextColor.color((int)11542784))).decorate(TextDecoration.BOLD));
        this.sendFramedMessage((Component)header, (Component)message, 15);
    }
}

