/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu.unZIP;

import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.common.Scheduler;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.task.status.StatusCommand;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class UnZIPCommand
extends Command {
    public UnZIPCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public void execute() {
        String backupName = (String)this.arguments.get("backupName");
        if (!Config.getInstance().getLocalConfig().isEnabled()) {
            this.cancelSound();
            this.returnFailure("local storage is disabled!");
            return;
        }
        if (!LocalBackup.checkBackupExistenceByName(backupName)) {
            this.cancelSound();
            this.returnFailure("Backup does not exist!");
            return;
        }
        assert (backupName != null);
        LocalBackup localBackup = LocalBackup.getInstance(backupName);
        if (localBackup.getFileType().equals("(Folder)")) {
            this.cancelSound();
            this.returnFailure("Backup is already Folder!");
            return;
        }
        if (Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("Blocked by another operation!");
            return;
        }
        this.buttonSound();
        StatusCommand.sendTaskStartedMessage("UnZIP", this.sender);
        Scheduler.getScheduler().runAsync(Utils.plugin, () -> {
            try {
                localBackup.unZip(true, this.sender);
                this.sendMessage("UnZIP task completed");
            }
            catch (Exception e) {
                Backuper.unlock();
                Logger.getLogger().warn("The UnZIP task has been finished with an exception!", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
                this.cancelSound();
            }
        });
    }
}

