/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.shade.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import ru.dvdishka.shade.commandapi.arguments.CommandAPIArgumentType;
import ru.dvdishka.shade.commandapi.arguments.SafeOverrideableArgument;
import ru.dvdishka.shade.commandapi.exceptions.InvalidRangeException;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class IntegerArgument
extends SafeOverrideableArgument<Integer, Integer> {
    public IntegerArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)IntegerArgumentType.integer(), String::valueOf);
    }

    public IntegerArgument(String nodeName, int min2) {
        super(nodeName, (ArgumentType<?>)IntegerArgumentType.integer((int)min2), String::valueOf);
    }

    public IntegerArgument(String nodeName, int min2, int max) {
        super(nodeName, (ArgumentType<?>)IntegerArgumentType.integer((int)min2, (int)max), String::valueOf);
        if (max < min2) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Integer> getPrimitiveType() {
        return Integer.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_INTEGER;
    }

    @Override
    public <Source> Integer parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return (Integer)cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

