/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper;

import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.dvdishka.backuper.backend.Bstats;
import ru.dvdishka.backuper.backend.LogManager;
import ru.dvdishka.backuper.backend.ScheduleManager;
import ru.dvdishka.backuper.backend.autobackup.AutoBackupScheduleManager;
import ru.dvdishka.backuper.backend.config.ConfigManager;
import ru.dvdishka.backuper.backend.storage.StorageManager;
import ru.dvdishka.backuper.backend.task.SetWorldsWritableTask;
import ru.dvdishka.backuper.backend.task.TaskManager;
import ru.dvdishka.backuper.backend.util.UIUtils;
import ru.dvdishka.backuper.backend.util.Utils;
import ru.dvdishka.backuper.handlers.commands.CommandManager;
import ru.dvdishka.backuper.handlers.worldchangecatch.WorldChangeCatcherNew;
import ru.dvdishka.shade.commandapi.CommandAPI;
import ru.dvdishka.shade.commandapi.CommandAPIPaperConfig;

public class Backuper
extends JavaPlugin
implements Listener {
    private TaskManager taskManager;
    private LogManager logManager;
    private ConfigManager configManager;
    private ScheduleManager scheduleManager;
    private StorageManager storageManager;
    private CommandManager commandManager;
    private AutoBackupScheduleManager autoBackupScheduleManager;
    private Bstats bstats;
    private static Backuper instance;
    public static boolean restarting;

    public void onEnable() {
        instance = this;
        CommandAPI.onEnable();
        this.registerEventHandlers();
        this.init();
        this.commandManager.registerCommands();
        this.scheduleManager.runAsync(() -> this.storageManager.indexStorages());
        Backuper.getInstance().getLogManager().log("Backuper plugin has been enabled!");
    }

    public void init() {
        this.configManager = new ConfigManager();
        this.logManager = new LogManager();
        this.taskManager = new TaskManager();
        this.taskManager.forceLock();
        this.storageManager = new StorageManager();
        this.commandManager = new CommandManager();
        this.autoBackupScheduleManager = new AutoBackupScheduleManager();
        this.bstats = new Bstats();
        File pluginDir = new File("plugins/Backuper");
        File configFile = new File("plugins/Backuper/config.yml");
        if (!pluginDir.exists() && !pluginDir.mkdirs()) {
            Backuper.getInstance().getLogManager().warn("Can not create plugins/Backuper dir!");
        }
        this.configManager.load(configFile, (CommandSender)Bukkit.getConsoleSender());
        this.scheduleManager = new ScheduleManager();
        this.scheduleManager.runAsync(() -> {
            this.storageManager.loadSizeCache();
            this.storageManager.checkStoragesConnection();
        });
        this.bstats.init(this);
        this.checkDependencies();
        this.checkPluginVersion();
        this.sendIssueToGitHub((CommandSender)Bukkit.getConsoleSender());
        Backuper.getInstance().getScheduleManager().runAsync(() -> this.sendPluginVersionCheckResult((CommandSender)Bukkit.getConsoleSender()));
        this.taskManager.forceUnlock();
        this.autoBackupScheduleManager.init();
    }

    public void shutdown() {
        this.taskManager.forceLock();
        this.storageManager.saveSizeCache();
        SetWorldsWritableTask setWorldsWritableTask = new SetWorldsWritableTask();
        try {
            this.getTaskManager().startTaskRaw(setWorldsWritableTask, (CommandSender)Bukkit.getConsoleSender());
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().warn(e);
        }
        Backuper.getInstance().getScheduleManager().destroy((Plugin)this);
        this.configManager.setConfigField("lastBackup", this.configManager.getLastBackup());
        this.configManager.setConfigField("lastChange", this.configManager.getLastChange());
        this.storageManager.destroy();
        this.autoBackupScheduleManager.destroy();
        this.scheduleManager.destroy((Plugin)this);
        this.bstats.destroy();
    }

    public void onLoad() {
        CommandAPI.onLoad(new CommandAPIPaperConfig((LifecycleEventOwner)this).fallbackToLatestNMS(true));
    }

    public void onDisable() {
        this.shutdown();
        CommandAPI.onDisable();
        Backuper.getInstance().getLogManager().log("Backuper plugin has been disabled!");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.sendPluginVersionCheckResult((CommandSender)event.getPlayer());
    }

    private void registerEventHandlers() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Backuper.getInstance());
        Bukkit.getPluginManager().registerEvents((Listener)new StorageManager(), (Plugin)Backuper.getInstance());
        boolean doWorldChangeEventExist = true;
        for (String eventName : WorldChangeCatcherNew.eventNames) {
            try {
                Class.forName(eventName);
            }
            catch (Exception e) {
                doWorldChangeEventExist = false;
            }
        }
        if (doWorldChangeEventExist) {
            Bukkit.getPluginManager().registerEvents((Listener)new WorldChangeCatcherNew(), (Plugin)Backuper.getInstance());
        }
    }

    private void checkDependencies() {
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.EntityScheduler");
            Utils.isFolia = true;
            Backuper.getInstance().getLogManager().devLog("Folia/Paper(1.20+) has been detected!");
        }
        catch (Exception e) {
            Utils.isFolia = false;
            Backuper.getInstance().getLogManager().devLog("Folia/Paper(1.20+) has not been detected!");
        }
    }

    private boolean checkPluginVersion() {
        if (!Backuper.getInstance().getConfigManager().getServerConfig().isCheckUpdates()) {
            return true;
        }
        try {
            String input;
            HttpURLConnection connection = (HttpURLConnection)Utils.getLatestVersionURL.openConnection();
            connection.setRequestMethod("GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((input = in.readLine()) != null) {
                response.append(input);
            }
            in.close();
            return response.toString().equals(Utils.getProperty("version"));
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().warn("Failed to check the Backuper updates!");
            Backuper.getInstance().getLogManager().warn(e);
            return true;
        }
    }

    private void sendPluginVersionCheckResult(CommandSender sender) {
        if (sender.isOp() && !this.checkPluginVersion()) {
            TextComponent header = Component.empty();
            header = header.append(((TextComponent)Component.text((String)"Backuper is outdated").decorate(TextDecoration.BOLD)).color((TextColor)NamedTextColor.RED));
            TextComponent message = Component.empty();
            message = message.append((Component)Component.text((String)"You are using an outdated version of Backuper!\nPlease update it to the latest and check the changelist!"));
            int downloadLinkNumber = 0;
            for (String downloadLink : Utils.downloadLinks) {
                message = message.append((Component)Component.newline());
                message = message.append((Component)Component.text((String)"Download link:")).append((Component)Component.space()).append(((TextComponent)Component.text((String)(sender instanceof ConsoleCommandSender ? downloadLink : Utils.downloadLinksName.get(downloadLinkNumber))).clickEvent(ClickEvent.openUrl((String)downloadLink))).decorate(TextDecoration.UNDERLINED));
                ++downloadLinkNumber;
            }
            UIUtils.sendFramedMessage((Component)header, (Component)message, sender);
        }
    }

    private void sendIssueToGitHub(CommandSender sender) {
        if (!sender.isOp()) {
            return;
        }
        TextComponent header = Component.empty();
        header = header.append(((TextComponent)Component.text((String)"Issue tracking").decorate(TextDecoration.BOLD)).color((TextColor)NamedTextColor.RED));
        TextComponent message = Component.empty();
        message = message.append((Component)Component.text((String)"Please, if you find any issues related to the Backuper")).append((Component)Component.newline()).append((Component)Component.text((String)"Create an issue using the link:")).append((Component)Component.space()).append(((TextComponent)Component.text((String)"https://github.com/DVDishka/Backuper/issues").clickEvent(ClickEvent.openUrl((String)"https://github.com/DVDishka/Backuper/issues"))).decorate(TextDecoration.UNDERLINED));
        UIUtils.sendFramedMessage((Component)header, (Component)message, sender);
    }

    @Generated
    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    @Generated
    public LogManager getLogManager() {
        return this.logManager;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    @Generated
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Generated
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Generated
    public AutoBackupScheduleManager getAutoBackupScheduleManager() {
        return this.autoBackupScheduleManager;
    }

    @Generated
    public Bstats getBstats() {
        return this.bstats;
    }

    @Generated
    public static Backuper getInstance() {
        return instance;
    }

    static {
        restarting = false;
    }
}

