/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.autobackup;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import lombok.Generated;
import org.bukkit.plugin.Plugin;
import org.quartz.CronTrigger;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.autobackup.AutoBackupCronJob;
import ru.dvdishka.backuper.backend.autobackup.AutoBackupJobScheduler;
import ru.dvdishka.backuper.backend.autobackup.AutoBackupScheduleManager;

public class AutoBackupJobCronScheduler
implements AutoBackupJobScheduler {
    private final AutoBackupScheduleManager autoBackupScheduleManager;
    private CronTrigger cronTrigger;
    private boolean firstAlert = true;

    public AutoBackupJobCronScheduler(AutoBackupScheduleManager autoBackupScheduleManager) {
        this.autoBackupScheduleManager = autoBackupScheduleManager;
    }

    @Override
    public void init() {
        this.cronTrigger = Backuper.getInstance().getScheduleManager().runCronScheduledJob(AutoBackupCronJob.class, "backup", "auto", Backuper.getInstance().getConfigManager().getBackupConfig().getAutoBackupCron());
    }

    @Override
    public long getNextBackupDelaySeconds() {
        Date nextFireTime = this.firstAlert ? this.cronTrigger.getNextFireTime() : this.cronTrigger.getFireTimeAfter(this.cronTrigger.getNextFireTime());
        return nextFireTime.getTime() / 1000L - LocalDateTime.now().toEpochSecond(ZoneOffset.ofHours(nextFireTime.getTimezoneOffset() / 60 * -1));
    }

    @Override
    public void scheduleNextBackupAlert() {
        Backuper.getInstance().getScheduleManager().runGlobalRegionDelayed((Plugin)Backuper.getInstance(), () -> {
            this.getAutoBackupScheduleManager().getAutoBackupJob().executeAlert(this.getNextAlertMessageSeconds(), Backuper.getInstance().getConfigManager().getBackupConfig().getAfterBackup());
            this.firstAlert = false;
        }, this.getNextBackupAlertDelaySeconds() * 20L);
    }

    @Override
    @Generated
    public AutoBackupScheduleManager getAutoBackupScheduleManager() {
        return this.autoBackupScheduleManager;
    }
}

