/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.config;

import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.quartz.CronExpression;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.config.Config;

public class BackupConfig
implements Config {
    private boolean autoBackup;
    private long autoBackupPeriod;
    private CronExpression autoBackupCron;
    private String backupFileNameFormat;
    private List<String> addDirectoryToBackup;
    private List<String> excludeDirectoryFromBackup;
    private boolean deleteBrokenBackups;
    private boolean skipDuplicateBackup;
    private String afterBackup;
    private boolean setWorldsReadOnly;
    private DateTimeFormatter dateTimeFormatter;
    private ConfigurationSection config;

    @Override
    public BackupConfig load(ConfigurationSection config, String name) {
        this.config = config;
        boolean autoBackup = config.getBoolean("autoBackup");
        this.autoBackupPeriod = config.getLong("autoBackupPeriod");
        CronExpression autoBackupCron = null;
        if (autoBackup && !config.getString("autoBackupCron").isEmpty()) {
            try {
                autoBackupCron = new CronExpression(config.getString("autoBackupCron"));
            }
            catch (ParseException e) {
                Backuper.getInstance().getLogManager().warn("Failed to parse backup.autoBackupCron! Using autoBackupPeriod instead");
                Backuper.getInstance().getLogManager().warn(e);
            }
        }
        this.autoBackup = autoBackup;
        this.autoBackupCron = autoBackupCron;
        String backupFileNameFormat = config.getString("backupFileNameFormat");
        this.addDirectoryToBackup = config.getStringList("addDirectoryToBackup");
        this.excludeDirectoryFromBackup = config.getStringList("excludeDirectoryFromBackup");
        this.deleteBrokenBackups = config.getBoolean("deleteBrokenBackups");
        this.skipDuplicateBackup = config.getBoolean("skipDuplicateBackup");
        this.afterBackup = config.getString("afterBackup").toUpperCase();
        this.setWorldsReadOnly = config.getBoolean("setWorldsReadOnly");
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(backupFileNameFormat);
            LocalDateTime localDateTime = LocalDateTime.parse(LocalDateTime.now().format(dateTimeFormatter), dateTimeFormatter);
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().warn("Wrong backupFileNameFormat format: \"%s\", using default \"dd-MM-yyyy HH-mm-ss\" value...".formatted(backupFileNameFormat));
            Backuper.getInstance().getLogManager().warn(e);
            backupFileNameFormat = "dd-MM-yyyy HH-mm-ss";
        }
        this.backupFileNameFormat = backupFileNameFormat;
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(backupFileNameFormat);
        return this;
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Backuper.getInstance().getResource("backup_config.yml")));
    }

    @Generated
    public boolean isAutoBackup() {
        return this.autoBackup;
    }

    @Generated
    public long getAutoBackupPeriod() {
        return this.autoBackupPeriod;
    }

    @Generated
    public CronExpression getAutoBackupCron() {
        return this.autoBackupCron;
    }

    @Generated
    public String getBackupFileNameFormat() {
        return this.backupFileNameFormat;
    }

    @Generated
    public List<String> getAddDirectoryToBackup() {
        return this.addDirectoryToBackup;
    }

    @Generated
    public List<String> getExcludeDirectoryFromBackup() {
        return this.excludeDirectoryFromBackup;
    }

    @Generated
    public boolean isDeleteBrokenBackups() {
        return this.deleteBrokenBackups;
    }

    @Generated
    public boolean isSkipDuplicateBackup() {
        return this.skipDuplicateBackup;
    }

    @Generated
    public String getAfterBackup() {
        return this.afterBackup;
    }

    @Generated
    public boolean isSetWorldsReadOnly() {
        return this.setWorldsReadOnly;
    }

    @Generated
    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    @Override
    @Generated
    public ConfigurationSection getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(ConfigurationSection config) {
        this.config = config;
    }
}

