/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.config;

import java.io.InputStreamReader;
import java.io.Reader;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.config.PathStorageConfig;
import ru.dvdishka.backuper.backend.util.Utils;

public class LocalConfig
implements PathStorageConfig {
    private String id;
    private boolean enabled;
    private boolean autoBackup;
    private String backupsFolder;
    private int backupsNumber;
    private long backupsWeight;
    private boolean zipArchive;
    private int zipCompressionLevel;
    private String pathSeparatorSymbol = Utils.isWindows ? "\\" : "/";
    private ConfigurationSection config;

    @Override
    public LocalConfig load(ConfigurationSection config, String name) {
        this.config = config;
        this.id = name;
        this.enabled = config.getBoolean("enabled");
        this.autoBackup = config.getBoolean("autoBackup");
        int backupsNumber = config.getInt("maxBackupsNumber");
        long backupsWeight = config.getLong("maxBackupsWeight") * 0x100000L;
        this.zipArchive = config.getBoolean("zipArchive");
        this.backupsFolder = config.getString("backupsFolder");
        int zipCompressionLevel = config.getInt("zipCompressionLevel");
        if (backupsNumber < 0) {
            Backuper.getInstance().getLogManager().warn("Failed to load config value!");
            Backuper.getInstance().getLogManager().warn("%s.maxBackupsNumber must be >= 0, using default 0 value...".formatted(config.getCurrentPath()));
            backupsNumber = 0;
        }
        this.backupsNumber = backupsNumber;
        if (backupsWeight < 0L) {
            Backuper.getInstance().getLogManager().warn("Failed to load config value!");
            Backuper.getInstance().getLogManager().warn("%s.maxBackupsWeight must be >= 0, using default 0 value...".formatted(config.getCurrentPath()));
            backupsWeight = 0L;
        }
        this.backupsWeight = backupsWeight;
        if (zipCompressionLevel > 9 || zipCompressionLevel < 0) {
            Backuper.getInstance().getLogManager().warn("Failed to load config value!");
            if (zipCompressionLevel < 0) {
                Backuper.getInstance().getLogManager().warn("%s.zipCompressionLevel must be >= 0, using 0 value...".formatted(config.getCurrentPath()));
                zipCompressionLevel = 0;
            }
            if (zipCompressionLevel > 9) {
                Backuper.getInstance().getLogManager().warn("%s.zipCompressionLevel must be <= 9, using 9 value...".formatted(config.getCurrentPath()));
                zipCompressionLevel = 9;
            }
        }
        this.zipCompressionLevel = zipCompressionLevel;
        return this;
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Backuper.getInstance().getResource("local_config.yml")));
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Generated
    public boolean isAutoBackup() {
        return this.autoBackup;
    }

    @Override
    @Generated
    public String getBackupsFolder() {
        return this.backupsFolder;
    }

    @Override
    @Generated
    public int getBackupsNumber() {
        return this.backupsNumber;
    }

    @Override
    @Generated
    public long getBackupsWeight() {
        return this.backupsWeight;
    }

    @Override
    @Generated
    public boolean isZipArchive() {
        return this.zipArchive;
    }

    @Override
    @Generated
    public int getZipCompressionLevel() {
        return this.zipCompressionLevel;
    }

    @Override
    @Generated
    public String getPathSeparatorSymbol() {
        return this.pathSeparatorSymbol;
    }

    @Override
    @Generated
    public ConfigurationSection getConfig() {
        return this.config;
    }
}

