/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.BackupManager;
import ru.dvdishka.backuper.backend.config.LocalConfig;
import ru.dvdishka.backuper.backend.storage.PathStorage;
import ru.dvdishka.backuper.backend.storage.StorageType;
import ru.dvdishka.backuper.backend.storage.exception.StorageConnectionException;
import ru.dvdishka.backuper.backend.storage.exception.StorageLimitException;
import ru.dvdishka.backuper.backend.storage.exception.StorageMethodException;
import ru.dvdishka.backuper.backend.storage.util.StorageProgressInputStream;
import ru.dvdishka.backuper.backend.storage.util.StorageProgressListener;
import ru.dvdishka.backuper.backend.util.Utils;

public class LocalStorage
implements PathStorage {
    private String id = null;
    private final BackupManager backupManager;
    private final LocalConfig config;
    private final int FILE_BUFFER_SIZE = 65536;

    public LocalStorage(LocalConfig config) {
        this.config = config;
        this.backupManager = new BackupManager(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public StorageType getType() {
        return StorageType.LOCAL;
    }

    @Override
    public LocalConfig getConfig() {
        return this.config;
    }

    @Override
    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    @Override
    public boolean checkConnection() {
        return this.checkConnection(null);
    }

    @Override
    public boolean checkConnection(CommandSender sender) {
        try {
            if (!this.config.isEnabled()) {
                Backuper.getInstance().getLogManager().warn("Local storage is disabled in config.yml", sender);
                return false;
            }
            File folder = new File(this.config.getBackupsFolder());
            if (!folder.exists() && !folder.mkdirs()) {
                Backuper.getInstance().getLogManager().warn("Failed to create local backups folder: %s".formatted(this.config.getBackupsFolder()), sender);
                return false;
            }
            if (!folder.isDirectory()) {
                Backuper.getInstance().getLogManager().warn("Local backups folder is not a directory: %s".formatted(this.config.getBackupsFolder()), sender);
                return false;
            }
            if (!folder.canRead() || !folder.canWrite()) {
                Backuper.getInstance().getLogManager().warn("Local backups folder is not accessible (read/write permissions): %s".formatted(this.config.getBackupsFolder()), sender);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().warn("Failed to check local storage connection", sender);
            Backuper.getInstance().getLogManager().warn(e);
            return false;
        }
    }

    @Override
    public List<String> ls(String path) throws StorageMethodException, StorageConnectionException {
        try {
            File directory = new File(path);
            if (!directory.exists() || !directory.isDirectory()) {
                throw new StorageMethodException(this, "Directory does not exist or is not a directory: %s".formatted(path));
            }
            File[] files = directory.listFiles();
            if (files == null) {
                throw new StorageMethodException(this, "Failed to list files in directory: %s".formatted(path));
            }
            ArrayList<String> fileNames = new ArrayList<String>();
            for (File file : files) {
                fileNames.add(file.getName());
            }
            return fileNames;
        }
        catch (Exception e) {
            throw new StorageMethodException(this, "Failed to get file list from dir \"%s\" using local storage".formatted(path), e);
        }
    }

    @Override
    public boolean exists(String path) throws StorageMethodException, StorageConnectionException {
        return new File(path).exists();
    }

    @Override
    public boolean isFile(String path) throws StorageMethodException, StorageConnectionException {
        File file = new File(path);
        if (!file.exists()) {
            throw new StorageMethodException(this, "File \"%s\" does not exist".formatted(path));
        }
        return file.isFile();
    }

    @Override
    public long getDirByteSize(String path) throws StorageMethodException, StorageConnectionException {
        try {
            File file = new File(path);
            if (!file.exists()) {
                throw new StorageMethodException(this, "File or directory does not exist: %s".formatted(path));
            }
            return Utils.getFileFolderByteSize(file);
        }
        catch (Exception e) {
            throw new StorageMethodException(this, "Failed to get \"%s\" dir size using local storage".formatted(path), e);
        }
    }

    @Override
    public void createDir(String newDirName, String parentDir) throws StorageMethodException, StorageConnectionException {
        try {
            File folder = new File(this.resolve(parentDir, newDirName));
            if (folder.exists()) {
                if (!folder.isDirectory()) {
                    throw new StorageMethodException(this, "Path exists but is not a directory: %s".formatted(parentDir));
                }
                return;
            }
            if (!folder.mkdirs()) {
                throw new StorageMethodException(this, "Failed to create directory: %s".formatted(parentDir));
            }
        }
        catch (Exception e) {
            throw new StorageMethodException(this, "Failed to create dir \"%s\" using local storage".formatted(parentDir), e);
        }
    }

    @Override
    public void uploadFile(InputStream sourceStream, String newFileName, String targetParentDir, StorageProgressListener progressListener) throws StorageLimitException, StorageMethodException, StorageConnectionException {
        File target = new File(this.resolve(targetParentDir, newFileName));
        try (FileOutputStream targetStream = new FileOutputStream(target);){
            int read;
            byte[] buffer = new byte[65536];
            while ((read = sourceStream.read(buffer)) != -1) {
                ((OutputStream)targetStream).write(buffer, 0, read);
                progressListener.incrementProgress(read);
            }
        }
        catch (IOException e) {
            throw new StorageMethodException(this, "Failed to copy stream to \"%s\" in %s storage".formatted(target.getAbsolutePath(), this.id), e);
        }
    }

    @Override
    public InputStream downloadFile(String sourcePath, StorageProgressListener progressListener) throws StorageMethodException, StorageConnectionException {
        File file = new File(sourcePath);
        if (!file.exists()) {
            throw new StorageMethodException(this, "Source file \"%s\" does not exist".formatted(sourcePath));
        }
        try {
            return new StorageProgressInputStream(new FileInputStream(file), progressListener);
        }
        catch (IOException e) {
            throw new StorageMethodException(this, "Failed to get file's \"%s\" input stream from \"%s\" storage".formatted(sourcePath, this.id), e);
        }
    }

    @Override
    public void delete(String path) throws StorageMethodException, StorageConnectionException {
        File file = new File(path);
        if (!file.delete()) {
            throw new StorageMethodException(this, "Failed to delete \"%s\" file/dir from local storage".formatted(path));
        }
    }

    @Override
    public void renameFile(String path, String newFileName) throws StorageMethodException, StorageConnectionException {
        File sourceFile = new File(path);
        File targetFile = new File(this.resolve(this.getParentPath(path), newFileName));
        if (!sourceFile.exists()) {
            throw new StorageMethodException(this, "Source file does not exist: %s".formatted(path));
        }
        if (targetFile.exists()) {
            throw new StorageMethodException(this, "Target file already exists: %s".formatted(newFileName));
        }
        File parentDir = targetFile.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new StorageMethodException(this, "Failed to create parent directory for: %s".formatted(newFileName));
        }
        for (int i = 0; i < 1000000; ++i) {
            try {
                if (sourceFile.renameTo(targetFile)) break;
                Files.move(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                break;
            }
            catch (Exception e) {
                if (i != 999999) continue;
                throw new StorageMethodException(this, "Failed to rename file \"%s\" to \"%s\" using local storage".formatted(path, newFileName), e);
            }
        }
    }

    @Override
    public int getStorageSpeedMultiplier() {
        return 1;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void downloadCompleted() throws StorageMethodException, StorageConnectionException {
    }

    @Override
    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

