/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.storage;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.BackupManager;
import ru.dvdishka.backuper.backend.config.SftpConfig;
import ru.dvdishka.backuper.backend.storage.PathStorage;
import ru.dvdishka.backuper.backend.storage.SftpClientProvider;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.storage.StorageType;
import ru.dvdishka.backuper.backend.storage.exception.StorageConnectionException;
import ru.dvdishka.backuper.backend.storage.exception.StorageLimitException;
import ru.dvdishka.backuper.backend.storage.exception.StorageMethodException;
import ru.dvdishka.backuper.backend.storage.util.Retriable;
import ru.dvdishka.backuper.backend.storage.util.StorageProgressListener;

public class SftpStorage
implements PathStorage {
    private String id = null;
    private final SftpConfig config;
    private final BackupManager backupManager;
    private final SftpClientProvider mainClient;
    private final SftpClientProvider downloadClient;
    private final SftpClientProvider uploadClient;
    private static final int FILE_BUFFER_SIZE = 65536;
    private final Retriable.RetriableExceptionHandler retriableExceptionHandler = new Retriable.RetriableExceptionHandler(){

        @Override
        public void handleRegularException(Exception e) {
            if (e instanceof SocketTimeoutException || e.getMessage() != null && e.getMessage().contains("Read timed out")) {
                Backuper.getInstance().getLogManager().devWarn("SFTP read timeout");
            } else if (e instanceof SocketException && e.getMessage() != null && (e.getMessage().contains("Connection reset") || e.getMessage().contains("Connection closed") || e.getMessage().contains("Broken pipe"))) {
                Backuper.getInstance().getLogManager().devWarn("SFTP connection reset");
            } else if (e instanceof JSchException && e.getMessage() != null && e.getMessage().contains("session is down")) {
                Backuper.getInstance().getLogManager().devWarn("SFTP session is down");
            }
        }

        @Override
        public RuntimeException handleFinalException(Exception e) {
            if (e instanceof JSchException && e.getMessage() != null) {
                if (e.getMessage().contains("auth fail") || e.getMessage().contains("Authentication fail")) {
                    return new StorageConnectionException(this.getStorage(), "Authentication failed to SFTP server", e);
                }
                if (e.getMessage().contains("UnknownHostException") || e.getMessage().contains("Connection refused") || e.getMessage().contains("connect failed")) {
                    return new StorageConnectionException(this.getStorage(), "Failed to establish connection to SFTP server", e);
                }
                if (e.getMessage().contains("timeout") || e.getMessage().contains("timed out") || e.getMessage().contains("session is down")) {
                    return new StorageConnectionException(this.getStorage(), "Connection timed out", e);
                }
            }
            if (e instanceof SftpException) {
                SftpException sftpException = (SftpException)e;
                if (sftpException.id == 2) {
                    return new StorageMethodException(this.getStorage(), "File not found", e);
                }
                if (sftpException.id == 3 || sftpException.id == 4) {
                    return new StorageMethodException(this.getStorage(), "Permission denied", e);
                }
                if (sftpException.id == 5 || e.getMessage() != null && (e.getMessage().contains("disk full") || e.getMessage().contains("quota exceeded"))) {
                    return new StorageLimitException(this.getStorage(), "SFTP storage quota exceeded", e);
                }
            }
            return new StorageMethodException(this.getStorage(), e.getMessage(), e);
        }

        public Storage getStorage() {
            return SftpStorage.this;
        }
    };

    public SftpStorage(SftpConfig config) {
        this.config = config;
        this.backupManager = new BackupManager(this);
        this.mainClient = new SftpClientProvider(this);
        this.downloadClient = new SftpClientProvider(this);
        this.uploadClient = new SftpClientProvider(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public StorageType getType() {
        return StorageType.SFTP;
    }

    @Override
    public SftpConfig getConfig() {
        return this.config;
    }

    @Override
    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    @Override
    public boolean checkConnection() {
        return this.checkConnection(null);
    }

    @Override
    public boolean checkConnection(CommandSender sender) {
        try {
            this.mainClient.getClient();
            this.downloadClient.getClient();
            this.uploadClient.getClient();
            return true;
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().warn("Failed to establish connection to the SFTP server", sender);
            Backuper.getInstance().getLogManager().warn(e);
            return false;
        }
    }

    @Override
    public List<String> ls(String path) throws StorageMethodException, StorageConnectionException {
        return ((Retriable<List>)() -> {
            SftpClientProvider sftpClientProvider = this.mainClient;
            synchronized (sftpClientProvider) {
                ChannelSftp sftp = this.mainClient.getClient();
                return sftp.ls(path).stream().map(ChannelSftp.LsEntry::getFilename).filter(file -> !file.equals(".") && !file.equals("..")).toList();
            }
        }).retry(this.retriableExceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String path) throws StorageMethodException, StorageConnectionException {
        SftpClientProvider sftpClientProvider = this.mainClient;
        synchronized (sftpClientProvider) {
            ChannelSftp sftp = this.mainClient.getClient();
            try {
                sftp.stat(path);
                return true;
            }
            catch (SftpException e) {
                return false;
            }
        }
    }

    @Override
    public boolean isFile(String path) throws StorageMethodException, StorageConnectionException {
        return ((Retriable<Boolean>)() -> {
            SftpClientProvider sftpClientProvider = this.mainClient;
            synchronized (sftpClientProvider) {
                ChannelSftp sftp = this.mainClient.getClient();
                return !sftp.stat(path).isDir();
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public long getDirByteSize(String path) throws StorageMethodException, StorageConnectionException {
        return ((Retriable<Long>)() -> {
            AbstractList files = new ArrayList();
            long dirSize = 0L;
            SftpClientProvider sftpClientProvider = this.mainClient;
            synchronized (sftpClientProvider) {
                ChannelSftp sftp = this.mainClient.getClient();
                if (!sftp.stat(path).isDir()) {
                    dirSize += sftp.stat(path).getSize();
                } else {
                    files = sftp.ls(path);
                }
            }
            for (ChannelSftp.LsEntry entry : files) {
                if (entry.getFilename().equals(".") || entry.getFilename().equals("..")) continue;
                dirSize += this.getDirByteSize(this.resolve(path, entry.getFilename()));
            }
            return dirSize;
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public void createDir(String newDirName, String parentDir) throws StorageMethodException, StorageConnectionException {
        ((Retriable<Void>)() -> {
            SftpClientProvider sftpClientProvider = this.mainClient;
            synchronized (sftpClientProvider) {
                ChannelSftp sftp = this.mainClient.getClient();
                sftp.mkdir(this.resolve(parentDir, newDirName));
                return null;
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public void uploadFile(InputStream sourceStream, String newFileName, String targetParentDir, StorageProgressListener progressListener) throws StorageLimitException, StorageMethodException, StorageConnectionException {
        ((Retriable<Void>)() -> {
            SftpClientProvider sftpClientProvider = this.uploadClient;
            synchronized (sftpClientProvider) {
                ChannelSftp sftp = this.uploadClient.getClient();
                sftp.put(sourceStream, this.resolve(targetParentDir, newFileName), (SftpProgressMonitor)new SftpStorageProgressListener(progressListener), 0);
                return null;
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public InputStream downloadFile(String sourcePath, StorageProgressListener progressListener) throws StorageMethodException, StorageConnectionException {
        return ((Retriable<InputStream>)() -> {
            SftpClientProvider sftpClientProvider = this.downloadClient;
            synchronized (sftpClientProvider) {
                ChannelSftp sftp = this.downloadClient.getClient();
                return sftp.get(sourcePath, new SftpStorageProgressListener(progressListener));
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public void delete(String path) throws StorageMethodException, StorageConnectionException {
        ((Retriable<Void>)() -> {
            SftpClientProvider sftpClientProvider = this.mainClient;
            synchronized (sftpClientProvider) {
                ChannelSftp sftp = this.mainClient.getClient();
                SftpATTRS stat = sftp.stat(path);
                if (stat.isDir()) {
                    sftp.rmdir(path);
                } else {
                    sftp.rm(path);
                }
                return null;
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public void renameFile(String path, String newFileName) throws StorageMethodException, StorageConnectionException {
        ((Retriable<Void>)() -> {
            SftpClientProvider sftpClientProvider = this.mainClient;
            synchronized (sftpClientProvider) {
                ChannelSftp sftp = this.mainClient.getClient();
                Object parentPath = "";
                if (path.contains(this.config.getPathSeparatorSymbol())) {
                    parentPath = path.substring(0, path.lastIndexOf(this.config.getPathSeparatorSymbol()));
                    parentPath = (String)parentPath + this.config.getPathSeparatorSymbol();
                }
                sftp.rename(path, (String)parentPath + newFileName);
                return null;
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public int getStorageSpeedMultiplier() {
        return 8;
    }

    @Override
    public void destroy() {
        this.mainClient.disconnect();
        this.downloadClient.disconnect();
        this.uploadClient.disconnect();
    }

    @Override
    public void downloadCompleted() throws StorageMethodException, StorageConnectionException {
    }

    @Override
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    private static class SftpStorageProgressListener
    implements SftpProgressMonitor {
        private final StorageProgressListener progressListener;

        SftpStorageProgressListener(StorageProgressListener progressListener) {
            this.progressListener = progressListener;
        }

        @Override
        public void init(int operationCode, String sourceDir, String destDir, long maxProgress) {
        }

        @Override
        public boolean count(long l) {
            this.progressListener.incrementProgress(l);
            return true;
        }

        @Override
        public void end() {
        }
    }
}

