/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.task.BaseTask;
import ru.dvdishka.backuper.backend.task.DeleteDirTask;
import ru.dvdishka.backuper.backend.task.TaskException;

public class BackupDeleteTask
extends BaseTask {
    private final Backup backup;
    private DeleteDirTask deleteBackupTask;

    public BackupDeleteTask(Backup backup) {
        this.backup = backup;
    }

    @Override
    public void run() {
        if (!this.cancelled) {
            try {
                Backuper.getInstance().getTaskManager().startTaskRaw(this.deleteBackupTask, this.sender);
            }
            catch (Exception e) {
                this.warn(new TaskException(this.deleteBackupTask, (Throwable)e));
            }
            this.backup.getStorage().getBackupManager().invalidateBackupSizeCache(this.backup.getName());
        }
    }

    @Override
    public void prepareTask(CommandSender sender) throws Throwable {
        if (this.cancelled) {
            return;
        }
        this.deleteBackupTask = new DeleteDirTask(this.backup.getStorage(), this.backup.getPath());
        this.deleteBackupTask.maxProgress = this.backup.getByteSize();
        Backuper.getInstance().getTaskManager().prepareTask(this.deleteBackupTask, sender);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        if (this.deleteBackupTask != null) {
            Backuper.getInstance().getTaskManager().cancelTaskRaw(this.deleteBackupTask);
        }
    }

    @Override
    public long getTaskMaxProgress() {
        if (!this.isTaskPrepared()) {
            return 0L;
        }
        return this.deleteBackupTask.getTaskMaxProgress() * (long)this.backup.getStorage().getDeleteProgressMultiplier();
    }

    @Override
    public long getTaskCurrentProgress() {
        if (!this.isTaskPrepared()) {
            return 0L;
        }
        return this.deleteBackupTask.getTaskCurrentProgress() * (long)this.backup.getStorage().getDeleteProgressMultiplier();
    }
}

