/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.task.BaseTask;
import ru.dvdishka.backuper.backend.task.DeleteBrokenBackupsTask;
import ru.dvdishka.backuper.backend.task.DeleteOldBackupsTask;
import ru.dvdishka.backuper.backend.task.DoubleStorageTask;
import ru.dvdishka.backuper.backend.task.SetWorldsReadOnlyTask;
import ru.dvdishka.backuper.backend.task.SetWorldsWritableTask;
import ru.dvdishka.backuper.backend.task.Task;
import ru.dvdishka.backuper.backend.task.TaskException;
import ru.dvdishka.backuper.backend.task.TransferDirTask;
import ru.dvdishka.backuper.backend.task.TransferDirsAsZipTask;
import ru.dvdishka.backuper.backend.util.Utils;

public class BackupTask
extends BaseTask {
    private final boolean isAutoBackup;
    private final String afterBackup;
    private final List<Storage> storages;
    private String backupName;
    private final List<Task> tasks = new ArrayList<Task>();

    public BackupTask(List<Storage> storages, String afterBackup, boolean isAutoBackup) {
        this.storages = storages;
        this.afterBackup = afterBackup.toUpperCase();
        this.isAutoBackup = isAutoBackup;
    }

    @Override
    @ApiStatus.Internal
    public void start(CommandSender sender) throws TaskException {
        try {
            if (!this.cancelled) {
                this.sender = sender;
            }
            if (!this.cancelled && Backuper.getInstance().getConfigManager().getBackupConfig().isSkipDuplicateBackup() && this.isAutoBackup && Backuper.getInstance().getConfigManager().getLastBackup() >= Backuper.getInstance().getConfigManager().getLastChange()) {
                this.log("The backup cycle will be skipped since there were no changes from the previous backup", sender);
                Backuper.getInstance().getConfigManager().updateLastBackup();
                if (this.afterBackup.equals("RESTART")) {
                    Backuper.getInstance().getScheduleManager().runGlobalRegionDelayed((Plugin)Backuper.getInstance(), () -> {
                        Backuper.getInstance().getScheduleManager().destroy((Plugin)Backuper.getInstance());
                        Bukkit.getServer().restart();
                    }, 20L);
                } else if (this.afterBackup.equals("STOP")) {
                    this.devLog("Stopping server...");
                    Bukkit.shutdown();
                }
                return;
            }
            if (!this.isTaskPrepared() && !this.cancelled) {
                try {
                    Backuper.getInstance().getTaskManager().prepareTask(this, sender);
                }
                catch (Throwable e) {
                    throw new TaskException(this, e);
                }
            }
            if (!this.cancelled) {
                this.prepareTaskFuture.get();
            }
            if (!this.cancelled) {
                this.run();
            }
        }
        catch (Exception e) {
            throw new TaskException(this, (Throwable)e);
        }
    }

    @Override
    public void run() {
        HashMap storageBackupByteSize = new HashMap();
        ArrayList<CompletableFuture<Void>> taskFutures = new ArrayList<CompletableFuture<Void>>();
        if (!this.cancelled) {
            try {
                Backuper.getInstance().getTaskManager().startTaskRaw(new SetWorldsReadOnlyTask(), this.sender);
            }
            catch (TaskException e) {
                this.warn(e);
            }
        }
        HashMap<Storage, List> storageTasks = new HashMap<Storage, List>();
        for (Task task : this.tasks) {
            if (task instanceof DoubleStorageTask) {
                DoubleStorageTask doubleStorageTask = (DoubleStorageTask)task;
                storageTasks.compute(doubleStorageTask.getTargetStorage(), (storage, tasks) -> {
                    if (tasks == null) {
                        tasks = new ArrayList<DoubleStorageTask>();
                    }
                    tasks.add(doubleStorageTask);
                    return tasks;
                });
                continue;
            }
            Backuper.getInstance().getLogManager().warn("Non-DoubleStorageTask found in BackupTask tasks list: %s".formatted(task.getClass().getName()));
        }
        for (Storage storage2 : storageTasks.keySet()) {
            if (this.cancelled) break;
            taskFutures.add(Backuper.getInstance().getScheduleManager().runAsync(() -> {
                block7: {
                    try {
                        for (Task task : (List)storageTasks.get(storage2)) {
                            if (this.cancelled) break;
                            Backuper.getInstance().getTaskManager().startTaskRaw(task, this.sender);
                            if (this.cancelled || !(task instanceof TransferDirTask)) continue;
                            TransferDirTask transferDirTask = (TransferDirTask)task;
                            storageBackupByteSize.compute(transferDirTask.getTargetStorage(), (transferTaskStorage, size) -> size == null ? transferDirTask.getTaskMaxProgress() : size + transferDirTask.getTaskMaxProgress());
                        }
                        if (this.cancelled) break block7;
                        this.devLog("The Rename \"in progress\" in %s storage task has been started".formatted(storage2.getId()));
                        String fileType = "";
                        if (storage2.getConfig().isZipArchive()) {
                            fileType = ".zip";
                        }
                        try {
                            storage2.renameFile(storage2.resolve(storage2.getConfig().getBackupsFolder(), this.backupName + fileType), this.backupName.replace(" in progress", "") + fileType);
                            if (!storage2.getConfig().isZipArchive()) {
                                storage2.getBackupManager().saveBackupSizeToCache(this.backupName.replace(" in progress", ""), (Long)storageBackupByteSize.get(storage2));
                                this.devLog("New backup size in %s storage has been cached".formatted(storage2.getId()));
                            }
                        }
                        catch (Exception e) {
                            this.warn("Failed to rename file %s in %s storage".formatted(this.backupName, storage2.getId()), this.sender);
                            this.warn(e);
                        }
                        this.devLog("The Rename \"in progress\" Folder %s storage task has been finished".formatted(storage2.getId()));
                    }
                    catch (TaskException e) {
                        this.warn(e);
                    }
                }
            }));
        }
        CompletableFuture.allOf(taskFutures.toArray(new CompletableFuture[0])).join();
        try {
            Backuper.getInstance().getTaskManager().startTaskRaw(new SetWorldsWritableTask(), this.sender);
        }
        catch (TaskException e) {
            this.warn(e);
        }
        if (!this.cancelled && this.isAutoBackup) {
            this.devLog("Update \"lastBackup\" Variable task has been started");
            Backuper.getInstance().getConfigManager().updateLastBackup();
            this.devLog("Update \"lastBackup\" Variable task has been finished");
        }
        if (!this.cancelled) {
            DeleteOldBackupsTask deleteOldBackupTask = new DeleteOldBackupsTask();
            this.tasks.add(deleteOldBackupTask);
            try {
                Backuper.getInstance().getTaskManager().startTaskRaw(deleteOldBackupTask, this.sender);
            }
            catch (Exception e) {
                this.warn(new TaskException(deleteOldBackupTask, (Throwable)e));
            }
            if (Backuper.getInstance().getConfigManager().getBackupConfig().isDeleteBrokenBackups()) {
                DeleteBrokenBackupsTask deleteBrokenBackupsTask = new DeleteBrokenBackupsTask();
                this.tasks.add(deleteBrokenBackupsTask);
                try {
                    Backuper.getInstance().getTaskManager().startTaskRaw(deleteBrokenBackupsTask, this.sender);
                }
                catch (Exception e) {
                    this.warn(new TaskException(deleteBrokenBackupsTask, (Throwable)e));
                }
            }
        }
        if (!this.cancelled) {
            if (this.afterBackup.equals("RESTART")) {
                Backuper.getInstance().getScheduleManager().runGlobalRegionDelayed((Plugin)Backuper.getInstance(), () -> {
                    Backuper.getInstance().getScheduleManager().destroy((Plugin)Backuper.getInstance());
                    Bukkit.getServer().restart();
                }, 20L);
            } else if (this.afterBackup.equals("STOP")) {
                this.log("Stopping server...", this.sender);
                Bukkit.shutdown();
            }
        }
    }

    @Override
    public void prepareTask(CommandSender sender) {
        try {
            this.backupName = "%s in progress".formatted(LocalDateTime.now().format(Backuper.getInstance().getConfigManager().getBackupConfig().getDateTimeFormatter()));
            for (Storage storage : this.storages) {
                if (this.cancelled) continue;
                this.prepareStorageTask(storage);
            }
        }
        catch (Exception e) {
            this.warn("The Backup task has been finished with an exception!", this.sender);
            this.warn(e);
        }
    }

    private void prepareStorageTask(Storage storage) {
        block14: {
            try {
                if (this.cancelled) {
                    return;
                }
                if (!storage.getConfig().isZipArchive()) {
                    storage.createDir(this.backupName, storage.getConfig().getBackupsFolder());
                }
                ArrayList<String> dirsToAddToZip = new ArrayList<String>();
                for (String directoryToBackup : this.getDirectoriesToBackup()) {
                    try {
                        if (this.cancelled) {
                            return;
                        }
                        File additionalDirectoryToBackupFile = Paths.get(directoryToBackup, new String[0]).toFile();
                        boolean isExcludedDirectory = Utils.isExcludedDirectory(additionalDirectoryToBackupFile, this.sender);
                        if (!additionalDirectoryToBackupFile.exists()) {
                            this.warn("addDirectoryToBackup \"%s\" does not exist!".formatted(additionalDirectoryToBackupFile.getPath()));
                            continue;
                        }
                        if (isExcludedDirectory) continue;
                        if (!storage.getConfig().isZipArchive()) {
                            TransferDirTask task = new TransferDirTask(Backuper.getInstance().getStorageManager().getStorage("backuper"), additionalDirectoryToBackupFile.toPath().toAbsolutePath().normalize().toString(), storage, storage.resolve(storage.getConfig().getBackupsFolder(), this.backupName), additionalDirectoryToBackupFile.getName(), false);
                            try {
                                Backuper.getInstance().getTaskManager().prepareTask(task, this.sender);
                            }
                            catch (Throwable e) {
                                throw new TaskException(task, e);
                            }
                            this.tasks.add(task);
                            continue;
                        }
                        dirsToAddToZip.add(additionalDirectoryToBackupFile.toPath().toAbsolutePath().normalize().toString());
                    }
                    catch (Exception e) {
                        this.warn("Something went wrong when trying to backup an additional directory \"%s\"".formatted(directoryToBackup), this.sender);
                        this.warn(e);
                    }
                }
                if (!storage.getConfig().isZipArchive()) break block14;
                TransferDirsAsZipTask task = new TransferDirsAsZipTask(Backuper.getInstance().getStorageManager().getStorage("backuper"), dirsToAddToZip, storage, storage.getConfig().getBackupsFolder(), "%s.zip".formatted(this.backupName), true, false);
                try {
                    Backuper.getInstance().getTaskManager().prepareTask(task, this.sender);
                }
                catch (Throwable e) {
                    throw new TaskException(task, e);
                }
                this.tasks.add(task);
            }
            catch (Exception e) {
                this.warn("Something went wrong while trying to prepare %s storage backup task".formatted(storage.getId()));
                this.warn(e);
            }
        }
    }

    private long getTaskProgressMultiplier(Task task) {
        Task task2 = task;
        Objects.requireNonNull(task2);
        Task task3 = task2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TransferDirTask.class, TransferDirsAsZipTask.class}, (Object)task3, n)) {
            case 0 -> {
                TransferDirTask transferDirTask = (TransferDirTask)task3;
                yield Long.max(transferDirTask.getTargetStorage().getTransferProgressMultiplier(), transferDirTask.getSourceStorage().getTransferProgressMultiplier());
            }
            case 1 -> {
                TransferDirsAsZipTask addLocalDirToZipTask = (TransferDirsAsZipTask)task3;
                yield Long.max(addLocalDirToZipTask.getTargetStorage().getZipProgressMultiplier(), addLocalDirToZipTask.getSourceStorage().getZipProgressMultiplier());
            }
            default -> 1L;
        };
    }

    @Override
    public long getTaskCurrentProgress() {
        return this.tasks.stream().mapToLong(task -> task.getTaskCurrentProgress() * this.getTaskProgressMultiplier((Task)task)).sum();
    }

    @Override
    public long getTaskMaxProgress() {
        return this.tasks.stream().mapToLong(task -> task.getTaskMaxProgress() * this.getTaskProgressMultiplier((Task)task)).sum();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (Task task : this.tasks) {
            Backuper.getInstance().getTaskManager().cancelTaskRaw(task);
        }
    }

    private List<String> getDirectoriesToBackup() {
        return Stream.concat(this.getWorldsDirectoryToBackup().stream(), this.getAddDirectoryToBackup().stream()).distinct().toList();
    }

    private List<String> getWorldsDirectoryToBackup() {
        return Bukkit.getWorlds().stream().map(world -> world.getWorldFolder().getPath()).toList();
    }

    private List<String> getAddDirectoryToBackup() {
        if (Backuper.getInstance().getConfigManager().getBackupConfig().getAddDirectoryToBackup().contains("*")) {
            List list = Backuper.getInstance().getConfigManager().getBackupConfig().getAddDirectoryToBackup().stream().filter(directory -> !directory.equals("*")).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            File file = new File(".");
            for (File subFile : file.listFiles()) {
                list.add(subFile.getPath());
            }
            return list;
        }
        return Backuper.getInstance().getConfigManager().getBackupConfig().getAddDirectoryToBackup().stream().map(addDirectory -> new File((String)addDirectory).getPath()).toList();
    }
}

