/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.task.BaseTask;
import ru.dvdishka.backuper.backend.task.DeleteDirTask;
import ru.dvdishka.backuper.backend.task.TaskException;
import ru.dvdishka.backuper.backend.task.TransferDirsAsZipTask;

public class BackupToZipTask
extends BaseTask {
    private final Backup backup;
    private TransferDirsAsZipTask toZipTask;
    private DeleteDirTask deleteFolderTask;

    public BackupToZipTask(Backup backup) {
        this.backup = backup;
    }

    @Override
    public void run() {
        try {
            if (!this.cancelled) {
                Backuper.getInstance().getTaskManager().startTaskRaw(this.toZipTask, this.sender);
            }
            if (!this.cancelled) {
                this.backup.getStorage().getBackupManager().invalidateBackupSizeCache(this.backup.getName());
                Backuper.getInstance().getTaskManager().startTaskRaw(this.deleteFolderTask, this.sender);
                this.backup.getStorage().renameFile(this.backup.getInProgressPath(Backup.BackupFileType.ZIP), this.backup.getFileName(Backup.BackupFileType.ZIP));
            }
        }
        catch (Exception e) {
            this.warn(new TaskException(this.toZipTask, (Throwable)e));
        }
    }

    @Override
    public void prepareTask(CommandSender sender) throws Throwable {
        if (this.cancelled) {
            return;
        }
        this.deleteFolderTask = new DeleteDirTask(this.backup.getStorage(), this.backup.getPath());
        this.deleteFolderTask.maxProgress = this.backup.getByteSize();
        Backuper.getInstance().getTaskManager().prepareTask(this.deleteFolderTask, sender);
        this.toZipTask = new TransferDirsAsZipTask(this.backup.getStorage(), List.of(this.backup.getPath()), this.backup.getStorage(), this.backup.getStorage().getConfig().getBackupsFolder(), this.backup.getInProgressFileName(Backup.BackupFileType.ZIP), false, true);
        this.toZipTask.maxProgress = this.backup.getByteSize();
        Backuper.getInstance().getTaskManager().prepareTask(this.toZipTask, sender);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        if (this.toZipTask != null) {
            Backuper.getInstance().getTaskManager().cancelTaskRaw(this.toZipTask);
        }
        if (this.deleteFolderTask != null) {
            Backuper.getInstance().getTaskManager().cancelTaskRaw(this.deleteFolderTask);
        }
    }

    @Override
    public long getTaskMaxProgress() {
        if (!this.isTaskPrepared()) {
            return 0L;
        }
        return this.toZipTask.getTaskMaxProgress() * (long)this.backup.getStorage().getZipProgressMultiplier() + this.deleteFolderTask.getTaskMaxProgress() * (long)this.backup.getStorage().getDeleteProgressMultiplier();
    }

    @Override
    public long getTaskCurrentProgress() {
        if (!this.isTaskPrepared()) {
            return 0L;
        }
        return this.toZipTask.getTaskCurrentProgress() * (long)this.backup.getStorage().getZipProgressMultiplier() + this.deleteFolderTask.getTaskCurrentProgress() * (long)this.backup.getStorage().getDeleteProgressMultiplier();
    }
}

