/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands;

import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.backend.util.UIUtils;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public abstract class Command {
    protected CommandSender sender;
    protected CommandArguments arguments;

    protected Command(CommandSender sender, CommandArguments arguments) {
        this.sender = sender;
        this.arguments = arguments;
    }

    public abstract boolean check();

    public abstract void run();

    public void execute() {
        if (!this.check()) {
            this.cancelSound();
            return;
        }
        this.buttonSound();
        this.run();
    }

    protected void returnSuccess(String message) {
        UIUtils.returnSuccess(message, this.sender);
    }

    protected void returnFailure(String message) {
        UIUtils.returnFailure(message, this.sender);
    }

    protected void returnWarning(String message) {
        UIUtils.returnWarning(message, this.sender);
    }

    protected void sendMessage(String message) {
        UIUtils.sendMessage(message, this.sender);
    }

    protected void cancelSound() {
        UIUtils.cancelSound(this.sender);
    }

    protected void buttonSound() {
        UIUtils.buttonSound(this.sender);
    }

    protected void successSound() {
        UIUtils.successSound(this.sender);
    }

    protected void notificationSound() {
        UIUtils.notificationSound(this.sender);
    }

    protected void sendFramedMessage(Component message) {
        UIUtils.sendFramedMessage(message, this.sender);
    }

    protected void sendFramedMessage(Component message, int dashNumber) {
        UIUtils.sendFramedMessage(message, dashNumber, this.sender);
    }

    protected void sendFramedMessage(Component header, Component message) {
        UIUtils.sendFramedMessage(header, message, this.sender);
    }

    protected void sendFramedMessage(Component header, Component message, int dashNumber) {
        UIUtils.sendFramedMessage(header, message, dashNumber, this.sender);
    }
}

