/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.backup;

import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.task.BackupTask;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.Permission;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class BackupCommand
extends Command {
    private final String afterBackup;
    private final long delay;
    private final List<Storage> storages = new ArrayList<Storage>();

    public BackupCommand(CommandSender sender, CommandArguments args, String afterBackup) {
        super(sender, args);
        this.afterBackup = afterBackup.toUpperCase();
        this.delay = (Long)args.getOrDefault("delaySeconds", (Object)1L);
    }

    @Override
    public boolean check() {
        if (Backuper.getInstance().getTaskManager().isLocked()) {
            this.returnFailure("Blocked by another operation");
            return false;
        }
        if (this.delay < 1L) {
            this.returnFailure("Delay must be > 0!");
            return false;
        }
        boolean storageParseFailure = false;
        for (String storageId : ((String)this.arguments.get("storage")).split("-")) {
            if (storageId.isEmpty()) continue;
            Storage storage = Backuper.getInstance().getStorageManager().getStorage(storageId);
            if (storage == null) {
                this.returnFailure("Wrong storage name %s".formatted(storageId));
                storageParseFailure = true;
            } else if (!storage.checkConnection(this.sender)) {
                this.returnFailure("Failed to connect to %s storage".formatted(storage.getId()));
                storageParseFailure = true;
            }
            this.storages.add(storage);
        }
        if (storageParseFailure) {
            return false;
        }
        if (this.storages.isEmpty()) {
            this.returnFailure("You have to define at least one storage");
            return false;
        }
        if (!this.storages.stream().map(Permission.BACKUP::getPermission).allMatch(arg_0 -> ((CommandSender)this.sender).hasPermission(arg_0)) || this.afterBackup.equals("STOP") && !this.sender.hasPermission(Permission.STOP.getPermission()) || this.afterBackup.equals("RESTART") && !this.sender.hasPermission(Permission.RESTART.getPermission())) {
            this.returnFailure("Don't have enough permissions to perform this command");
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        if (Backuper.getInstance().getConfigManager().getServerConfig().getAlertTimeBeforeRestart() != -1L) {
            Backuper.getInstance().getScheduleManager().runGlobalRegionDelayed((Plugin)Backuper.getInstance(), () -> Backuper.getInstance().getAutoBackupScheduleManager().getAutoBackupJob().executeAlert(Longs.min(Backuper.getInstance().getConfigManager().getServerConfig().getAlertTimeBeforeRestart(), this.delay), this.afterBackup), Long.max((this.delay - Backuper.getInstance().getConfigManager().getServerConfig().getAlertTimeBeforeRestart()) * 20L, 1L));
        }
        ArrayList<String> backupPermissions = new ArrayList<String>();
        for (Storage storage : this.storages) {
            backupPermissions.add(Permission.BACKUP.getPermission(storage));
        }
        if (this.afterBackup.equals("STOP")) {
            backupPermissions.add(Permission.STOP.getPermission());
        }
        if (this.afterBackup.equals("RESTART")) {
            backupPermissions.add(Permission.RESTART.getPermission());
        }
        Backuper.getInstance().getScheduleManager().runGlobalRegionDelayed((Plugin)Backuper.getInstance(), () -> {
            BackupTask task = new BackupTask(this.storages, this.afterBackup, false);
            Backuper.getInstance().getTaskManager().startTaskAsync(task, this.sender, backupPermissions);
        }, this.delay * 20L);
        if (this.arguments.get("delaySeconds") != null) {
            this.returnSuccess("Backup task will be started in %s seconds".formatted(this.delay));
            if (!(this.sender instanceof ConsoleCommandSender)) {
                Backuper.getInstance().getLogManager().log("Backup task will be started in %s seconds".formatted(this.delay));
            }
        }
    }
}

