/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu;

import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.task.CopyToTask;
import ru.dvdishka.backuper.handlers.commands.ConfirmableCommand;
import ru.dvdishka.backuper.handlers.commands.Permission;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class CopyToCommand
extends ConfirmableCommand {
    private Storage sourceStorage;
    private Backup backup;
    private Storage targetStorage;

    public CopyToCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public boolean check() {
        this.sourceStorage = Backuper.getInstance().getStorageManager().getStorage((String)this.arguments.get("storage"));
        if (this.sourceStorage == null) {
            this.returnFailure("Wrong storage name %s".formatted((String)this.arguments.get("storage")));
            return false;
        }
        if (!this.sourceStorage.checkConnection()) {
            this.returnFailure("Failed to establish connection to storage %s".formatted(this.sourceStorage.getId()));
            return false;
        }
        this.backup = this.sourceStorage.getBackupManager().getBackup((String)this.arguments.get("backupName"));
        if (this.backup == null) {
            this.returnFailure("Wrong backup name %s".formatted((String)this.arguments.get("backupName")));
            return false;
        }
        this.targetStorage = Backuper.getInstance().getStorageManager().getStorage((String)this.arguments.get("targetStorage"));
        if (this.targetStorage == null) {
            this.returnFailure("Wrong target storage");
            return false;
        }
        if (!this.sourceStorage.checkConnection()) {
            this.returnFailure("Failed to establish connection to storage %s".formatted(this.targetStorage.getId()));
            return false;
        }
        if (Backuper.getInstance().getTaskManager().isLocked()) {
            this.returnFailure("Blocked by another operation!");
            return false;
        }
        if (this.targetStorage.getBackupManager().getBackupList().stream().anyMatch(backup -> backup.getName().equals((String)this.arguments.get("backupName")))) {
            this.returnFailure("Target storage already contains this backup");
            return false;
        }
        if (!this.sender.hasPermission(Permission.STORAGE.getPermission(this.sourceStorage)) || !this.sender.hasPermission(Permission.STORAGE.getPermission(this.targetStorage))) {
            this.returnFailure("Don't have enough permissions to perform this command");
            return false;
        }
        this.setMessage(this.backup);
        return true;
    }

    @Override
    public void run() {
        CopyToTask task = new CopyToTask(this.backup, this.targetStorage);
        Backuper.getInstance().getTaskManager().startTask(task, this.sender, List.of(Permission.STORAGE.getPermission(this.sourceStorage), Permission.STORAGE.getPermission(this.targetStorage)));
    }
}

