/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu;

import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.handlers.commands.ConfirmableCommand;
import ru.dvdishka.backuper.handlers.commands.Permission;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class ToZIPCommand
extends ConfirmableCommand {
    private Storage storage;
    private Backup backup;

    public ToZIPCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public boolean check() {
        this.storage = Backuper.getInstance().getStorageManager().getStorage((String)this.arguments.get("storage"));
        if (this.storage == null) {
            this.returnFailure("Wrong storage name %s".formatted((String)this.arguments.get("storage")));
            return false;
        }
        if (!this.storage.checkConnection()) {
            this.returnFailure("Failed to establish connection to storage %s".formatted(this.storage.getId()));
            return false;
        }
        this.backup = this.storage.getBackupManager().getBackup((String)this.arguments.get("backupName"));
        if (this.backup == null) {
            this.returnFailure("Wrong backup name %s".formatted((String)this.arguments.get("backupName")));
            return false;
        }
        if (Backup.BackupFileType.ZIP.equals((Object)this.backup.getFileType())) {
            this.returnFailure("Backup is already ZIP!");
            return false;
        }
        if (Backuper.getInstance().getTaskManager().isLocked()) {
            this.returnFailure("Blocked by another operation!");
            return false;
        }
        if (!this.sender.hasPermission(Permission.TO_ZIP.getPermission(this.storage))) {
            this.returnFailure("Don't have enough permissions to perform this command");
            return false;
        }
        this.setMessage(this.backup);
        return true;
    }

    @Override
    public void run() {
        Backuper.getInstance().getTaskManager().startTaskAsync(this.backup.getToZipTask(), this.sender, List.of(Permission.TO_ZIP.getPermission(this.storage)));
    }
}

