/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.task;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.util.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.Permission;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class StatusCommand
extends Command {
    public StatusCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public boolean check() {
        if (!Backuper.getInstance().getTaskManager().isLocked()) {
            this.returnFailure("No task is currently running");
            return false;
        }
        if (!this.sender.hasPermission(Permission.STATUS.getPermission())) {
            this.returnFailure("Don't have enough permissions to perform this command");
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        long progress = Backuper.getInstance().getTaskManager().getCurrentTask().getTaskPercentProgress();
        TextColor color = !Backuper.getInstance().getTaskManager().getCurrentTask().isTaskPrepared() ? TextColor.color((int)190, (int)20, (int)255) : (progress < 40L ? TextColor.color((int)190, (int)0, (int)27) : (progress < 75L ? TextColor.color((int)190, (int)151, (int)0) : TextColor.color((int)0, (int)156, (int)61)));
        TextComponent message = Component.empty();
        message = message.append((Component)Component.text((String)"Current task:")).append((Component)Component.space()).append(((TextComponent)Component.text((String)Backuper.getInstance().getTaskManager().getCurrentTask().getTaskName()).decorate(TextDecoration.BOLD)).color(UIUtils.getSecondaryColor())).append((Component)Component.newline()).append((Component)Component.text((String)"Task progress:")).append((Component)Component.space()).append(((TextComponent)Component.text((String)((!Backuper.getInstance().getTaskManager().getCurrentTask().isTaskPrepared() ? "Preparing..." : "%s%%".formatted(progress)) + (Backuper.getInstance().getTaskManager().getCurrentTask().isCancelled() ? " (Cancelling...)" : ""))).decorate(TextDecoration.BOLD)).color(color));
        if (!(this.sender instanceof ConsoleCommandSender)) {
            message = message.append((Component)Component.newline()).append((Component)Component.newline()).append(((TextComponent)((TextComponent)Component.text((String)"[STATUS]").clickEvent(ClickEvent.runCommand((String)"/backuper task status"))).color(TextColor.color((int)17, (int)102, (int)212))).decorate(TextDecoration.BOLD)).append((Component)Component.space()).append(((TextComponent)((TextComponent)Component.text((String)"[CANCEL]").decorate(TextDecoration.BOLD)).color(TextColor.color((int)11542784))).clickEvent(ClickEvent.runCommand((String)"/backuper task cancel")));
        }
        if (!(this.sender instanceof ConsoleCommandSender)) {
            this.sendFramedMessage((Component)message, 15);
        } else {
            this.sendFramedMessage((Component)message);
        }
    }
}

