/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KEM;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;
import com.jcraft.jsch.XDH;

abstract class DHXECKEM
extends KeyExchange {
    private static final int SSH_MSG_KEX_ECDH_INIT = 30;
    private static final int SSH_MSG_KEX_ECDH_REPLY = 31;
    private int state;
    byte[] Q_C;
    byte[] V_S;
    byte[] V_C;
    byte[] I_S;
    byte[] I_C;
    byte[] e;
    private Buffer buf;
    private Packet packet;
    private KEM kem;
    private XDH xdh;
    protected String kem_name;
    protected String sha_name;
    protected String curve_name;
    protected int kem_pubkey_len;
    protected int kem_encap_len;
    protected int xec_key_len;

    DHXECKEM() {
    }

    @Override
    public void init(Session session, byte[] V_S, byte[] V_C, byte[] I_S, byte[] I_C) throws Exception {
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = I_S;
        this.I_C = I_C;
        try {
            Class<HASH> c2 = Class.forName(session.getConfig(this.sha_name)).asSubclass(HASH.class);
            this.sha = c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.sha.init();
        }
        catch (Exception e) {
            throw new JSchException(e.toString(), e);
        }
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        this.packet.reset();
        this.buf.checkFreeSize(5 + this.kem_pubkey_len + this.xec_key_len);
        this.buf.putByte((byte)30);
        try {
            Class<KEM> k = Class.forName(session.getConfig(this.kem_name)).asSubclass(KEM.class);
            this.kem = k.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.kem.init();
            Class<XDH> c3 = Class.forName(session.getConfig("xdh")).asSubclass(XDH.class);
            this.xdh = c3.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.xdh.init(this.curve_name, this.xec_key_len);
            byte[] kem_public_key_C = this.kem.getPublicKey();
            byte[] xec_public_key_C = this.xdh.getQ();
            this.Q_C = new byte[this.kem_pubkey_len + this.xec_key_len];
            System.arraycopy(kem_public_key_C, 0, this.Q_C, 0, this.kem_pubkey_len);
            System.arraycopy(xec_public_key_C, 0, this.Q_C, this.kem_pubkey_len, this.xec_key_len);
            this.buf.putString(this.Q_C);
        }
        catch (Exception | NoClassDefFoundError e) {
            throw new JSchException(e.toString(), e);
        }
        if (V_S == null) {
            return;
        }
        session.write(this.packet);
        if (session.getLogger().isEnabled(1)) {
            session.getLogger().log(1, "SSH_MSG_KEX_ECDH_INIT sent");
            session.getLogger().log(1, "expecting SSH_MSG_KEX_ECDH_REPLY");
        }
        this.state = 31;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next(Buffer _buf) throws Exception {
        switch (this.state) {
            case 31: {
                int j = _buf.getInt();
                j = _buf.getByte();
                j = _buf.getByte();
                if (j != 31) {
                    if (this.session.getLogger().isEnabled(3)) {
                        this.session.getLogger().log(3, "type: must be SSH_MSG_KEX_ECDH_REPLY " + j);
                    }
                    return false;
                }
                this.K_S = _buf.getString();
                byte[] Q_S = _buf.getString();
                if (Q_S.length != this.kem_encap_len + this.xec_key_len) {
                    return false;
                }
                byte[] encapsulation = new byte[this.kem_encap_len];
                byte[] xec_public_key_S = new byte[this.xec_key_len];
                System.arraycopy(Q_S, 0, encapsulation, 0, this.kem_encap_len);
                System.arraycopy(Q_S, this.kem_encap_len, xec_public_key_S, 0, this.xec_key_len);
                if (!this.xdh.validate(xec_public_key_S)) {
                    return false;
                }
                byte[] tmp = null;
                try {
                    tmp = this.kem.decapsulate(encapsulation);
                    this.sha.update(tmp, 0, tmp.length);
                }
                catch (Throwable throwable) {
                    Util.bzero(tmp);
                    throw throwable;
                }
                Util.bzero(tmp);
                try {
                    tmp = this.normalize(this.xdh.getSecret(xec_public_key_S));
                    this.sha.update(tmp, 0, tmp.length);
                }
                finally {
                    Util.bzero(tmp);
                }
                this.K = this.encodeAsString(this.sha.digest());
                byte[] sig_of_H = _buf.getString();
                this.buf.reset();
                this.buf.putString(this.V_C);
                this.buf.putString(this.V_S);
                this.buf.putString(this.I_C);
                this.buf.putString(this.I_S);
                this.buf.putString(this.K_S);
                this.buf.putString(this.Q_C);
                this.buf.putString(Q_S);
                byte[] foo = new byte[this.buf.getLength()];
                this.buf.getByte(foo);
                this.sha.update(foo, 0, foo.length);
                this.sha.update(this.K, 0, this.K.length);
                this.H = this.sha.digest();
                int i = 0;
                j = 0;
                j = this.K_S[i++] << 24 & 0xFF000000 | this.K_S[i++] << 16 & 0xFF0000 | this.K_S[i++] << 8 & 0xFF00 | this.K_S[i++] & 0xFF;
                String alg = Util.byte2str(this.K_S, i, j);
                boolean result = this.verify(alg, this.K_S, i += j, sig_of_H);
                this.state = 0;
                return result;
            }
        }
        return false;
    }

    @Override
    public int getState() {
        return this.state;
    }
}

