/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import com.jcraft.jsch.Cipher;
import java.nio.ByteBuffer;
import javax.crypto.AEADBadTagException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.ChaChaEngine;
import org.bouncycastle.crypto.macs.Poly1305;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class ChaCha20Poly1305
implements Cipher {
    private static final int ivsize = 8;
    private static final int bsize = 64;
    private static final int tagsize = 16;
    private ChaChaEngine header_cipher;
    private ChaChaEngine main_cipher;
    private KeyParameter K_1_spec;
    private KeyParameter K_2_spec;
    private int mode;
    private Poly1305 poly1305;

    @Override
    public int getIVSize() {
        return 8;
    }

    @Override
    public int getBlockSize() {
        return 64;
    }

    @Override
    public int getTagSize() {
        return 16;
    }

    @Override
    public void init(int mode, byte[] key, byte[] iv) throws Exception {
        if (key.length > 64) {
            byte[] tmp = new byte[64];
            System.arraycopy(key, 0, tmp, 0, tmp.length);
            key = tmp;
        }
        byte[] K_1 = new byte[32];
        byte[] K_2 = new byte[32];
        System.arraycopy(key, 32, K_1, 0, 32);
        System.arraycopy(key, 0, K_2, 0, 32);
        this.mode = mode;
        try {
            this.K_1_spec = new KeyParameter(K_1, 0, K_1.length);
            this.K_2_spec = new KeyParameter(K_2, 0, K_2.length);
            this.header_cipher = new ChaChaEngine();
            this.main_cipher = new ChaChaEngine();
            this.poly1305 = new Poly1305();
        }
        catch (Exception e) {
            this.header_cipher = null;
            this.main_cipher = null;
            this.K_1_spec = null;
            this.K_2_spec = null;
            throw e;
        }
    }

    @Override
    public void update(int foo) throws Exception {
        ByteBuffer nonce = ByteBuffer.allocate(8);
        nonce.putLong(0, foo);
        this.header_cipher.init(this.mode == 0, (CipherParameters)new ParametersWithIV((CipherParameters)this.K_1_spec, nonce.array(), 0, nonce.array().length));
        this.main_cipher.init(this.mode == 0, (CipherParameters)new ParametersWithIV((CipherParameters)this.K_2_spec, nonce.array(), 0, nonce.array().length));
        byte[] poly_key = new byte[64];
        this.main_cipher.processBytes(poly_key, 0, poly_key.length, poly_key, 0);
        this.poly1305.init((CipherParameters)new KeyParameter(poly_key, 0, 32));
    }

    @Override
    public void update(byte[] foo, int s1, int len, byte[] bar, int s2) throws Exception {
        this.header_cipher.processBytes(foo, s1, len, bar, s2);
    }

    @Override
    public void doFinal(byte[] foo, int s1, int len, byte[] bar, int s2) throws Exception {
        if (this.mode == 1) {
            byte[] actual_tag = new byte[16];
            System.arraycopy(foo, len, actual_tag, 0, 16);
            byte[] expected_tag = new byte[16];
            this.poly1305.update(foo, s1, len);
            this.poly1305.doFinal(expected_tag, 0);
            if (!ChaCha20Poly1305.arraysequals(actual_tag, expected_tag)) {
                throw new AEADBadTagException("Tag mismatch");
            }
        }
        this.main_cipher.processBytes(foo, s1 + 4, len - 4, bar, s2 + 4);
        if (this.mode == 0) {
            this.poly1305.update(bar, s2, len);
            this.poly1305.doFinal(bar, len);
        }
    }

    @Override
    public boolean isCBC() {
        return false;
    }

    @Override
    public boolean isAEAD() {
        return true;
    }

    @Override
    public boolean isChaCha20() {
        return true;
    }

    private static boolean arraysequals(byte[] a2, byte[] b2) {
        if (a2.length != b2.length) {
            return false;
        }
        int res = 0;
        for (int i = 0; i < a2.length; ++i) {
            res |= a2[i] ^ b2[i];
        }
        return res == 0;
    }
}

