/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.backup.FtpBackup;
import ru.dvdishka.backuper.backend.backup.GoogleDriveBackup;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.backup.SftpBackup;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.common.Scheduler;
import ru.dvdishka.backuper.backend.config.BackwardsCompatibility;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.common.BackupTask;
import ru.dvdishka.backuper.backend.tasks.common.DeleteBrokenBackupsTask;
import ru.dvdishka.backuper.backend.tasks.common.DeleteOldBackupsTask;
import ru.dvdishka.backuper.backend.utils.FtpUtils;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.backend.utils.SftpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;
import ru.dvdishka.backuper.handlers.commands.backup.BackupCommand;
import ru.dvdishka.backuper.handlers.commands.googleDrive.GoogleDriveLinkCommand;
import ru.dvdishka.backuper.handlers.commands.list.ListCommand;
import ru.dvdishka.backuper.handlers.commands.menu.MenuCommand;
import ru.dvdishka.backuper.handlers.commands.menu.copyToFtp.CopyToFtpCommand;
import ru.dvdishka.backuper.handlers.commands.menu.copyToFtp.CopyToFtpConfirmationCommand;
import ru.dvdishka.backuper.handlers.commands.menu.copyToGoogleDrive.CopyToGoogleDriveCommand;
import ru.dvdishka.backuper.handlers.commands.menu.copyToGoogleDrive.CopyToGoogleDriveConfirmationCommand;
import ru.dvdishka.backuper.handlers.commands.menu.copyToLocal.CopyToLocalCommand;
import ru.dvdishka.backuper.handlers.commands.menu.copyToLocal.CopyToLocalConfirmationCommand;
import ru.dvdishka.backuper.handlers.commands.menu.copyToSftp.CopyToSftpCommand;
import ru.dvdishka.backuper.handlers.commands.menu.copyToSftp.CopyToSftpConfirmationCommand;
import ru.dvdishka.backuper.handlers.commands.menu.delete.DeleteCommand;
import ru.dvdishka.backuper.handlers.commands.menu.delete.DeleteConfirmationCommand;
import ru.dvdishka.backuper.handlers.commands.menu.toZIP.ToZIPCommand;
import ru.dvdishka.backuper.handlers.commands.menu.toZIP.ToZIPConfirmationCommand;
import ru.dvdishka.backuper.handlers.commands.menu.unZIP.UnZIPCommand;
import ru.dvdishka.backuper.handlers.commands.menu.unZIP.UnZIPConfirmationCommand;
import ru.dvdishka.backuper.handlers.commands.reload.ReloadCommand;
import ru.dvdishka.backuper.handlers.commands.task.cancel.CancelCommand;
import ru.dvdishka.backuper.handlers.commands.task.cancel.CancelConfirmationCommand;
import ru.dvdishka.backuper.handlers.commands.task.status.StatusCommand;
import ru.dvdishka.backuper.handlers.worldchangecatch.WorldChangeCatcher;
import ru.dvdishka.backuper.handlers.worldchangecatch.WorldChangeCatcherNew;
import ru.dvdishka.shade.bstats.bukkit.Metrics;
import ru.dvdishka.shade.bstats.charts.SimplePie;
import ru.dvdishka.shade.commandapi.AbstractArgumentTree;
import ru.dvdishka.shade.commandapi.CommandTree;
import ru.dvdishka.shade.commandapi.arguments.Argument;
import ru.dvdishka.shade.commandapi.arguments.ArgumentSuggestions;
import ru.dvdishka.shade.commandapi.arguments.IntegerArgument;
import ru.dvdishka.shade.commandapi.arguments.LiteralArgument;
import ru.dvdishka.shade.commandapi.arguments.LongArgument;
import ru.dvdishka.shade.commandapi.arguments.StringArgument;
import ru.dvdishka.shade.commandapi.arguments.TextArgument;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;
import ru.dvdishka.shade.commandapi.executors.ExecutorType;

public class Initialization
implements Listener {
    public static void initBStats(JavaPlugin plugin) {
        Logger.getLogger().log("Initializing BStats...");
        Metrics bStats = new Metrics((Plugin)plugin, 17735);
        bStats.addCustomChart(new SimplePie("local_storage", () -> Config.getInstance().getLocalConfig().isEnabled() ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("ftp_storage", () -> Config.getInstance().getFtpConfig().isEnabled() ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("sftp_storage", () -> Config.getInstance().getSftpConfig().isEnabled() ? "enabled" : "disabled"));
        bStats.addCustomChart(new SimplePie("google_drive_storage", () -> Config.getInstance().getGoogleDriveConfig().isEnabled() && GoogleDriveUtils.isAuthorized(null) ? "enabled" : "disabled"));
        Logger.getLogger().log("BStats initialization completed");
    }

    public static void indexStorages(CommandSender sender) {
        Logger.getLogger().log("Indexing storages...");
        if (Config.getInstance().getLocalConfig().isEnabled()) {
            CompletableFuture.runAsync(() -> {
                try {
                    Logger.getLogger().devLog("Indexing local storage...");
                    new ListCommand("local", false, sender, new CommandArguments(new Objects[0], new HashMap<String, Object>(), new String[0], new HashMap<String, String>(), "")).execute();
                    Logger.getLogger().devLog("Local storage has been indexed");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (Config.getInstance().getFtpConfig().isEnabled()) {
            CompletableFuture.runAsync(() -> {
                Logger.getLogger().devLog("Indexing FTP storage...");
                new ListCommand("ftp", false, sender, new CommandArguments(new Objects[0], new HashMap<String, Object>(), new String[0], new HashMap<String, String>(), "")).execute();
                Logger.getLogger().devLog("FTP storage has been indexed");
            });
        }
        if (Config.getInstance().getSftpConfig().isEnabled()) {
            CompletableFuture.runAsync(() -> {
                try {
                    Logger.getLogger().devLog("Indexing SFTP storage...");
                    new ListCommand("sftp", false, sender, new CommandArguments(new Objects[0], new HashMap<String, Object>(), new String[0], new HashMap<String, String>(), "")).execute();
                    Logger.getLogger().devLog("SFTP storage has been indexed");
                }
                catch (Exception e) {
                    Logger.getLogger().devWarn(Initialization.class, e);
                }
            });
        }
        if (Config.getInstance().getGoogleDriveConfig().isEnabled() && GoogleDriveUtils.isAuthorized(sender)) {
            CompletableFuture.runAsync(() -> {
                try {
                    Logger.getLogger().devLog("Indexing GoogleDrive storage...");
                    new ListCommand("googleDrive", false, sender, new CommandArguments(new Objects[0], new HashMap<String, Object>(), new String[0], new HashMap<String, String>(), "")).execute();
                    Logger.getLogger().devLog("GoogleDrive storage has been indexed");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    public static void initAutoBackup(CommandSender sender) {
        ArrayList<Permissions> autoBackupPermissions = new ArrayList<Permissions>();
        autoBackupPermissions.add(Permissions.BACKUP);
        if (Config.getInstance().getAfterBackup().equals("STOP")) {
            autoBackupPermissions.add(Permissions.STOP);
        }
        if (Config.getInstance().getAfterBackup().equals("RESTART")) {
            autoBackupPermissions.add(Permissions.RESTART);
        }
        Scheduler.getScheduler().runAsync(Utils.plugin, () -> {
            Logger.getLogger().log("Deleting old backups...");
            StatusCommand.sendTaskStartedMessage("DeleteOldBackups", sender);
            new DeleteOldBackupsTask(true, List.of(Permissions.BACKUP), sender).run();
            Logger.getLogger().log("Deleting broken backups...");
            StatusCommand.sendTaskStartedMessage("DeleteBrokenBackups", sender);
            if (Config.getInstance().isDeleteBrokenBackups()) {
                new DeleteBrokenBackupsTask(true, List.of(Permissions.BACKUP), sender).run();
            }
            Logger.getLogger().log("Initializing auto backup...");
            if (Config.getInstance().isAutoBackup()) {
                long delay = Config.getInstance().isFixedBackupTime() ? (Config.getInstance().getBackupTime() > LocalDateTime.now().getHour() ? (long)Config.getInstance().getBackupTime() * 60L * 60L - (long)(LocalDateTime.now().getHour() * 60 * 60 + LocalDateTime.now().getMinute() * 60 + LocalDateTime.now().getSecond()) : (long)Config.getInstance().getBackupTime() * 60L * 60L + 86400L - (long)(LocalDateTime.now().getHour() * 60 * 60 + LocalDateTime.now().getMinute() * 60 + LocalDateTime.now().getSecond())) : (long)Config.getInstance().getBackupPeriod() * 60L - (LocalDateTime.now().toEpochSecond(ZoneOffset.UTC) - Config.getInstance().getLastBackup());
                if (delay <= 0L) {
                    delay = 1L;
                }
                Logger.getLogger().devLog("Delay: " + delay);
                if (Config.getInstance().getAlertTimeBeforeRestart() != -1L) {
                    long firstAlertDelay = Math.max((delay - Config.getInstance().getAlertTimeBeforeRestart()) * 20L, 1L);
                    long alertTime = Math.min(Config.getInstance().getAlertTimeBeforeRestart(), delay);
                    Scheduler.getScheduler().runSyncDelayed(Utils.plugin, () -> UIUtils.sendBackupAlert(alertTime, Config.getInstance().getAfterBackup()), firstAlertDelay);
                    long secondAlertDelay = Math.max((delay + (long)Config.getInstance().getBackupPeriod() * 60L - Config.getInstance().getAlertTimeBeforeRestart()) * 20L, 1L);
                    long period = (long)Config.getInstance().getBackupPeriod() * 60L * 20L;
                    if (Config.getInstance().isFixedBackupTime()) {
                        period = 1728000L;
                    }
                    Scheduler.getScheduler().runSyncRepeatingTask(Utils.plugin, () -> UIUtils.sendBackupAlert(Config.getInstance().getAlertTimeBeforeRestart(), Config.getInstance().getAfterBackup()), secondAlertDelay, period);
                }
                if (!Config.getInstance().isFixedBackupTime()) {
                    Scheduler.getScheduler().runSyncRepeatingTask(Utils.plugin, () -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> {
                        if (!Backuper.isLocked()) {
                            new BackupTask(Config.getInstance().getAfterBackup(), true, true, autoBackupPermissions, null).run();
                        } else {
                            Logger.getLogger().warn("Failed to start an Auto Backup task. Blocked by another operation", sender);
                        }
                    }), delay * 20L, (long)Config.getInstance().getBackupPeriod() * 60L * 20L);
                } else {
                    Scheduler.getScheduler().runSyncRepeatingTask(Utils.plugin, () -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> {
                        if (!Backuper.isLocked()) {
                            new BackupTask(Config.getInstance().getAfterBackup(), true, true, autoBackupPermissions, null).run();
                        } else {
                            Logger.getLogger().warn("Failed to start an Auto Backup task. Blocked by another operation", sender);
                        }
                    }), delay * 20L, 1728000L);
                }
            }
            Logger.getLogger().log("Auto backup initialization completed");
        });
    }

    public static void initConfig(File configFile, CommandSender sender) {
        Logger.getLogger().log("Loading config...");
        if (configFile.exists()) {
            Config.getInstance().load(configFile, sender);
        } else {
            try {
                Utils.plugin.saveDefaultConfig();
                Config.getInstance().load(configFile, sender);
            }
            catch (Exception e) {
                Logger.getLogger().warn("Something went wrong when trying to create config file!", sender);
                Logger.getLogger().warn("Initialization", e);
            }
        }
        FtpUtils.init();
        SftpUtils.init();
        GoogleDriveUtils.init();
        Logger.getLogger().log("Config loading completed", sender);
    }

    public static void initCommands() {
        CommandTree backupCommandTree = (CommandTree)new CommandTree("backuper").withPermission(Permissions.BACKUPER.getPermission());
        backupCommandTree.then(((Argument)new LiteralArgument("backup").withPermission(Permissions.BACKUP.getPermission())).then(((Argument)((Argument)((Argument)((Argument)new StringArgument("storage").includeSuggestions(ArgumentSuggestions.stringCollection(sender -> {
            int k;
            int j;
            int i;
            ArrayList<Object> suggestions = new ArrayList<Object>();
            if (Config.getInstance().getLocalConfig().isEnabled()) {
                suggestions.add("local");
            }
            if (Config.getInstance().getFtpConfig().isEnabled()) {
                suggestions.add("ftp");
            }
            if (Config.getInstance().getSftpConfig().isEnabled()) {
                suggestions.add("sftp");
            }
            if (Config.getInstance().getGoogleDriveConfig().isEnabled()) {
                suggestions.add("googleDrive");
            }
            int storageCount = suggestions.size();
            for (i = 0; i < storageCount; ++i) {
                for (j = i + 1; j < storageCount; ++j) {
                    suggestions.add((String)suggestions.get(i) + "-" + (String)suggestions.get(j));
                }
            }
            for (i = 0; i < storageCount; ++i) {
                for (j = i + 1; j < storageCount; ++j) {
                    for (k = j + 1; k < storageCount; ++k) {
                        suggestions.add((String)suggestions.get(i) + "-" + (String)suggestions.get(j) + "-" + (String)suggestions.get(k));
                    }
                }
            }
            for (i = 0; i < storageCount; ++i) {
                for (j = i + 1; j < storageCount; ++j) {
                    for (k = j + 1; k < storageCount; ++k) {
                        for (int l = k + 1; l < storageCount; ++l) {
                            suggestions.add((String)suggestions.get(i) + "-" + (String)suggestions.get(j) + "-" + (String)suggestions.get(k) + "-" + (String)suggestions.get(l));
                        }
                    }
                }
            }
            return suggestions;
        }))).executes((sender, args) -> new BackupCommand(sender, args).execute(), new ExecutorType[0])).then((AbstractArgumentTree)new LongArgument("delaySeconds").executes((sender, args) -> new BackupCommand(sender, args).execute(), new ExecutorType[0]))).then(((Argument)((Argument)new LiteralArgument("stop").withPermission(Permissions.STOP.getPermission())).executes((sender, args) -> new BackupCommand(sender, args, "STOP").execute(), new ExecutorType[0])).then((AbstractArgumentTree)new LongArgument("delaySeconds").executes((sender, args) -> new BackupCommand(sender, args, "STOP").execute(), new ExecutorType[0])))).then(((Argument)((Argument)new LiteralArgument("restart").withPermission(Permissions.RESTART.getPermission())).executes((sender, args) -> new BackupCommand(sender, args, "RESTART").execute(), new ExecutorType[0])).then((AbstractArgumentTree)new LongArgument("delaySeconds").executes((sender, args) -> new BackupCommand(sender, args, "RESTART").execute(), new ExecutorType[0])))));
        backupCommandTree.register();
        CommandTree backupListCommandTree = (CommandTree)new CommandTree("backuper").withPermission(Permissions.BACKUPER.getPermission());
        backupListCommandTree.then(((Argument)((Argument)((Argument)new LiteralArgument("list").then(((Argument)((Argument)((Argument)new LiteralArgument("local").withRequirement(sender -> Config.getInstance().getLocalConfig().isEnabled())).withPermission(Permissions.LOCAL_LIST.getPermission())).executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new ListCommand("local", sender, args).execute()), new ExecutorType[0])).then((AbstractArgumentTree)new IntegerArgument("pageNumber").executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new ListCommand("local", sender, args).execute()), new ExecutorType[0])))).then(((Argument)((Argument)((Argument)new LiteralArgument("sftp").withRequirement(sender -> Config.getInstance().getSftpConfig().isEnabled())).withPermission(Permissions.SFTP_LIST.getPermission())).executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new ListCommand("sftp", sender, args).execute()), new ExecutorType[0])).then((AbstractArgumentTree)new IntegerArgument("pageNumber").executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new ListCommand("sftp", sender, args).execute()), new ExecutorType[0])))).then(((Argument)((Argument)((Argument)new LiteralArgument("ftp").withRequirement(sender -> Config.getInstance().getFtpConfig().isEnabled())).withPermission(Permissions.FTP_LIST.getPermission())).executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new ListCommand("ftp", sender, args).execute()), new ExecutorType[0])).then((AbstractArgumentTree)new IntegerArgument("pageNumber").executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new ListCommand("ftp", sender, args).execute()), new ExecutorType[0])))).then(((Argument)((Argument)((Argument)new LiteralArgument("googleDrive").withRequirement(sender -> Config.getInstance().getGoogleDriveConfig().isEnabled() && GoogleDriveUtils.isAuthorized(null))).withPermission(Permissions.GOOGLE_DRIVE_LIST.getPermission())).executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new ListCommand("googleDrive", sender, args).execute()), new ExecutorType[0])).then((AbstractArgumentTree)new IntegerArgument("pageNumber").executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new ListCommand("googleDrive", sender, args).execute()), new ExecutorType[0]))));
        backupListCommandTree.register();
        CommandTree backupReloadCommandTree = (CommandTree)new CommandTree("backuper").withPermission(Permissions.BACKUPER.getPermission());
        backupReloadCommandTree.then(((Argument)new LiteralArgument("config").withPermission(Permissions.CONFIG.getPermission())).then((AbstractArgumentTree)((Argument)new LiteralArgument("reload").withPermission(Permissions.RELOAD.getPermission())).executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new ReloadCommand(sender, args).execute()), new ExecutorType[0])));
        backupReloadCommandTree.register();
        CommandTree backupMenuCommandTree = (CommandTree)new CommandTree("backuper").withPermission(Permissions.BACKUPER.getPermission());
        backupMenuCommandTree.then(((Argument)((Argument)((Argument)new LiteralArgument("menu").then(((Argument)((Argument)new LiteralArgument("local").withRequirement(sender -> Config.getInstance().getLocalConfig().isEnabled())).withPermission(Permissions.LOCAL_LIST.getPermission())).then(((Argument)((Argument)new TextArgument("backupName").includeSuggestions(ArgumentSuggestions.stringCollectionAsync(info -> CompletableFuture.supplyAsync(() -> {
            ArrayList<LocalBackup> backups = LocalBackup.getBackups();
            ArrayList<LocalDateTime> backupDateTimes = new ArrayList<LocalDateTime>();
            for (LocalBackup backup : backups) {
                backupDateTimes.add(backup.getLocalDateTime());
            }
            Utils.sortLocalDateTimeDecrease(backupDateTimes);
            ArrayList<CallSite> backupSuggestions = new ArrayList<CallSite>();
            for (LocalBackup backup : backups) {
                backupSuggestions.add((CallSite)((Object)("\"" + backup.getName() + "\"")));
            }
            return backupSuggestions;
        })))).executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new MenuCommand("local", sender, args).execute()), new ExecutorType[0])).then((AbstractArgumentTree)((Argument)new StringArgument("action").replaceSuggestions(ArgumentSuggestions.stringCollection(senderSuggestionInfo -> {
            ArrayList<String> suggestions = new ArrayList<String>();
            String backupName = (String)senderSuggestionInfo.previousArgs().get("backupName");
            LocalBackup backup = LocalBackup.getInstance(backupName);
            try {
                if (backup.getFileType().equals("(Folder)")) {
                    suggestions.add("toZIP");
                }
                if (backup.getFileType().equals("(ZIP)")) {
                    suggestions.add("unZIP");
                }
                suggestions.add("delete");
                if (Config.getInstance().getFtpConfig().isEnabled()) {
                    suggestions.add("copyToFtp");
                }
                if (Config.getInstance().getSftpConfig().isEnabled()) {
                    suggestions.add("copyToSftp");
                }
                if (Config.getInstance().getGoogleDriveConfig().isEnabled() && GoogleDriveUtils.isAuthorized(null)) {
                    suggestions.add("copyToGoogleDrive");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return suggestions;
        }))).executes((sender, args) -> {
            if (Objects.equals(args.get("action"), "deleteConfirmation")) {
                if (sender.hasPermission(Permissions.LOCAL_DELETE.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new DeleteConfirmationCommand("local", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "delete")) {
                if (sender.hasPermission(Permissions.LOCAL_DELETE.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new DeleteCommand("local", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "toZIPConfirmation")) {
                if (sender.hasPermission(Permissions.LOCAL_TO_ZIP.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new ToZIPConfirmationCommand(sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "toZIP")) {
                if (sender.hasPermission(Permissions.LOCAL_TO_ZIP.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new ToZIPCommand(sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "unZIPConfirmation")) {
                if (sender.hasPermission(Permissions.LOCAL_UNZIP.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new UnZIPConfirmationCommand(sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "unZIP")) {
                if (sender.hasPermission(Permissions.LOCAL_UNZIP.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new UnZIPCommand(sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "copyToSftpConfirmation")) {
                if (sender.hasPermission(Permissions.LOCAL_COPY_TO_SFTP.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CopyToSftpConfirmationCommand(sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "copyToSftp")) {
                if (sender.hasPermission(Permissions.LOCAL_COPY_TO_SFTP.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CopyToSftpCommand(sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "copyToFtpConfirmation")) {
                if (sender.hasPermission(Permissions.LOCAL_COPY_TO_FTP.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CopyToFtpConfirmationCommand(sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "copyToFtp")) {
                if (sender.hasPermission(Permissions.LOCAL_COPY_TO_FTP.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CopyToFtpCommand(sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "copyToGoogleDriveConfirmation")) {
                if (sender.hasPermission(Permissions.LOCAL_COPY_TO_GOOGLE_DRIVE.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CopyToGoogleDriveConfirmationCommand(sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "copyToGoogleDrive")) {
                if (sender.hasPermission(Permissions.LOCAL_COPY_TO_GOOGLE_DRIVE.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CopyToGoogleDriveCommand(sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
        }, new ExecutorType[0]))))).then(((Argument)((Argument)new LiteralArgument("sftp").withRequirement(sender -> Config.getInstance().getSftpConfig().isEnabled())).withPermission(Permissions.SFTP_LIST.getPermission())).then(((Argument)((Argument)new TextArgument("backupName").includeSuggestions(ArgumentSuggestions.stringCollectionAsync(info -> CompletableFuture.supplyAsync(() -> {
            ArrayList<SftpBackup> backups = SftpBackup.getBackups();
            ArrayList<LocalDateTime> backupDateTimes = new ArrayList<LocalDateTime>();
            for (SftpBackup backup : backups) {
                backupDateTimes.add(backup.getLocalDateTime());
            }
            Utils.sortLocalDateTimeDecrease(backupDateTimes);
            ArrayList<CallSite> backupSuggestions = new ArrayList<CallSite>();
            for (SftpBackup backup : backups) {
                backupSuggestions.add((CallSite)((Object)("\"" + backup.getName() + "\"")));
            }
            return backupSuggestions;
        })))).executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new MenuCommand("sftp", sender, args).execute()), new ExecutorType[0])).then((AbstractArgumentTree)((Argument)new StringArgument("action").replaceSuggestions(ArgumentSuggestions.strings("delete", "copyToLocal"))).executes((sender, args) -> {
            if (Objects.equals(args.get("action"), "deleteConfirmation")) {
                if (sender.hasPermission(Permissions.SFTP_DELETE.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new DeleteConfirmationCommand("sftp", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "delete")) {
                if (sender.hasPermission(Permissions.SFTP_DELETE.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new DeleteCommand("sftp", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "copyToLocalConfirmation")) {
                if (sender.hasPermission(Permissions.SFTP_COPY_TO_LOCAL.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CopyToLocalConfirmationCommand("sftp", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "copyToLocal")) {
                if (sender.hasPermission(Permissions.SFTP_COPY_TO_LOCAL.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CopyToLocalCommand("sftp", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
        }, new ExecutorType[0]))))).then(((Argument)((Argument)new LiteralArgument("ftp").withRequirement(sender -> Config.getInstance().getFtpConfig().isEnabled())).withPermission(Permissions.FTP_LIST.getPermission())).then(((Argument)((Argument)new TextArgument("backupName").includeSuggestions(ArgumentSuggestions.stringCollectionAsync(info -> CompletableFuture.supplyAsync(() -> {
            ArrayList<FtpBackup> backups = FtpBackup.getBackups();
            ArrayList<LocalDateTime> backupDateTimes = new ArrayList<LocalDateTime>();
            for (FtpBackup backup : backups) {
                backupDateTimes.add(backup.getLocalDateTime());
            }
            Utils.sortLocalDateTimeDecrease(backupDateTimes);
            ArrayList<CallSite> backupSuggestions = new ArrayList<CallSite>();
            for (FtpBackup backup : backups) {
                backupSuggestions.add((CallSite)((Object)("\"" + backup.getName() + "\"")));
            }
            return backupSuggestions;
        })))).executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new MenuCommand("ftp", sender, args).execute()), new ExecutorType[0])).then((AbstractArgumentTree)((Argument)new StringArgument("action").replaceSuggestions(ArgumentSuggestions.strings("delete", "copyToLocal"))).executes((sender, args) -> {
            if (Objects.equals(args.get("action"), "deleteConfirmation")) {
                if (sender.hasPermission(Permissions.FTP_DELETE.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new DeleteConfirmationCommand("ftp", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "delete")) {
                if (sender.hasPermission(Permissions.FTP_DELETE.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new DeleteCommand("ftp", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "copyToLocalConfirmation")) {
                if (sender.hasPermission(Permissions.FTP_COPY_TO_LOCAL.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CopyToLocalConfirmationCommand("ftp", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "copyToLocal")) {
                if (sender.hasPermission(Permissions.FTP_COPY_TO_LOCAL.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CopyToLocalCommand("ftp", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
        }, new ExecutorType[0]))))).then(((Argument)((Argument)new LiteralArgument("googleDrive").withRequirement(sender -> Config.getInstance().getGoogleDriveConfig().isEnabled() && GoogleDriveUtils.isAuthorized(null))).withPermission(Permissions.GOOGLE_DRIVE_LIST.getPermission())).then(((Argument)((Argument)new TextArgument("backupName").includeSuggestions(ArgumentSuggestions.stringCollectionAsync(info -> CompletableFuture.supplyAsync(() -> {
            ArrayList<GoogleDriveBackup> backups = GoogleDriveBackup.getBackups();
            ArrayList<LocalDateTime> backupDateTimes = new ArrayList<LocalDateTime>();
            for (GoogleDriveBackup backup : backups) {
                backupDateTimes.add(backup.getLocalDateTime());
            }
            Utils.sortLocalDateTimeDecrease(backupDateTimes);
            ArrayList<CallSite> backupSuggestions = new ArrayList<CallSite>();
            for (GoogleDriveBackup backup : backups) {
                backupSuggestions.add((CallSite)((Object)("\"" + backup.getName() + "\"")));
            }
            return backupSuggestions;
        })))).executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new MenuCommand("googleDrive", sender, args).execute()), new ExecutorType[0])).then((AbstractArgumentTree)((Argument)new StringArgument("action").replaceSuggestions(ArgumentSuggestions.strings("delete", "copyToLocal"))).executes((sender, args) -> {
            if (Objects.equals(args.get("action"), "deleteConfirmation")) {
                if (sender.hasPermission(Permissions.GOOGLE_DRIVE_DELETE.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new DeleteConfirmationCommand("googleDrive", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "delete")) {
                if (sender.hasPermission(Permissions.GOOGLE_DRIVE_DELETE.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new DeleteCommand("googleDrive", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "copyToLocalConfirmation")) {
                if (sender.hasPermission(Permissions.GOOGLE_DRIVE_COPY_TO_LOCAL.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CopyToLocalConfirmationCommand("googleDrive", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
            if (Objects.equals(args.get("action"), "copyToLocal")) {
                if (sender.hasPermission(Permissions.GOOGLE_DRIVE_COPY_TO_LOCAL.getPermission())) {
                    Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CopyToLocalCommand("googleDrive", sender, args).execute());
                } else {
                    UIUtils.returnFailure("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", sender);
                }
            }
        }, new ExecutorType[0])))));
        backupMenuCommandTree.register();
        CommandTree backupTaskCommandTree = (CommandTree)new CommandTree("backuper").withPermission(Permissions.BACKUPER.getPermission());
        backupTaskCommandTree.then(((Argument)new LiteralArgument("task").then((AbstractArgumentTree)((Argument)new StringArgument("action").replaceSuggestions(ArgumentSuggestions.strings("cancel"))).executes((sender, args) -> {
            if (Objects.equals(args.get("action"), "cancelConfirmation")) {
                Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CancelConfirmationCommand(sender, args).execute());
            }
            if (Objects.equals(args.get("action"), "cancel")) {
                Scheduler.getScheduler().runAsync(Utils.plugin, () -> new CancelCommand(sender, args).execute());
            }
        }, new ExecutorType[0]))).then((AbstractArgumentTree)((Argument)new LiteralArgument("status").withPermission(Permissions.STATUS.getPermission())).executes((sender, args) -> new StatusCommand(sender, args).execute(), new ExecutorType[0])));
        backupTaskCommandTree.register();
        CommandTree backupAccountCommandTree = (CommandTree)new CommandTree("backuper").withPermission(Permissions.BACKUPER.getPermission());
        backupAccountCommandTree.then(new LiteralArgument("account").then(((Argument)((Argument)new LiteralArgument("googleDrive").withRequirement(sender -> Config.getInstance().getGoogleDriveConfig().isEnabled())).withPermission(Permissions.GOOGLE_DRIVE_ACCOUNT.getPermission())).then((AbstractArgumentTree)new LiteralArgument("link").executes((sender, args) -> Scheduler.getScheduler().runAsync(Utils.plugin, () -> new GoogleDriveLinkCommand(sender, args).execute()), new ExecutorType[0]))));
        backupAccountCommandTree.register();
    }

    public static void initEventHandlers() {
        Bukkit.getPluginManager().registerEvents((Listener)new Initialization(), Utils.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new WorldChangeCatcher(), Utils.plugin);
        boolean areWorldChangeEventsExists = true;
        for (String eventName : WorldChangeCatcherNew.eventNames) {
            try {
                Class.forName(eventName);
            }
            catch (Exception e) {
                areWorldChangeEventsExists = false;
            }
        }
        if (areWorldChangeEventsExists) {
            Bukkit.getPluginManager().registerEvents((Listener)new WorldChangeCatcherNew(), Utils.plugin);
        }
    }

    public static void checkDependencies() {
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.EntityScheduler");
            Utils.isFolia = true;
            Logger.getLogger().devLog("Folia/Paper(1.20+) has been detected!");
        }
        catch (Exception e) {
            Utils.isFolia = false;
            Logger.getLogger().devLog("Folia/Paper(1.20+) has not been detected!");
        }
    }

    public static void checkPluginVersion() {
        if (!Config.getInstance().isCheckUpdates()) {
            return;
        }
        try {
            String input;
            HttpURLConnection connection = (HttpURLConnection)Utils.getLatestVersionURL.openConnection();
            connection.setRequestMethod("GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((input = in.readLine()) != null) {
                response.append(input);
            }
            in.close();
            if (response.toString().equals(Utils.getProperty("version"))) {
                Utils.isUpdatedToLatest = true;
                Logger.getLogger().log("You are using the latest version of the BACKUPER!");
            } else {
                Utils.isUpdatedToLatest = false;
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to check the Backuper updates!");
            Logger.getLogger().warn(Initialization.class, e);
        }
    }

    public static void sendIssueToGitHub() {
        String message = "\n" + "-".repeat(75) + "\n";
        message = message + "Please, if you find any issues related to the Backuper\nCreate an issue using the link: https://github.com/DVDishka/Backuper/issues\n";
        message = message + "-".repeat(75);
        Logger.getLogger().log(message);
    }

    public static void sendGoogleAccountCheckResult(CommandSender sender) {
        if (sender.isOp() && Config.getInstance().getGoogleDriveConfig().isEnabled() && !GoogleDriveUtils.isAuthorized(null)) {
            TextComponent message = Component.empty();
            if (sender instanceof ConsoleCommandSender) {
                message = message.append((Component)Component.newline());
            }
            message = message.append((Component)(sender instanceof ConsoleCommandSender ? Component.text((String)"-".repeat(75)) : ((TextComponent)Component.text((String)"------------------------------------------").decorate(TextDecoration.BOLD)).color(TextColor.color((int)14917651)))).append((Component)Component.newline());
            message = message.append(((TextComponent)Component.text((String)"Google Drive storage is enabled, but Google account is not linked!").decorate(TextDecoration.BOLD)).color((TextColor)NamedTextColor.RED)).append((Component)Component.newline()).append(((TextComponent)Component.text((String)"Use ").decorate(TextDecoration.BOLD)).color((TextColor)NamedTextColor.RED)).append(((TextComponent)Component.text((String)"/backuper account googleDrive link").decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.suggestCommand((String)"/backuper account googleDrive link")));
            message = message.append((Component)Component.newline()).append((Component)(sender instanceof ConsoleCommandSender ? Component.text((String)"-".repeat(75)) : ((TextComponent)Component.text((String)"------------------------------------------").decorate(TextDecoration.BOLD)).color(TextColor.color((int)14917651))));
            sender.sendMessage((Component)message);
        }
    }

    public static void sendPluginVersionCheckResult(CommandSender sender) {
        if (sender.isOp() && !Utils.isUpdatedToLatest) {
            TextComponent message = Component.empty();
            if (sender instanceof ConsoleCommandSender) {
                message = message.append((Component)Component.newline());
            }
            message = message.append((Component)(sender instanceof ConsoleCommandSender ? Component.text((String)"-".repeat(75)) : ((TextComponent)Component.text((String)"------------------------------------------").decorate(TextDecoration.BOLD)).color(TextColor.color((int)14917651)))).append((Component)Component.newline());
            message = message.append(((TextComponent)Component.text((String)"You are using an outdated version of Backuper!\nPlease update it to the latest and check the changelist!").decorate(TextDecoration.BOLD)).color((TextColor)NamedTextColor.RED));
            int downloadLinkNumber = 0;
            for (String downloadLink : Utils.downloadLinks) {
                message = message.append((Component)Component.newline());
                message = message.append(((TextComponent)Component.text((String)("Download link: " + (sender instanceof ConsoleCommandSender ? downloadLink : Utils.downloadLinksName.get(downloadLinkNumber)))).clickEvent(ClickEvent.openUrl((String)downloadLink))).decorate(TextDecoration.UNDERLINED));
                ++downloadLinkNumber;
            }
            message = message.append((Component)Component.newline()).append((Component)(sender instanceof ConsoleCommandSender ? Component.text((String)"-".repeat(75)) : ((TextComponent)Component.text((String)"------------------------------------------").decorate(TextDecoration.BOLD)).color(TextColor.color((int)14917651))));
            sender.sendMessage((Component)message);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Initialization.sendPluginVersionCheckResult((CommandSender)event.getPlayer());
        Initialization.sendGoogleAccountCheckResult((CommandSender)event.getPlayer());
    }

    @EventHandler
    public void onStartCompleted(ServerLoadEvent event) {
        Initialization.initAutoBackup((CommandSender)Bukkit.getConsoleSender());
    }

    public static void unifyBackupNameFormat(CommandSender sender) {
        Logger.getLogger().log("Unifying backup names format");
        BackwardsCompatibility.unifyBackupNameFormat(sender);
        Logger.getLogger().log("Backup names format unification completed");
    }

    public static void checkStorages(CommandSender sender) {
        if (Config.getInstance().getFtpConfig().isEnabled()) {
            if (FtpUtils.checkConnection(sender)) {
                Logger.getLogger().log("FTP(S) connection established successfully", sender);
            } else {
                Logger.getLogger().warn("Failed to establish FTP(S) connection", sender);
            }
        }
        if (Config.getInstance().getSftpConfig().isEnabled()) {
            if (SftpUtils.checkConnection(sender)) {
                Logger.getLogger().log("SFTP connection established successfully", sender);
            } else {
                Logger.getLogger().warn("Failed to establish SFTP connection", sender);
            }
        }
    }

    public static void loadSizeCache(CommandSender sender) {
        try {
            int length;
            File sizeCacheFile = Config.getInstance().getSizeCacheFile();
            try {
                if (!sizeCacheFile.exists() && !sizeCacheFile.createNewFile()) {
                    Logger.getLogger().warn("Can not create " + sizeCacheFile.getPath() + " file!");
                }
            }
            catch (Exception e) {
                Logger.getLogger().warn("Can not create " + sizeCacheFile.getPath() + " file!");
            }
            FileReader reader = new FileReader(sizeCacheFile);
            StringBuilder json = new StringBuilder();
            char[] buffer = new char[1024];
            while ((length = reader.read(buffer)) != -1) {
                json.append(new String(buffer, 0, length));
            }
            reader.close();
            Backup.loadSizeCache(json.toString(), sender);
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to load backups size cache", sender);
            Logger.getLogger().warn(Initialization.class, e);
        }
    }
}

