/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.backup;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.backend.backup.ExternalBackup;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.ftp.FtpDeleteDirTask;
import ru.dvdishka.backuper.backend.utils.FtpUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class FtpBackup
extends ExternalBackup {
    private static HashMap<String, FtpBackup> backups = new HashMap();

    private FtpBackup(String backupName) {
        this.backupName = backupName;
    }

    public static FtpBackup getInstance(String backupName) {
        if (!FtpBackup.checkBackupExistenceByName(backupName)) {
            return null;
        }
        if (backups.containsKey(backupName)) {
            return backups.get(backupName);
        }
        FtpBackup backup = new FtpBackup(backupName);
        backups.put(backupName, backup);
        return backup;
    }

    public static boolean checkBackupExistenceByName(String backupName) {
        if (!Config.getInstance().getFtpConfig().isEnabled()) {
            return false;
        }
        try {
            LocalDateTime.parse(backupName, Config.getInstance().getDateTimeFormatter());
        }
        catch (Exception e) {
            return false;
        }
        ArrayList<String> backupFileNames = FtpUtils.ls(Config.getInstance().getFtpConfig().getBackupsFolder(), null);
        return backupFileNames.contains(backupName) || backupFileNames.contains(backupName + ".zip");
    }

    public static ArrayList<FtpBackup> getBackups() {
        if (!Config.getInstance().getFtpConfig().isEnabled()) {
            return new ArrayList<FtpBackup>();
        }
        ArrayList<FtpBackup> backups = new ArrayList<FtpBackup>();
        for (String fileName : FtpUtils.ls(Config.getInstance().getFtpConfig().getBackupsFolder(), null)) {
            try {
                FtpBackup backup = FtpBackup.getInstance(fileName.replace(".zip", ""));
                if (backup == null) continue;
                backups.add(backup);
            }
            catch (Exception exception) {}
        }
        return backups;
    }

    @Override
    Task getDirectDeleteTask(boolean setLocked, CommandSender sender) {
        return new FtpDeleteDirTask(this.getPath(), setLocked, List.of(Permissions.FTP_DELETE), sender);
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        return LocalDateTime.parse(this.backupName, Config.getInstance().getDateTimeFormatter());
    }

    @Override
    public String getName() {
        return this.backupName;
    }

    @Override
    public String getFileName() {
        if (this.getFileType().equals("(ZIP)")) {
            return this.backupName + ".zip";
        }
        return this.backupName;
    }

    @Override
    long calculateByteSize(CommandSender sender) {
        long size = FtpUtils.getDirByteSize(this.getPath(), sender);
        return size;
    }

    @Override
    public String getFileType() {
        if (FtpUtils.ls(Config.getInstance().getFtpConfig().getBackupsFolder(), null).contains(this.backupName + ".zip")) {
            return "(ZIP)";
        }
        return "(Folder)";
    }

    @Override
    public String getPath() {
        return FtpUtils.resolve(Config.getInstance().getFtpConfig().getBackupsFolder(), this.getFileName());
    }
}

