/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.backup;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.api.services.drive.model.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.backend.backup.ExternalBackup;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.googleDrive.GoogleDriveDeleteFileFolderTask;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class GoogleDriveBackup
extends ExternalBackup {
    private static final Cache<String, GoogleDriveBackup> backups = Caffeine.newBuilder().build(GoogleDriveBackup::getInstance);
    private static final Cache<String, ArrayList<GoogleDriveBackup>> backupList = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).expireAfterAccess(5L, TimeUnit.SECONDS).build();

    private GoogleDriveBackup(String backupName) {
        this.backupName = backupName;
    }

    public static GoogleDriveBackup getInstance(String backupName) {
        if (!GoogleDriveBackup.checkBackupExistenceByName(backupName = backupName.replace(".zip", ""))) {
            return null;
        }
        return backups.get(backupName, GoogleDriveBackup::new);
    }

    public static ArrayList<GoogleDriveBackup> getBackups() {
        if (!Config.getInstance().getGoogleDriveConfig().isEnabled()) {
            return new ArrayList<GoogleDriveBackup>();
        }
        return backupList.get("all", key -> {
            ArrayList<GoogleDriveBackup> backups = new ArrayList<GoogleDriveBackup>();
            for (File driveFile : GoogleDriveUtils.ls(Config.getInstance().getGoogleDriveConfig().getBackupsFolderId(), null)) {
                try {
                    GoogleDriveBackup backup = GoogleDriveBackup.getInstance(driveFile.getName().replace(".zip", ""));
                    if (backup == null) continue;
                    backups.add(backup);
                }
                catch (Exception exception) {}
            }
            return backups;
        });
    }

    public static boolean checkBackupExistenceByName(String backupName) {
        if (!Config.getInstance().getGoogleDriveConfig().isEnabled()) {
            return false;
        }
        try {
            LocalDateTime.parse(backupName, Config.getInstance().getDateTimeFormatter());
        }
        catch (Exception e) {
            return false;
        }
        try {
            List<File> backupDriveFiles = GoogleDriveUtils.ls(Config.getInstance().getGoogleDriveConfig().getBackupsFolderId(), null);
            for (File backupDriveFile : backupDriveFiles) {
                if (!backupDriveFile.getName().replace(".zip", "").equals(backupName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to connect to GoogleDrive or a Google account is not connected");
            Logger.getLogger().warn(GoogleDriveBackup.class, e);
            return false;
        }
    }

    @Override
    Task getDirectDeleteTask(boolean setLocked, CommandSender sender) {
        return new GoogleDriveDeleteFileFolderTask(this.getDriveFile(sender).getId(), setLocked, List.of(Permissions.GOOGLE_DRIVE_DELETE), sender);
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        return LocalDateTime.parse(this.backupName, Config.getInstance().getDateTimeFormatter());
    }

    @Override
    public String getName() {
        return this.backupName;
    }

    @Override
    long calculateByteSize(CommandSender sender) {
        try {
            File driveFile = (File)GoogleDriveUtils.getService(sender).files().get(this.getPath()).setFields("appProperties").execute();
            Map<String, String> appProperties = driveFile.getAppProperties();
            if (appProperties.get("size") != null) {
                return Long.parseLong(driveFile.getAppProperties().get("size"));
            }
        }
        catch (Exception driveFile) {
            // empty catch block
        }
        try {
            long size = GoogleDriveUtils.getFileByteSize(this.getDriveFile(sender).getId(), sender);
            this.saveSizeToFileProperties(size, sender);
            return size;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public void saveSizeToFileProperties(long byteSize, CommandSender sender) {
        try {
            GoogleDriveUtils.addProperty(this.getDriveFile(sender).getId(), "size", String.valueOf(byteSize), sender);
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to save backup size to Google Drive", sender);
            Logger.getLogger().warn(GoogleDriveBackup.class, e);
        }
    }

    @Override
    public String getFileType() {
        return GoogleDriveUtils.getFileByName(this.backupName + ".zip", Config.getInstance().getGoogleDriveConfig().getBackupsFolderId(), null) != null ? "(ZIP)" : "(Folder)";
    }

    @Override
    public String getFileName() {
        return this.getDriveFile(null).getName();
    }

    @Override
    public String getPath() {
        return this.getDriveFile(null).getId();
    }

    public File getDriveFile(CommandSender sender) {
        try {
            return GoogleDriveUtils.getFileByName(this.backupName + (Objects.equals(this.getFileType(), "(ZIP)") ? ".zip" : ""), Config.getInstance().getGoogleDriveConfig().getBackupsFolderId(), sender);
        }
        catch (Exception e) {
            return null;
        }
    }
}

