/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.backup;

import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.backup.ExternalBackup;
import ru.dvdishka.backuper.backend.backup.StorageType;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.local.folder.DeleteDirTask;
import ru.dvdishka.backuper.backend.tasks.local.zip.tozip.ConvertFolderToZipTask;
import ru.dvdishka.backuper.backend.tasks.local.zip.unzip.ConvertZipToFolderTask;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class LocalBackup
extends ExternalBackup {
    private LocalDateTime backupLocalDateTime;
    private static HashMap<String, LocalBackup> backups = new HashMap();

    public static LocalBackup getInstance(String backupName) {
        if (!LocalBackup.checkBackupExistenceByName(backupName)) {
            return null;
        }
        if (backups.containsKey(backupName)) {
            return backups.get(backupName);
        }
        LocalBackup backup = new LocalBackup(backupName);
        backups.put(backupName, backup);
        return backup;
    }

    private LocalBackup(String backupName) {
        this.backupName = backupName;
        this.backupLocalDateTime = LocalDateTime.parse(backupName, Config.getInstance().getDateTimeFormatter());
    }

    public static ArrayList<LocalBackup> getBackups() {
        if (!Config.getInstance().getLocalConfig().isEnabled()) {
            return new ArrayList<LocalBackup>();
        }
        ArrayList<LocalBackup> backups = new ArrayList<LocalBackup>();
        if (!new File(Config.getInstance().getLocalConfig().getBackupsFolder()).exists() || new File(Config.getInstance().getLocalConfig().getBackupsFolder()).listFiles() == null) {
            Logger.getLogger().warn("Wrong local.backupsFolder config value! (Maybe the specified folder does not exist)");
            return backups;
        }
        for (File file : Objects.requireNonNull(new File(Config.getInstance().getLocalConfig().getBackupsFolder()).listFiles())) {
            try {
                LocalBackup localBackup = LocalBackup.getInstance(file.getName().replace(".zip", ""));
                if (localBackup == null) continue;
                backups.add(localBackup);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return backups;
    }

    @Override
    public String getName() {
        return this.backupName;
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        return this.backupLocalDateTime;
    }

    @Override
    long calculateByteSize(CommandSender sender) {
        File backupsFolder = new File(Config.getInstance().getLocalConfig().getBackupsFolder());
        Object backupFilePath = backupsFolder.toPath().resolve(this.backupName).toFile().exists() ? backupsFolder.toPath().resolve(this.backupName).toFile().getPath() : backupsFolder.toPath().resolve(this.backupName).toFile().getPath() + ".zip";
        long size = Utils.getFileFolderByteSize(new File((String)backupFilePath));
        return size;
    }

    @Override
    public String getFileType() {
        File backupsFolder = new File(Config.getInstance().getLocalConfig().getBackupsFolder());
        String zipOrFolder = "(ZIP)";
        if (backupsFolder.toPath().resolve(this.backupName).toFile().exists()) {
            zipOrFolder = "(Folder)";
        }
        return zipOrFolder;
    }

    @Override
    public String getFileName() {
        if (this.getFileType().equals("(ZIP)")) {
            return this.backupName + ".zip";
        }
        return this.backupName;
    }

    @Override
    public String getPath() {
        return new File(Config.getInstance().getLocalConfig().getBackupsFolder(), this.getFileName()).getPath();
    }

    public File getFile() {
        File backupsFolder = new File(Config.getInstance().getLocalConfig().getBackupsFolder());
        if (this.getFileType().equals("(ZIP)")) {
            return backupsFolder.toPath().resolve(this.backupName + ".zip").toFile();
        }
        return backupsFolder.toPath().resolve(this.backupName).toFile();
    }

    public File getZIPFile() {
        File backupsFolder = new File(Config.getInstance().getLocalConfig().getBackupsFolder());
        if (backupsFolder.toPath().resolve(this.backupName + ".zip").toFile().exists()) {
            return backupsFolder.toPath().resolve(this.backupName + ".zip").toFile();
        }
        return null;
    }

    public static boolean checkBackupExistenceByName(String backupName) {
        if (!Config.getInstance().getLocalConfig().isEnabled()) {
            return false;
        }
        try {
            LocalDateTime.parse(backupName, Config.getInstance().getDateTimeFormatter());
        }
        catch (Exception e) {
            return false;
        }
        File backupsFolder = new File(Config.getInstance().getLocalConfig().getBackupsFolder());
        return backupsFolder.toPath().resolve(backupName).toFile().exists() || backupsFolder.toPath().resolve(backupName + ".zip").toFile().exists();
    }

    @Override
    Task getDirectDeleteTask(boolean setLocked, CommandSender sender) {
        return new DeleteDirTask(this.getFile(), setLocked, List.of(Permissions.LOCAL_DELETE), sender);
    }

    private Task getDirectToZipTask(boolean setLocked, CommandSender sender) {
        return new ConvertFolderToZipTask(this.getFile(), setLocked, List.of(Permissions.LOCAL_TO_ZIP), sender);
    }

    private Task getDirectUnZipTask(boolean setLocked, CommandSender sender) {
        return new ConvertZipToFolderTask(this.getZIPFile(), setLocked, List.of(Permissions.LOCAL_UNZIP), sender);
    }

    public Task getToZipTask(boolean setLocked, CommandSender sender) {
        return new BackupToZipTask(this, setLocked, sender);
    }

    public void toZip(boolean setLocked, CommandSender sender) {
        this.getToZipTask(setLocked, sender).run();
    }

    public Task getUnZipTask(boolean setLocked, CommandSender sender) {
        return new BackupUnZipTask(this, setLocked, sender);
    }

    public void unZip(boolean setLocked, CommandSender sender) {
        this.getUnZipTask(setLocked, sender).run();
    }

    public class BackupToZipTask
    extends Task {
        private static final String taskName = "BackupToZip";
        private LocalBackup backup;
        private Task toZipTask;

        public BackupToZipTask(LocalBackup backup, boolean setLocked, CommandSender sender) {
            super(taskName, setLocked, List.of(Permissions.LOCAL_TO_ZIP), sender);
            this.backup = null;
            this.toZipTask = null;
            this.backup = backup;
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            try {
                if (this.setLocked) {
                    Backuper.lock(this);
                }
                if (!this.isTaskPrepared) {
                    this.prepareTask();
                }
                if (!this.cancelled) {
                    this.toZipTask.run();
                }
                Backup.cachedBackupsSize.get((Object)StorageType.LOCAL).invalidate(this.backup.getName());
                if (this.setLocked) {
                    UIUtils.successSound(this.sender);
                    Backuper.unlock();
                }
            }
            catch (Exception e) {
                if (this.setLocked) {
                    UIUtils.cancelSound(this.sender);
                    Backuper.unlock();
                }
                Logger.getLogger().warn("BackupToZip task has been finished with an exception", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
            }
        }

        @Override
        public void prepareTask() {
            this.isTaskPrepared = true;
            if (this.cancelled) {
                return;
            }
            this.toZipTask = this.backup.getDirectToZipTask(false, this.sender);
            this.toZipTask.prepareTask();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            if (this.toZipTask != null) {
                this.toZipTask.cancel();
            }
        }

        @Override
        public long getTaskMaxProgress() {
            if (!this.isTaskPrepared) {
                return 0L;
            }
            return this.toZipTask.getTaskMaxProgress();
        }

        @Override
        public long getTaskCurrentProgress() {
            if (!this.isTaskPrepared) {
                return 0L;
            }
            return this.toZipTask.getTaskCurrentProgress();
        }
    }

    public class BackupUnZipTask
    extends Task {
        private static final String taskName = "BackupUnZip";
        private LocalBackup backup;
        private Task unZipTask;

        public BackupUnZipTask(LocalBackup backup, boolean setLocked, CommandSender sender) {
            super(taskName, setLocked, List.of(Permissions.LOCAL_UNZIP), sender);
            this.backup = null;
            this.unZipTask = null;
            this.backup = backup;
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            try {
                if (this.setLocked) {
                    Backuper.lock(this);
                }
                if (!this.isTaskPrepared) {
                    this.prepareTask();
                }
                if (!this.cancelled) {
                    this.unZipTask.run();
                }
                Backup.cachedBackupsSize.get((Object)StorageType.LOCAL).invalidate(this.backup.getName());
                if (this.setLocked) {
                    UIUtils.successSound(this.sender);
                    Backuper.unlock();
                }
            }
            catch (Exception e) {
                if (this.setLocked) {
                    UIUtils.cancelSound(this.sender);
                    Backuper.unlock();
                }
                Logger.getLogger().warn("BackupUnZip task has been finished with an exception", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
            }
        }

        @Override
        public void prepareTask() {
            this.isTaskPrepared = true;
            if (this.cancelled) {
                return;
            }
            this.unZipTask = this.backup.getDirectUnZipTask(false, this.sender);
            this.unZipTask.prepareTask();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            if (this.unZipTask != null) {
                this.unZipTask.cancel();
            }
        }

        @Override
        public long getTaskMaxProgress() {
            if (!this.isTaskPrepared) {
                return 0L;
            }
            return this.unZipTask.getTaskMaxProgress();
        }

        @Override
        public long getTaskCurrentProgress() {
            if (!this.isTaskPrepared) {
                return 0L;
            }
            return this.unZipTask.getTaskCurrentProgress();
        }
    }
}

