/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.common;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import ru.dvdishka.backuper.backend.utils.Utils;

public class Scheduler {
    public static Scheduler getScheduler() {
        return new Scheduler();
    }

    public ScheduledTask runSync(Plugin plugin, Runnable task) {
        if (Utils.isFolia) {
            return Bukkit.getGlobalRegionScheduler().run(plugin, scheduledTask -> task.run());
        }
        Bukkit.getScheduler().runTask(plugin, task);
        return null;
    }

    public ScheduledTask runSyncDelayed(Plugin plugin, Runnable task, long delayTicks) {
        if (Utils.isFolia) {
            return Bukkit.getGlobalRegionScheduler().runDelayed(plugin, scheduledTask -> task.run(), delayTicks);
        }
        Bukkit.getScheduler().runTaskLater(plugin, task, delayTicks);
        return null;
    }

    public ScheduledTask runSyncRepeatingTask(Plugin plugin, Runnable task, long delayTicks, long periodTicks) {
        if (Utils.isFolia) {
            return Bukkit.getGlobalRegionScheduler().runAtFixedRate(plugin, scheduledTask -> task.run(), delayTicks, periodTicks);
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask(plugin, task, delayTicks, periodTicks);
        return null;
    }

    public ScheduledTask runAsync(Plugin plugin, Runnable task) {
        if (Utils.isFolia) {
            return Bukkit.getAsyncScheduler().runNow(plugin, scheduledTask -> task.run());
        }
        Bukkit.getScheduler().runTaskAsynchronously(plugin, task);
        return null;
    }

    public ScheduledTask runAsyncDelayed(Plugin plugin, Runnable task, long delayTicks) {
        if (Utils.isFolia) {
            return Bukkit.getAsyncScheduler().runDelayed(plugin, scheduledTask -> task.run(), delayTicks * 20L, TimeUnit.SECONDS);
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, task, delayTicks);
        return null;
    }

    public static void cancelTasks(Plugin plugin) {
        if (Utils.isFolia) {
            Bukkit.getAsyncScheduler().cancelTasks(plugin);
            Bukkit.getGlobalRegionScheduler().cancelTasks(plugin);
        } else {
            Bukkit.getScheduler().cancelTasks(plugin);
        }
    }
}

