/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.config;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;

public class BackwardsCompatibility {
    public static void configBelow4(FileConfiguration config) {
        double configVersion = config.getDouble("configVersion");
        if (configVersion >= 4.0) {
            return;
        }
        int backupPeriod = config.getInt("backupPeriod", 1440);
        config.set("backupPeriod", (Object)(backupPeriod *= 60));
        boolean fixedBackupTime = config.getBoolean("fixedBackupTime", false);
        if (!fixedBackupTime) {
            config.set("backupTime", (Object)-1);
        } else {
            config.set("backupTime", (Object)config.getInt("firstBackupTime"));
        }
    }

    public static void configBelow8(FileConfiguration config) {
        double configVersion = config.getDouble("configVersion");
        if (configVersion >= 8.0) {
            return;
        }
        String localBackupsFolder = config.getString("backupsFolder", "plugins/Backuper/Backups");
        int localMaxBackupsNumber = config.getInt("maxBackupsNumber", 0);
        long localMaxBackupsWeight = config.getLong("maxBackupsWeight", 0L);
        boolean localZipArchive = config.getBoolean("zipArchive", true);
        boolean autoBackup = config.getBoolean("autoBackup", true);
        List addDirectoryToBackup = config.getStringList("addDirectoryToBackup");
        List excludeDirectoryFromBackup = config.getStringList("excludeDirectoryFromBackup");
        int backupPeriod = config.getInt("backupPeriod", 1440);
        int backupTime = config.getInt("backupTime", -1);
        boolean skipDuplicateBackup = config.getBoolean("skipDuplicateBackup", true);
        String afterBackup = config.getString("afterBackup", "NOTHING");
        boolean setWorldsReadOnly = config.getBoolean("setWorldsReadOnly", false);
        long alertTimeBeforeRestart = config.getLong("alertTimeBeforeRestart", 60L);
        boolean alertOnlyServerRestart = config.getBoolean("alertOnlyServerRestart", true);
        boolean betterLogging = config.getBoolean("betterLogging", false);
        config.set("local.backupsFolder", (Object)localBackupsFolder);
        config.set("local.maxBackupsNumber", (Object)localMaxBackupsNumber);
        config.set("local.maxBackupsWeight", (Object)localMaxBackupsWeight);
        config.set("local.zipArchive", (Object)localZipArchive);
        config.set("backup.autoBackup", (Object)autoBackup);
        config.set("backup.addDirectoryToBackup", (Object)addDirectoryToBackup);
        config.set("backup.excludeDirectoryFromBackup", (Object)excludeDirectoryFromBackup);
        config.set("backup.backupPeriod", (Object)backupPeriod);
        config.set("backup.backupTime", (Object)backupTime);
        config.set("backup.skipDuplicateBackup", (Object)skipDuplicateBackup);
        config.set("backup.afterBackup", (Object)afterBackup);
        config.set("backup.setWorldsReadOnly", (Object)setWorldsReadOnly);
        config.set("server.alertTimeBeforeRestart", (Object)alertTimeBeforeRestart);
        config.set("server.alertOnlyServerRestart", (Object)alertOnlyServerRestart);
        config.set("server.betterLogging", (Object)betterLogging);
    }

    public static void unifyBackupNameFormat(CommandSender sender) {
        try {
            DateTimeFormatter oldUnixDateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
            DateTimeFormatter oldWindowsDateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH;mm;ss");
            File backupsDir = new File(Config.getInstance().getLocalConfig().getBackupsFolder());
            if (!backupsDir.exists() || backupsDir.listFiles() == null) {
                Logger.getLogger().warn("Wrong local.backupFolder config field value", sender);
                throw new RuntimeException();
            }
            for (File file : Objects.requireNonNull(backupsDir.listFiles())) {
                File newFile;
                LocalDateTime backupLocalDateTime = null;
                try {
                    backupLocalDateTime = LocalDateTime.parse(file.getName().replace(".zip", ""), oldUnixDateTimeFormatter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    backupLocalDateTime = LocalDateTime.parse(file.getName().replace(".zip", ""), oldWindowsDateTimeFormatter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (backupLocalDateTime == null) continue;
                boolean isZip = file.getName().endsWith(".zip");
                Object newFileName = Config.getInstance().getDateTimeFormatter().format(backupLocalDateTime);
                if (isZip) {
                    newFileName = (String)newFileName + ".zip";
                }
                if (file.renameTo(newFile = new File(backupsDir, (String)newFileName))) continue;
                Logger.getLogger().warn("Failed to reformat backup to new unified format " + newFile.getAbsolutePath() + " (it will be unavailable)", sender);
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to unify backup name format", sender);
            Logger.getLogger().warn("BackwardsCompatibility:UnifyBackupNameFormat", e);
        }
    }
}

