/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.config;

import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.BackwardsCompatibility;
import ru.dvdishka.backuper.backend.config.FtpConfig;
import ru.dvdishka.backuper.backend.config.GoogleDriveConfig;
import ru.dvdishka.backuper.backend.config.LocalConfig;
import ru.dvdishka.backuper.backend.config.SftpConfig;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.shade.commandapi.CommandAPI;

public class Config {
    private File configFile;
    private final String configVersion = "10.0";
    private long lastBackup;
    private long lastChange;
    private List<String> addDirectoryToBackup;
    private List<String> excludeDirectoryFromBackup;
    private boolean fixedBackupTime;
    private boolean autoBackup;
    private int backupTime;
    private int backupPeriod;
    private String afterBackup;
    private boolean skipDuplicateBackup;
    private long alertTimeBeforeRestart;
    private boolean betterLogging;
    private boolean setWorldsReadOnly;
    private boolean alertOnlyServerRestart;
    private boolean checkUpdates;
    private boolean deleteBrokenBackups;
    private String backupFileNameFormat;
    private DateTimeFormatter dateTimeFormatter;
    private File sizeCacheFile;
    private String alertBackupMessage;
    private String alertBackupRestartMessage;
    private final LocalConfig localConfig = new LocalConfig();
    private final SftpConfig sftpConfig = new SftpConfig();
    private final FtpConfig ftpConfig = new FtpConfig();
    private final GoogleDriveConfig googleDriveConfig = new GoogleDriveConfig();
    private static Config instance = null;

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    private Config() {
    }

    public synchronized void setConfigField(String path, Object value) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        config.set(path, value);
        try {
            config.save(this.configFile);
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to save config");
        }
    }

    public void updateLastChange() {
        this.lastChange = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
    }

    public void updateLastBackup() {
        this.lastBackup = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
    }

    public void load(File configFile, CommandSender sender) {
        Logger.getLogger().devLog("loading config...", sender);
        this.configFile = configFile;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        boolean noErrors = true;
        String configVersion = config.getString("configVersion");
        BackwardsCompatibility.configBelow4((FileConfiguration)config);
        BackwardsCompatibility.configBelow8((FileConfiguration)config);
        boolean isConfigFileOk = true;
        this.backupTime = config.getInt("backup.backupTime", -1);
        this.backupFileNameFormat = config.getString("backup.backupFileNameFormat", "dd-MM-yyyy HH-mm-ss");
        this.backupPeriod = config.getInt("backup.backupPeriod", 1440);
        this.afterBackup = config.getString("backup.afterBackup", "NOTHING").toUpperCase();
        this.setWorldsReadOnly = config.getBoolean("backup.setWorldsReadOnly", false);
        this.autoBackup = config.getBoolean("backup.autoBackup", true);
        this.skipDuplicateBackup = config.getBoolean("backup.skipDuplicateBackup", true);
        this.deleteBrokenBackups = config.getBoolean("backup.deleteBrokenBackups", true);
        this.localConfig.enabled = config.getBoolean("local.enabled", true);
        this.localConfig.autoBackup = config.getBoolean("local.autoBackup", true);
        this.localConfig.backupsNumber = config.getInt("local.maxBackupsNumber", 0);
        this.localConfig.backupsWeight = config.getLong("local.maxBackupsWeight", 0L) * 0x100000L;
        this.localConfig.zipArchive = config.getBoolean("local.zipArchive", true);
        this.localConfig.backupsFolder = config.getString("local.backupsFolder", "plugins/Backuper/Backups");
        this.localConfig.zipCompressionLevel = config.getInt("local.zipCompressionLevel", 5);
        this.ftpConfig.enabled = config.getBoolean("ftp.enabled", false);
        this.ftpConfig.autoBackup = config.getBoolean("ftp.autoBackup", true);
        this.ftpConfig.backupsFolder = config.getString("ftp.backupsFolder", "");
        this.ftpConfig.pathSeparatorSymbol = config.getString("ftp.pathSeparatorSymbol", "/");
        this.ftpConfig.backupsNumber = config.getInt("ftp.maxBackupsNumber", 0);
        this.ftpConfig.backupsWeight = config.getLong("ftp.maxBackupsWeight", 0L) * 0x100000L;
        this.ftpConfig.zipArchive = config.getBoolean("ftp.zipArchive", true);
        this.ftpConfig.zipCompressionLevel = config.getInt("ftp.zipCompressionLevel", 5);
        this.ftpConfig.address = config.getString("ftp.auth.address", "");
        this.ftpConfig.port = config.getInt("ftp.auth.port", 21);
        this.ftpConfig.username = config.getString("ftp.auth.username", "");
        this.ftpConfig.password = config.getString("ftp.auth.password", "");
        this.sftpConfig.enabled = config.getBoolean("sftp.enabled", false);
        this.sftpConfig.autoBackup = config.getBoolean("sftp.autoBackup", true);
        this.sftpConfig.backupsFolder = config.getString("sftp.backupsFolder", "");
        this.sftpConfig.pathSeparatorSymbol = config.getString("sftp.pathSeparatorSymbol", "/");
        this.sftpConfig.backupsNumber = config.getInt("sftp.maxBackupsNumber", 0);
        this.sftpConfig.backupsWeight = config.getLong("sftp.maxBackupsWeight", 0L) * 0x100000L;
        this.sftpConfig.keyFilePath = config.getString("sftp.auth.keyFilePath", "");
        this.sftpConfig.authType = config.getString("sftp.auth.authType", "password");
        this.sftpConfig.username = config.getString("sftp.auth.username", "");
        this.sftpConfig.password = config.getString("sftp.auth.password", "");
        this.sftpConfig.address = config.getString("sftp.auth.address", "");
        this.sftpConfig.port = config.getInt("sftp.auth.port", 22);
        this.sftpConfig.useKnownHostsFile = config.getString("sftp.auth.useKnownHostsFile", "false");
        this.sftpConfig.knownHostsFilePath = config.getString("sftp.auth.knownHostsFilePath", "");
        this.googleDriveConfig.enabled = config.getBoolean("googleDrive.enabled", false);
        this.googleDriveConfig.autoBackup = config.getBoolean("googleDrive.autoBackup", true);
        this.googleDriveConfig.backupsFolderId = config.getString("googleDrive.backupsFolderId", "");
        String googleDriveTokenFolder = config.getString("googleDrive.auth.tokenFolderPath", "plugins/Backuper/GoogleDrive/tokens");
        this.googleDriveConfig.tokenFolder = new File(googleDriveTokenFolder);
        this.googleDriveConfig.createBackuperFolder = config.getBoolean("googleDrive.createBackuperFolder", true);
        this.googleDriveConfig.backupsNumber = config.getInt("googleDrive.maxBackupsNumber", 0);
        this.googleDriveConfig.backupsWeight = config.getLong("googleDrive.maxBackupsWeight", 0L) * 0x100000L;
        this.alertBackupMessage = config.getString("server.alertBackupMessage", "Server will be backed up in %d second(s)");
        this.alertBackupRestartMessage = config.getString("server.alertBackupRestartMessage", "Server will be backed up and restarted in %d second(s)");
        this.sizeCacheFile = new File(config.getString("server.sizeCacheFile", "./plugins/Backuper/sizeCache.json"));
        this.betterLogging = config.getBoolean("server.betterLogging", false);
        this.fixedBackupTime = this.backupTime > -1;
        this.addDirectoryToBackup = config.getStringList("backup.addDirectoryToBackup");
        this.excludeDirectoryFromBackup = config.getStringList("backup.excludeDirectoryFromBackup");
        this.alertTimeBeforeRestart = config.getLong("server.alertTimeBeforeRestart", 60L);
        this.alertOnlyServerRestart = config.getBoolean("server.alertOnlyServerRestart", true);
        this.checkUpdates = config.getBoolean("server.checkUpdates", true);
        this.lastBackup = config.getLong("lastBackup", 0L);
        this.lastChange = config.getLong("lastChange", 0L);
        try {
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.backupFileNameFormat);
            LocalDateTime localDateTime = LocalDateTime.parse(LocalDateTime.now().format(this.dateTimeFormatter), this.dateTimeFormatter);
        }
        catch (Exception e) {
            Logger.getLogger().warn("Wrong backupFileNameFormat format: \"" + this.backupFileNameFormat + "\", using default \"dd-MM-yyyy HH-mm-ss\" value...");
            Logger.getLogger().warn(this.getClass(), e);
            isConfigFileOk = false;
            this.backupFileNameFormat = "dd-MM-yyyy HH-mm-ss";
        }
        if (this.backupTime < -1) {
            Logger.getLogger().warn("Failed to load config value!");
            Logger.getLogger().warn("backupTime must be >= -1, using default -1 value...");
            this.backupTime = -1;
        }
        if (this.alertTimeBeforeRestart >= (long)this.backupPeriod * 60L && this.backupPeriod != -1) {
            Logger.getLogger().warn("Failed to load config value!");
            Logger.getLogger().warn("alertTimeBeforeRestart must be < backupPeriod * 60, using backupPeriod * 60 - 1 value...");
            this.alertTimeBeforeRestart = (long)this.backupPeriod * 60L - 1L;
        }
        if (this.backupPeriod <= 0 && this.backupPeriod != -1) {
            Logger.getLogger().warn("Failed to load config value!");
            Logger.getLogger().warn("backup.backupPeriod must be > 0, using default 1440 value...");
            this.backupPeriod = 1440;
        }
        if (this.localConfig.backupsNumber < 0) {
            Logger.getLogger().warn("Failed to load config value!");
            Logger.getLogger().warn("local.maxBackupsNumber must be >= 0, using default 0 value...");
            this.localConfig.backupsNumber = 0;
        }
        if (this.localConfig.backupsWeight < 0L) {
            Logger.getLogger().warn("Failed to load config value!");
            Logger.getLogger().warn("local.maxBackupsWeight must be >= 0, using default 0 value...");
            this.localConfig.backupsWeight = 0L;
        }
        if (this.sftpConfig.backupsNumber < 0) {
            Logger.getLogger().warn("Failed to load config value!");
            Logger.getLogger().warn("sftp.maxBackupsNumber must be >= 0, using default 0 value...");
            this.sftpConfig.backupsNumber = 0;
        }
        if (this.sftpConfig.backupsWeight < 0L) {
            Logger.getLogger().warn("Failed to load config value!");
            Logger.getLogger().warn("sftp.maxBackupsWeight must be >= 0, using default 0 value...");
            this.sftpConfig.backupsWeight = 0L;
        }
        if (this.localConfig.zipCompressionLevel > 9 || this.localConfig.zipCompressionLevel < 0) {
            Logger.getLogger().warn("Failed to load config value!");
            if (this.localConfig.zipCompressionLevel < 0) {
                Logger.getLogger().warn("local.zipCompressionLevel must be >= 0, using 0 value...");
                this.localConfig.zipCompressionLevel = 0;
            }
            if (this.localConfig.zipCompressionLevel > 9) {
                Logger.getLogger().warn("local.zipCompressionLevel must be <= 9, using 9 value...");
                this.localConfig.zipCompressionLevel = 9;
            }
        }
        if (this.ftpConfig.zipCompressionLevel > 9 || this.ftpConfig.zipCompressionLevel < 0) {
            Logger.getLogger().warn("Failed to load config value!");
            if (this.ftpConfig.zipCompressionLevel < 0) {
                Logger.getLogger().warn("ftp.zipCompressionLevel must be >= 0, using 0 value...");
                this.ftpConfig.zipCompressionLevel = 0;
            }
            if (this.ftpConfig.zipCompressionLevel > 9) {
                Logger.getLogger().warn("ftp.zipCompressionLevel must be <= 9, using 9 value...");
                this.ftpConfig.zipCompressionLevel = 9;
            }
        }
        isConfigFileOk = isConfigFileOk && Objects.equals(configVersion, this.configVersion);
        List<String> configFields = List.of("backup.backupTime", "backup.backupPeriod", "backup.afterBackup", "local.maxBackupsNumber", "local.maxBackupsWeight", "local.zipArchive", "server.betterLogging", "backup.autoBackup", "lastBackup", "lastChange", "backup.skipDuplicateBackup", "local.backupsFolder", "server.alertTimeBeforeRestart", "backup.addDirectoryToBackup", "backup.excludeDirectoryFromBackup", "backup.setWorldsReadOnly", "server.alertOnlyServerRestart", "sftp.enabled", "sftp.backupsFolder", "sftp.auth.authType", "sftp.auth.username", "sftp.auth.password", "sftp.auth.keyFilePath", "sftp.auth.address", "sftp.auth.port", "sftp.auth.useKnownHostsFile", "sftp.auth.knownHostsFilePath", "local.enabled", "sftp.pathSeparatorSymbol", "local.zipCompressionLevel", "sftp.maxBackupsNumber", "sftp.maxBackupsWeight", "ftp.backupsFolder", "ftp.auth.address", "ftp.auth.port", "ftp.pathSeparatorSymbol", "ftp.auth.password", "ftp.auth.username", "ftp.enabled", "ftp.maxBackupsNumber", "ftp.maxBackupsWeight", "ftp.zipArchive", "ftp.zipCompressionLevel", "server.checkUpdates", "local.autoBackup", "ftp.autoBackup", "sftp.autoBackup", "backup.deleteBrokenBackups", "backup.backupFileNameFormat", "googleDrive.enabled", "googleDrive.autoBackup", "googleDrive.auth.tokenFolderPath", "googleDrive.backupsFolderId", "googleDrive.createBackuperFolder", "googleDrive.maxBackupsWeight", "googleDrive.maxBackupsNumber", "server.sizeCacheFile", "server.alertBackupMessage", "server.alertBackupRestartMessage");
        for (String configField : configFields) {
            if (!isConfigFileOk || config.contains(configField)) continue;
            isConfigFileOk = false;
        }
        if (!isConfigFileOk) {
            Logger.getLogger().warn("The config.yml file is damaged, repair...");
            Logger.getLogger().warn("If the plugin has just been updated, ignore this warning");
            if (!configFile.delete()) {
                Logger.getLogger().warn("Can not delete old config file!", sender);
                noErrors = false;
            }
            Utils.plugin.saveDefaultConfig();
            YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)configFile);
            newConfig.set("backup.backupTime", (Object)this.backupTime);
            newConfig.set("backup.backupFileNameFormat", (Object)this.backupFileNameFormat);
            newConfig.set("backup.backupPeriod", (Object)this.backupPeriod);
            newConfig.set("backup.afterBackup", (Object)this.afterBackup);
            newConfig.set("backup.autoBackup", (Object)this.autoBackup);
            newConfig.set("backup.skipDuplicateBackup", (Object)this.skipDuplicateBackup);
            newConfig.set("backup.addDirectoryToBackup", this.addDirectoryToBackup);
            newConfig.set("backup.excludeDirectoryFromBackup", this.excludeDirectoryFromBackup);
            newConfig.set("backup.setWorldsReadOnly", (Object)this.setWorldsReadOnly);
            newConfig.set("backup.deleteBrokenBackups", (Object)this.deleteBrokenBackups);
            newConfig.set("local.enabled", (Object)this.localConfig.enabled);
            newConfig.set("local.autoBackup", (Object)this.localConfig.autoBackup);
            newConfig.set("local.maxBackupsNumber", (Object)this.localConfig.backupsNumber);
            newConfig.set("local.maxBackupsWeight", (Object)(this.localConfig.backupsWeight / 0x100000L));
            newConfig.set("local.zipArchive", (Object)this.localConfig.zipArchive);
            newConfig.set("local.backupsFolder", (Object)this.localConfig.backupsFolder);
            newConfig.set("local.zipCompressionLevel", (Object)this.localConfig.zipCompressionLevel);
            newConfig.set("ftp.enabled", (Object)this.ftpConfig.enabled);
            newConfig.set("ftp.autoBackup", (Object)this.ftpConfig.autoBackup);
            newConfig.set("ftp.backupsFolder", (Object)this.ftpConfig.backupsFolder);
            newConfig.set("ftp.pathSeparatorSymbol", (Object)this.ftpConfig.pathSeparatorSymbol);
            newConfig.set("ftp.maxBackupsNumber", (Object)this.ftpConfig.backupsNumber);
            newConfig.set("ftp.maxBackupsWeight", (Object)(this.ftpConfig.backupsWeight / 0x100000L));
            newConfig.set("ftp.zipArchive", (Object)true);
            newConfig.set("ftp.zipCompressionLevel", (Object)5);
            newConfig.set("ftp.auth.address", (Object)this.ftpConfig.address);
            newConfig.set("ftp.auth.port", (Object)this.ftpConfig.port);
            newConfig.set("ftp.auth.username", (Object)this.ftpConfig.username);
            newConfig.set("ftp.auth.password", (Object)this.ftpConfig.password);
            newConfig.set("sftp.pathSeparatorSymbol", (Object)this.sftpConfig.pathSeparatorSymbol);
            newConfig.set("sftp.maxBackupsNumber", (Object)this.sftpConfig.backupsNumber);
            newConfig.set("sftp.maxBackupsWeight", (Object)(this.sftpConfig.backupsWeight / 0x100000L));
            newConfig.set("sftp.enabled", (Object)this.sftpConfig.enabled);
            newConfig.set("sftp.autoBackup", (Object)this.sftpConfig.autoBackup);
            newConfig.set("sftp.backupsFolder", (Object)this.sftpConfig.backupsFolder);
            newConfig.set("sftp.auth.password", (Object)this.sftpConfig.password);
            newConfig.set("sftp.auth.username", (Object)this.sftpConfig.username);
            newConfig.set("sftp.auth.authType", (Object)this.sftpConfig.authType);
            newConfig.set("sftp.auth.keyFilePath", (Object)this.sftpConfig.keyFilePath);
            newConfig.set("sftp.auth.address", (Object)this.sftpConfig.address);
            newConfig.set("sftp.auth.port", (Object)this.sftpConfig.port);
            newConfig.set("sftp.auth.useKnownHostsFile", (Object)this.sftpConfig.useKnownHostsFile);
            newConfig.set("sftp.auth.knownHostsFilePath", (Object)this.sftpConfig.knownHostsFilePath);
            newConfig.set("googleDrive.enabled", (Object)this.googleDriveConfig.enabled);
            newConfig.set("googleDrive.autoBackup", (Object)this.googleDriveConfig.autoBackup);
            newConfig.set("googleDrive.backupsFolderId", (Object)this.googleDriveConfig.backupsFolderId);
            newConfig.set("googleDrive.auth.tokenFolderPath", (Object)googleDriveTokenFolder);
            newConfig.set("googleDrive.createBackuperFolder", (Object)this.googleDriveConfig.createBackuperFolder);
            newConfig.set("googleDrive.maxBackupsWeight", (Object)(this.googleDriveConfig.backupsWeight / 0x100000L));
            newConfig.set("googleDrive.maxBackupsNumber", (Object)this.googleDriveConfig.backupsNumber);
            newConfig.set("lastBackup", (Object)this.lastBackup);
            newConfig.set("lastChange", (Object)this.lastChange);
            newConfig.set("server.sizeCacheFile", (Object)this.sizeCacheFile.getPath());
            newConfig.set("server.betterLogging", (Object)this.betterLogging);
            newConfig.set("server.alertTimeBeforeRestart", (Object)this.alertTimeBeforeRestart);
            newConfig.set("server.alertOnlyServerRestart", (Object)this.alertOnlyServerRestart);
            newConfig.set("server.alertBackupMessage", (Object)this.alertBackupMessage);
            newConfig.set("server.alertBackupRestartMessage", (Object)this.alertBackupRestartMessage);
            newConfig.set("server.checkUpdates", (Object)this.checkUpdates);
            try {
                newConfig.save(configFile);
            }
            catch (Exception e) {
                Logger.getLogger().warn("Can not save config file!", sender);
                Logger.getLogger().warn("Initialization", e);
                noErrors = false;
            }
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            CommandAPI.updateRequirements(player);
        }
        if (noErrors) {
            Logger.getLogger().devLog("Config has been loaded successfully!", sender);
        }
        if (!noErrors) {
            Logger.getLogger().warn("Config has been loaded with errors!", sender);
        }
    }

    public boolean isAutoBackup() {
        return this.autoBackup;
    }

    public boolean isBetterLogging() {
        return this.betterLogging;
    }

    public boolean isFixedBackupTime() {
        return this.fixedBackupTime;
    }

    public boolean isSkipDuplicateBackup() {
        return this.skipDuplicateBackup;
    }

    public int getBackupPeriod() {
        return this.backupPeriod;
    }

    public int getBackupTime() {
        return this.backupTime;
    }

    public long getLastBackup() {
        return this.lastBackup;
    }

    public long getLastChange() {
        return this.lastChange;
    }

    public String getAfterBackup() {
        return this.afterBackup;
    }

    public List<String> getAddDirectoryToBackup() {
        return this.addDirectoryToBackup;
    }

    public List<String> getExcludeDirectoryFromBackup() {
        return this.excludeDirectoryFromBackup;
    }

    public String getConfigVersion() {
        return "10.0";
    }

    public long getAlertTimeBeforeRestart() {
        return this.alertTimeBeforeRestart;
    }

    public FileConfiguration getFileConfiguration() {
        return YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public boolean isSetWorldsReadOnly() {
        return this.setWorldsReadOnly;
    }

    public boolean isAlertOnlyServerRestart() {
        return this.alertOnlyServerRestart;
    }

    public boolean isCheckUpdates() {
        return this.checkUpdates;
    }

    public LocalConfig getLocalConfig() {
        return this.localConfig;
    }

    public FtpConfig getFtpConfig() {
        return this.ftpConfig;
    }

    public SftpConfig getSftpConfig() {
        return this.sftpConfig;
    }

    public GoogleDriveConfig getGoogleDriveConfig() {
        return this.googleDriveConfig;
    }

    public boolean isDeleteBrokenBackups() {
        return this.deleteBrokenBackups;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public File getSizeCacheFile() {
        return this.sizeCacheFile;
    }

    public String getAlertBackupMessage() {
        return this.alertBackupMessage;
    }

    public String getAlertBackupRestartMessage() {
        return this.alertBackupRestartMessage;
    }
}

