/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks;

import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public abstract class Task {
    protected CommandSender sender;
    protected String taskName;
    protected List<Permissions> permissions;
    protected long currentProgress = 0L;
    protected long maxProgress = 0L;
    protected boolean setLocked = false;
    protected boolean isTaskPrepared = false;
    protected boolean cancelled = false;

    protected Task(String taskName, boolean setLocked, List<Permissions> permissions, CommandSender sender) {
        this.sender = sender;
        this.setLocked = setLocked;
        this.taskName = taskName;
        this.permissions = permissions;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public long getTaskPercentProgress() {
        if (this.getTaskMaxProgress() == 0L) {
            return 0L;
        }
        return (long)Math.min((double)this.getTaskCurrentProgress() / (double)this.getTaskMaxProgress() * 100.0, 100.0);
    }

    public long getTaskCurrentProgress() {
        return this.currentProgress;
    }

    public long getTaskMaxProgress() {
        return this.maxProgress;
    }

    public boolean getSetLocked() {
        return this.setLocked;
    }

    public List<Permissions> getPermissions() {
        return this.permissions;
    }

    protected synchronized void incrementCurrentProgress(long progress) {
        this.currentProgress += progress;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public abstract void run();

    public abstract void prepareTask();

    public abstract void cancel();
}

