/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.common;

import java.io.File;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.backup.StorageType;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.common.Scheduler;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.common.DeleteBrokenBackupsTask;
import ru.dvdishka.backuper.backend.tasks.common.DeleteOldBackupsTask;
import ru.dvdishka.backuper.backend.tasks.common.SetWorldsReadOnlyTask;
import ru.dvdishka.backuper.backend.tasks.common.SetWorldsWritableTask;
import ru.dvdishka.backuper.backend.tasks.ftp.FtpAddLocalDirsToZipTask;
import ru.dvdishka.backuper.backend.tasks.ftp.FtpSendFileFolderTask;
import ru.dvdishka.backuper.backend.tasks.googleDrive.GoogleDriveSendFileFolderTask;
import ru.dvdishka.backuper.backend.tasks.local.folder.CopyFilesToFolderTask;
import ru.dvdishka.backuper.backend.tasks.local.zip.tozip.AddDirToZipTask;
import ru.dvdishka.backuper.backend.tasks.sftp.SftpSendFileFolderTask;
import ru.dvdishka.backuper.backend.utils.FtpUtils;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.backend.utils.SftpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class BackupTask
extends Task {
    private static final String taskName = "Backup";
    private final boolean isAutoBackup;
    private final String afterBackup;
    private final boolean isLocal;
    private boolean isFtp;
    private boolean isSftp;
    private boolean isGoogleDrive;
    private final long deleteProgressMultiplier = 3L;
    private final long copyProgressMultiplier = 5L;
    private final long zipProgressMultiplier = 10L;
    private final long sendSftpProgressMultiplier = 15L;
    private final long sendFtpProgressMultiplier = 15L;
    private final long sendGoogleDriveProgressMultiplier = 40L;
    private final long zipFtpProgressMultiplier = 20L;
    private String backupName;
    private List<Task> tasks = new ArrayList<Task>();

    public BackupTask(String afterBackup, boolean isAutoBackup, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.afterBackup = afterBackup.toUpperCase();
        this.isAutoBackup = isAutoBackup;
        this.isLocal = Config.getInstance().getLocalConfig().isAutoBackup() && Config.getInstance().getLocalConfig().isEnabled();
        this.isFtp = Config.getInstance().getFtpConfig().isAutoBackup() && Config.getInstance().getFtpConfig().isEnabled();
        this.isSftp = Config.getInstance().getSftpConfig().isAutoBackup() && Config.getInstance().getSftpConfig().isEnabled();
        this.isGoogleDrive = Config.getInstance().getGoogleDriveConfig().isAutoBackup() && Config.getInstance().getGoogleDriveConfig().isEnabled();
    }

    public BackupTask(String afterBackup, boolean isAutoBackup, boolean isLocal, boolean isFtp, boolean isSftp, boolean isGoogleDrive, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.afterBackup = afterBackup.toUpperCase();
        this.isAutoBackup = isAutoBackup;
        this.isLocal = isLocal;
        this.isFtp = isFtp;
        this.isSftp = isSftp;
        this.isGoogleDrive = isGoogleDrive;
    }

    @Override
    public void run() {
        block41: {
            if (this.setLocked) {
                Backuper.lock(this);
            }
            try {
                if (Config.getInstance().isSkipDuplicateBackup() && this.isAutoBackup && Config.getInstance().getLastBackup() >= Config.getInstance().getLastChange()) {
                    Logger.getLogger().log("The backup cycle will be skipped since there were no changes from the previous backup", this.sender);
                    Config.getInstance().updateLastBackup();
                    if (this.afterBackup.equals("RESTART")) {
                        Scheduler.getScheduler().runSyncDelayed(Utils.plugin, () -> {
                            Scheduler.cancelTasks(Utils.plugin);
                            Bukkit.getServer().spigot().restart();
                        }, 20L);
                    } else if (this.afterBackup.equals("STOP")) {
                        Logger.getLogger().devLog("Stopping server...");
                        Bukkit.shutdown();
                    }
                    if (this.setLocked) {
                        UIUtils.successSound(this.sender);
                        Backuper.unlock();
                    }
                    return;
                }
                if (!this.cancelled && !this.isTaskPrepared) {
                    this.prepareTask();
                }
                if (this.isAutoBackup) {
                    Logger.getLogger().log("Auto backup task has been started", this.sender);
                }
                if (!this.cancelled && this.isFtp && !FtpUtils.checkConnection(this.sender)) {
                    Logger.getLogger().warn("Failed to connect to FTP(S) server during the backup task. Skipping this storage...", this.sender);
                    this.isFtp = false;
                }
                if (!this.cancelled && this.isSftp && !SftpUtils.checkConnection(this.sender)) {
                    Logger.getLogger().warn("Failed to connect to SFTP server during the backup task. Skipping this storage...", this.sender);
                    this.isSftp = false;
                }
                if (!this.cancelled && this.isGoogleDrive && !GoogleDriveUtils.isAuthorized(this.sender)) {
                    Logger.getLogger().warn("Failed to connect to Google Drive or Google account is not linked!", this.sender);
                    this.isGoogleDrive = false;
                }
                Logger.getLogger().devLog("Backup task has been started");
                long localBackupByteSize = 0L;
                long ftpBackupByteSize = 0L;
                long sftpBackupByteSize = 0L;
                long googleDriveBackupByteSize = 0L;
                ArrayList<CompletableFuture<Void>> taskFutures = new ArrayList<CompletableFuture<Void>>();
                if (!this.cancelled) {
                    new SetWorldsReadOnlyTask(false, this.permissions, this.sender).run();
                }
                for (Task task : this.tasks) {
                    if ((task instanceof FtpAddLocalDirsToZipTask || task instanceof FtpSendFileFolderTask) && !this.isFtp || task instanceof SftpSendFileFolderTask && !this.isSftp || task instanceof GoogleDriveSendFileFolderTask && !this.isGoogleDrive || (task instanceof CopyFilesToFolderTask || task instanceof AddDirToZipTask) && !this.isLocal) continue;
                    if (!this.cancelled) {
                        taskFutures.add(CompletableFuture.runAsync(task::run));
                    }
                    if (!this.cancelled && task instanceof CopyFilesToFolderTask) {
                        localBackupByteSize += task.getTaskMaxProgress();
                    }
                    if (!this.cancelled && task instanceof FtpSendFileFolderTask) {
                        ftpBackupByteSize += task.getTaskMaxProgress();
                    }
                    if (!this.cancelled && task instanceof SftpSendFileFolderTask) {
                        sftpBackupByteSize += task.getTaskMaxProgress();
                    }
                    if (this.cancelled || !(task instanceof GoogleDriveSendFileFolderTask)) continue;
                    googleDriveBackupByteSize += task.getTaskMaxProgress();
                }
                CompletableFuture.allOf(taskFutures.toArray(new CompletableFuture[0])).join();
                new SetWorldsWritableTask(false, this.permissions, this.sender).run();
                if (!this.cancelled && this.isLocal) {
                    File backupDir = new File(Config.getInstance().getLocalConfig().getBackupsFolder()).toPath().resolve((String)(Config.getInstance().getLocalConfig().isZipArchive() ? this.backupName + ".zip" : this.backupName)).toFile();
                    Logger.getLogger().devLog("The Rename \"in progress\" Folder/ZIP local task has been started");
                    if (Config.getInstance().getLocalConfig().isZipArchive()) {
                        File oldZipFile = new File(Config.getInstance().getLocalConfig().getBackupsFolder()).toPath().resolve(backupDir.getName()).toFile();
                        File newZipFile = new File(Config.getInstance().getLocalConfig().getBackupsFolder()).toPath().resolve(backupDir.getName().replace(" in progress", "")).toFile();
                        for (int attempts = 0; !oldZipFile.renameTo(newZipFile) && attempts < 1000000; ++attempts) {
                            if (attempts != 999999) continue;
                            Logger.getLogger().warn("The Rename \"in progress\" ZIP local task has been finished with an exception!", this.sender);
                        }
                    } else {
                        File oldFolder = new File(Config.getInstance().getLocalConfig().getBackupsFolder()).toPath().resolve(backupDir.getName()).toFile();
                        File newFolder = new File(Config.getInstance().getLocalConfig().getBackupsFolder()).toPath().resolve(backupDir.getName().replace(" in progress", "")).toFile();
                        for (int attempts = 0; !oldFolder.renameTo(newFolder) && attempts < 1000000; ++attempts) {
                            if (attempts != 999999) continue;
                            Logger.getLogger().warn("The Rename \"in progress\" Folder local task has been finished with an exception!", this.sender);
                        }
                        Backup.saveBackupSizeToCache(StorageType.LOCAL, this.backupName.replace(" in progress", ""), localBackupByteSize);
                        Logger.getLogger().devLog("New LOCAL backup size has been cached");
                    }
                    Logger.getLogger().devLog("The Rename \"in progress\" Folder/ZIP local task has been finished");
                }
                if (!this.cancelled && this.isFtp) {
                    Logger.getLogger().devLog("The Rename \"in progress\" Folder FTP(S) task has been started");
                    String fileType = "";
                    if (Config.getInstance().getFtpConfig().isZipArchive()) {
                        fileType = ".zip";
                    }
                    FtpUtils.renameFile(FtpUtils.resolve(Config.getInstance().getFtpConfig().getBackupsFolder(), this.backupName + fileType), FtpUtils.resolve(Config.getInstance().getFtpConfig().getBackupsFolder(), this.backupName.replace(" in progress", "") + fileType), this.sender);
                    if (!Config.getInstance().getFtpConfig().isZipArchive()) {
                        Backup.saveBackupSizeToCache(StorageType.FTP, this.backupName.replace(" in progress", ""), ftpBackupByteSize);
                        Logger.getLogger().devLog("New SFTP backup size has been cached");
                    }
                    Logger.getLogger().devLog("The Rename \"in progress\" Folder FTP(S) task has been finished");
                }
                if (!this.cancelled && this.isSftp) {
                    Logger.getLogger().devLog("The Rename \"in progress\" Folder SFTP task has been started");
                    SftpUtils.renameFile(SftpUtils.resolve(Config.getInstance().getSftpConfig().getBackupsFolder(), this.backupName), SftpUtils.resolve(Config.getInstance().getSftpConfig().getBackupsFolder(), this.backupName.replace(" in progress", "")), this.sender);
                    Backup.saveBackupSizeToCache(StorageType.SFTP, this.backupName.replace(" in progress", ""), sftpBackupByteSize);
                    Logger.getLogger().devLog("New SFTP backup size has been cached");
                    Logger.getLogger().devLog("The Rename \"in progress\" Folder SFTP task has been finished");
                }
                if (!this.cancelled && this.isGoogleDrive) {
                    Logger.getLogger().devLog("The Rename \"in progress\" Folder GoogleDrive task has been started");
                    try {
                        GoogleDriveUtils.renameFile(GoogleDriveUtils.getFileByName(this.backupName, Config.getInstance().getGoogleDriveConfig().getBackupsFolderId(), this.sender).getId(), this.backupName.replace(" in progress", ""), this.sender);
                        Backup.saveBackupSizeToCache(StorageType.GOOGLE_DRIVE, this.backupName.replace(" in progress", ""), googleDriveBackupByteSize);
                        Logger.getLogger().devLog("New GOOGLE_DRIVE backup size has been cached");
                    }
                    catch (Exception e) {
                        Logger.getLogger().warn("Failed to rename Google Drive file " + this.backupName, this.sender);
                        Logger.getLogger().warn(this.getClass(), e);
                    }
                    Logger.getLogger().devLog("The Rename \"in progress\" Folder GoogleDrive task has been finished");
                }
                if (!this.cancelled && this.isAutoBackup) {
                    Logger.getLogger().devLog("Update \"lastBackup\" Variable task has been started");
                    Config.getInstance().updateLastBackup();
                    Logger.getLogger().devLog("Update \"lastBackup\" Variable task has been finished");
                }
                if (!this.cancelled) {
                    DeleteOldBackupsTask deleteOldBackupTask = new DeleteOldBackupsTask(false, this.permissions, this.sender);
                    this.tasks.add(deleteOldBackupTask);
                    ((Task)deleteOldBackupTask).run();
                    if (Config.getInstance().isDeleteBrokenBackups()) {
                        DeleteBrokenBackupsTask deleteBrokeBackupsTask = new DeleteBrokenBackupsTask(false, this.permissions, this.sender);
                        this.tasks.add(deleteBrokeBackupsTask);
                        ((Task)deleteBrokeBackupsTask).run();
                    }
                }
                if (this.setLocked) {
                    if (this.isAutoBackup) {
                        Logger.getLogger().log("Auto backup task completed", this.sender);
                    }
                    UIUtils.successSound(this.sender);
                    Backuper.unlock();
                }
                if (!this.cancelled) {
                    if (this.afterBackup.equals("RESTART")) {
                        Scheduler.getScheduler().runSyncDelayed(Utils.plugin, () -> {
                            Scheduler.cancelTasks(Utils.plugin);
                            Bukkit.getServer().spigot().restart();
                        }, 20L);
                    } else if (this.afterBackup.equals("STOP")) {
                        Logger.getLogger().log("Stopping server...", this.sender);
                        Bukkit.shutdown();
                    }
                }
                Logger.getLogger().devLog("Backup task has been finished");
            }
            catch (Exception e) {
                Logger.getLogger().warn("Something went wrong while running the task: Backup");
                Logger.getLogger().warn(e.getMessage());
                if (this.isAutoBackup) {
                    Logger.getLogger().log("Auto backup task has been finished with an exception", this.sender);
                }
                if (!this.setLocked) break block41;
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
        }
    }

    @Override
    public void prepareTask() {
        try {
            this.isTaskPrepared = true;
            this.backupName = LocalDateTime.now().format(Config.getInstance().getDateTimeFormatter()) + " in progress";
            if (!this.cancelled && this.isLocal) {
                this.prepareLocalTask();
            }
            if (!this.cancelled && this.isFtp) {
                this.prepareFtpTask();
            }
            if (!this.cancelled && this.isSftp) {
                this.prepareSftpTask();
            }
            if (!this.cancelled && this.isGoogleDrive) {
                this.prepareGoogleDriveTask();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
            }
            new SetWorldsWritableTask(false, this.permissions, this.sender).run();
            Logger.getLogger().warn("The Backup task has been finished with an exception!", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    private void prepareLocalTask() {
        try {
            if (this.cancelled) {
                return;
            }
            File backupDir = new File(Config.getInstance().getLocalConfig().getBackupsFolder()).toPath().resolve((String)(Config.getInstance().getLocalConfig().isZipArchive() ? this.backupName + ".zip" : this.backupName)).toFile();
            if (!Config.getInstance().getLocalConfig().isZipArchive() && !backupDir.mkdir()) {
                Logger.getLogger().warn("Can not create " + backupDir.getPath() + " dir!", this.sender);
            }
            ArrayList<File> dirsToAddToZip = new ArrayList<File>();
            for (String directoryToBackup : this.getDirectoriesToBackup()) {
                try {
                    if (this.cancelled) break;
                    File additionalDirectoryToBackupFile = Paths.get(directoryToBackup, new String[0]).toFile();
                    boolean isExcludedDirectory = Utils.isExcludedDirectory(additionalDirectoryToBackupFile, this.sender);
                    if (!additionalDirectoryToBackupFile.exists()) {
                        Logger.getLogger().warn("addDirectoryToBackup \"" + additionalDirectoryToBackupFile.getPath() + "\" does not exist!");
                        continue;
                    }
                    if (isExcludedDirectory) continue;
                    if (!Config.getInstance().getLocalConfig().isZipArchive()) {
                        CopyFilesToFolderTask task = new CopyFilesToFolderTask(additionalDirectoryToBackupFile, backupDir, true, false, false, this.permissions, this.sender);
                        ((Task)task).prepareTask();
                        this.tasks.add(task);
                        continue;
                    }
                    dirsToAddToZip.add(additionalDirectoryToBackupFile);
                }
                catch (Exception e) {
                    Logger.getLogger().warn("Something went wrong when trying to backup an additional directory \"" + directoryToBackup + "\"", this.sender);
                    Logger.getLogger().warn(this.getClass(), e);
                }
            }
            if (Config.getInstance().getLocalConfig().isZipArchive()) {
                AddDirToZipTask task = new AddDirToZipTask(dirsToAddToZip, backupDir, true, false, false, this.permissions, this.sender);
                ((Task)task).prepareTask();
                this.tasks.add(task);
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Something went wrong while trying to prepare local backup task");
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    private void prepareSftpTask() {
        try {
            if (this.cancelled) {
                return;
            }
            SftpUtils.createFolder(SftpUtils.resolve(Config.getInstance().getSftpConfig().getBackupsFolder(), this.backupName), this.sender);
            for (String directoryToBackup : this.getDirectoriesToBackup()) {
                try {
                    if (!this.cancelled) {
                        File additionalDirectoryToBackupFile = Paths.get(directoryToBackup, new String[0]).toFile();
                        boolean isExcludedDirectory = Utils.isExcludedDirectory(additionalDirectoryToBackupFile, this.sender);
                        if (!additionalDirectoryToBackupFile.exists()) {
                            Logger.getLogger().warn("addDirectoryToBackup \"" + additionalDirectoryToBackupFile.getPath() + "\" does not exist!");
                            continue;
                        }
                        if (isExcludedDirectory) continue;
                        SftpSendFileFolderTask task = new SftpSendFileFolderTask(additionalDirectoryToBackupFile, SftpUtils.resolve(Config.getInstance().getSftpConfig().getBackupsFolder(), this.backupName), true, false, false, this.permissions, this.sender);
                        ((Task)task).prepareTask();
                        this.tasks.add(task);
                    }
                    break;
                }
                catch (Exception e) {
                    Logger.getLogger().warn("Something went wrong when trying to backup an additional directory \"" + directoryToBackup + "\"", this.sender);
                    Logger.getLogger().warn(this.getClass(), e);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Something went wrong while trying to prepare sftp backup task");
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    private void prepareFtpTask() {
        try {
            if (this.cancelled) {
                return;
            }
            if (!Config.getInstance().getFtpConfig().isZipArchive()) {
                FtpUtils.createFolder(FtpUtils.resolve(Config.getInstance().getFtpConfig().getBackupsFolder(), this.backupName), this.sender);
            }
            ArrayList<File> dirsToAddToZip = new ArrayList<File>();
            for (String directoryToBackup : this.getDirectoriesToBackup()) {
                try {
                    if (this.cancelled) break;
                    File additionalDirectoryToBackupFile = Paths.get(directoryToBackup, new String[0]).toFile();
                    boolean isExcludedDirectory = Utils.isExcludedDirectory(additionalDirectoryToBackupFile, this.sender);
                    if (!additionalDirectoryToBackupFile.exists()) {
                        Logger.getLogger().warn("addDirectoryToBackup \"" + additionalDirectoryToBackupFile.getPath() + "\" does not exist!");
                        continue;
                    }
                    if (isExcludedDirectory) continue;
                    if (!Config.getInstance().getFtpConfig().isZipArchive()) {
                        FtpSendFileFolderTask task = new FtpSendFileFolderTask(additionalDirectoryToBackupFile, FtpUtils.resolve(Config.getInstance().getFtpConfig().getBackupsFolder(), this.backupName), true, false, false, this.permissions, this.sender);
                        ((Task)task).prepareTask();
                        this.tasks.add(task);
                        continue;
                    }
                    dirsToAddToZip.add(additionalDirectoryToBackupFile);
                }
                catch (Exception e) {
                    Logger.getLogger().warn("Something went wrong when trying to backup an additional directory \"" + directoryToBackup + "\"", this.sender);
                    Logger.getLogger().warn(this.getClass(), e);
                }
            }
            if (Config.getInstance().getFtpConfig().isZipArchive()) {
                String targetZipPath = FtpUtils.resolve(Config.getInstance().getFtpConfig().getBackupsFolder(), this.backupName + ".zip");
                FtpAddLocalDirsToZipTask task = new FtpAddLocalDirsToZipTask(dirsToAddToZip, targetZipPath, true, false, false, this.permissions, this.sender);
                ((Task)task).prepareTask();
                this.tasks.add(task);
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Something went wrong while trying to prepare FTP(S) backup task");
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    public void prepareGoogleDriveTask() {
        try {
            if (this.cancelled) {
                return;
            }
            String backupDriveFileId = GoogleDriveUtils.createFolder(this.backupName, Config.getInstance().getGoogleDriveConfig().getBackupsFolderId(), this.sender);
            for (String directoryToBackup : this.getDirectoriesToBackup()) {
                try {
                    if (!this.cancelled) {
                        File additionalDirectoryToBackupFile = Paths.get(directoryToBackup, new String[0]).toFile();
                        boolean isExcludedDirectory = Utils.isExcludedDirectory(additionalDirectoryToBackupFile, this.sender);
                        if (!additionalDirectoryToBackupFile.exists()) {
                            Logger.getLogger().warn("addDirectoryToBackup \"" + additionalDirectoryToBackupFile.getPath() + "\" does not exist!");
                            continue;
                        }
                        if (isExcludedDirectory) continue;
                        GoogleDriveSendFileFolderTask task = new GoogleDriveSendFileFolderTask(additionalDirectoryToBackupFile, backupDriveFileId, additionalDirectoryToBackupFile.getName(), true, false, false, this.permissions, this.sender);
                        ((Task)task).prepareTask();
                        this.tasks.add(task);
                    }
                    break;
                }
                catch (Exception e) {
                    Logger.getLogger().warn("Something went wrong when trying to backup an additional directory \"" + directoryToBackup + "\"", this.sender);
                    Logger.getLogger().warn(this.getClass(), e);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Something went wrong while trying to prepare Google Drive backup task");
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    @Override
    public long getTaskCurrentProgress() {
        if (this.cancelled) {
            return this.getTaskMaxProgress();
        }
        long currentProgress = 0L;
        for (Task task : this.tasks) {
            long currentTaskProgress = task.getTaskCurrentProgress();
            long taskProgressMultiplier = 1L;
            if (task instanceof DeleteOldBackupsTask) {
                taskProgressMultiplier = 3L;
            }
            if (task instanceof CopyFilesToFolderTask) {
                taskProgressMultiplier = 5L;
            }
            if (task instanceof AddDirToZipTask) {
                taskProgressMultiplier = 10L;
            }
            if (task instanceof SftpSendFileFolderTask) {
                taskProgressMultiplier = 15L;
            }
            if (task instanceof FtpSendFileFolderTask) {
                taskProgressMultiplier = 15L;
            }
            if (task instanceof FtpAddLocalDirsToZipTask) {
                taskProgressMultiplier = 20L;
            }
            if (task instanceof GoogleDriveSendFileFolderTask) {
                taskProgressMultiplier = 40L;
            }
            currentProgress += currentTaskProgress * taskProgressMultiplier;
        }
        return currentProgress;
    }

    @Override
    public long getTaskMaxProgress() {
        long maxProgress = 0L;
        for (Task task : this.tasks) {
            long maxTaskProgress = task.getTaskMaxProgress();
            long taskProgressMultiplier = 1L;
            if (task instanceof DeleteOldBackupsTask) {
                taskProgressMultiplier = 3L;
            }
            if (task instanceof CopyFilesToFolderTask) {
                taskProgressMultiplier = 5L;
            }
            if (task instanceof AddDirToZipTask) {
                taskProgressMultiplier = 10L;
            }
            if (task instanceof SftpSendFileFolderTask) {
                taskProgressMultiplier = 15L;
            }
            if (task instanceof FtpSendFileFolderTask) {
                taskProgressMultiplier = 15L;
            }
            if (task instanceof FtpAddLocalDirsToZipTask) {
                taskProgressMultiplier = 20L;
            }
            if (task instanceof GoogleDriveSendFileFolderTask) {
                taskProgressMultiplier = 40L;
            }
            maxProgress += maxTaskProgress * taskProgressMultiplier;
        }
        return maxProgress;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (Task task : this.tasks) {
            task.cancel();
        }
    }

    private List<String> getDirectoriesToBackup() {
        List<String> list = Stream.concat(this.getWorldsDirectoryToBackup().stream(), this.getAddDirectoryToBackup().stream()).distinct().toList();
        return list;
    }

    private List<String> getWorldsDirectoryToBackup() {
        List<String> list = Bukkit.getWorlds().stream().map(world -> world.getWorldFolder().getPath()).toList();
        return list;
    }

    private List<String> getAddDirectoryToBackup() {
        if (Config.getInstance().getAddDirectoryToBackup().contains("*")) {
            List list = Config.getInstance().getAddDirectoryToBackup().stream().filter(directory -> !directory.equals("*")).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            File file = new File(".");
            for (File subFile : file.listFiles()) {
                list.add(subFile.getPath());
            }
            return list;
        }
        List<String> list = Config.getInstance().getAddDirectoryToBackup().stream().map(addDirectory -> new File((String)addDirectory).getPath()).toList();
        return list;
    }
}

