/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.common;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.ftp.FtpDeleteDirTask;
import ru.dvdishka.backuper.backend.tasks.googleDrive.GoogleDriveDeleteFileFolderTask;
import ru.dvdishka.backuper.backend.tasks.local.folder.DeleteDirTask;
import ru.dvdishka.backuper.backend.tasks.sftp.SftpDeleteDirTask;
import ru.dvdishka.backuper.backend.utils.FtpUtils;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.backend.utils.SftpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class DeleteBrokenBackupsTask
extends Task {
    private static final String taskName = "DeleteBrokenBackupsTask";
    private ArrayList<Task> tasks = new ArrayList();

    public DeleteBrokenBackupsTask(boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
    }

    @Override
    public void run() {
        block6: {
            if (this.setLocked) {
                Backuper.lock(this);
            }
            try {
                Logger.getLogger().devLog("DeleteBrokenBackups task has been started");
                if (!this.isTaskPrepared) {
                    this.prepareTask();
                }
                for (Task task : this.tasks) {
                    if (this.cancelled) break;
                    task.run();
                }
                if (this.setLocked) {
                    Logger.getLogger().log("DeleteBrokenBackups task completed", this.sender);
                    UIUtils.successSound(this.sender);
                    Backuper.unlock();
                }
                Logger.getLogger().devLog("DeleteBrokenBackups task has been finished");
            }
            catch (Exception e) {
                Logger.getLogger().warn("Something went wrong when trying to delete broken backups", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
                if (!this.setLocked) break block6;
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
        }
    }

    @Override
    public void prepareTask() {
        List<Object> files;
        if (this.cancelled) {
            return;
        }
        if (Config.getInstance().getLocalConfig().isEnabled() && !this.cancelled) {
            File backupsFolder = new File(Config.getInstance().getLocalConfig().getBackupsFolder());
            if (!backupsFolder.exists() || backupsFolder.listFiles() == null) {
                Logger.getLogger().warn("Wrong local backupsFolder!");
            } else {
                for (File file : backupsFolder.listFiles()) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!file.getName().replace(".zip", "").endsWith(" in progress")) continue;
                    DeleteDirTask task = new DeleteDirTask(file, false, (List<Permissions>)this.permissions, this.sender);
                    ((Task)task).prepareTask();
                    this.tasks.add(task);
                }
            }
        }
        if (Config.getInstance().getFtpConfig().isEnabled() && !this.cancelled) {
            if (FtpUtils.checkConnection(this.sender)) {
                files = FtpUtils.ls(Config.getInstance().getFtpConfig().getBackupsFolder(), this.sender);
                for (String string : files) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!string.replace(".zip", "").endsWith(" in progress")) continue;
                    FtpDeleteDirTask task = new FtpDeleteDirTask(FtpUtils.resolve(Config.getInstance().getFtpConfig().getBackupsFolder(), string), false, this.permissions, this.sender);
                    ((Task)task).prepareTask();
                    this.tasks.add(task);
                }
            } else {
                Logger.getLogger().warn("Failed to establish FTP(S) connection");
            }
        }
        if (Config.getInstance().getSftpConfig().isEnabled() && !this.cancelled) {
            if (SftpUtils.checkConnection(this.sender)) {
                files = SftpUtils.ls(Config.getInstance().getSftpConfig().getBackupsFolder(), this.sender);
                for (String string : files) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!string.replace(".zip", "").endsWith(" in progress")) continue;
                    SftpDeleteDirTask task = new SftpDeleteDirTask(FtpUtils.resolve(Config.getInstance().getSftpConfig().getBackupsFolder(), string), false, this.permissions, this.sender);
                    ((Task)task).prepareTask();
                    this.tasks.add(task);
                }
            } else {
                Logger.getLogger().warn("Failed to establish SFTP connection");
            }
        }
        if (Config.getInstance().getGoogleDriveConfig().isEnabled() && GoogleDriveUtils.isAuthorized(null) && !this.cancelled) {
            files = GoogleDriveUtils.ls(Config.getInstance().getGoogleDriveConfig().getBackupsFolderId(), this.sender);
            for (com.google.api.services.drive.model.File file : files) {
                if (this.cancelled) {
                    return;
                }
                if (!file.getName().replace(".zip", "").endsWith(" in progress")) continue;
                GoogleDriveDeleteFileFolderTask task = new GoogleDriveDeleteFileFolderTask(file.getId(), false, this.permissions, this.sender);
                ((Task)task).prepareTask();
                this.tasks.add(task);
            }
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (Task task : this.tasks) {
            task.cancel();
        }
    }

    @Override
    public long getTaskMaxProgress() {
        long maxProgress = 0L;
        for (Task task : this.tasks) {
            maxProgress += task.getTaskMaxProgress();
        }
        return maxProgress;
    }

    @Override
    public long getTaskCurrentProgress() {
        if (this.cancelled) {
            return this.getTaskMaxProgress();
        }
        long currentProgress = 0L;
        for (Task task : this.tasks) {
            currentProgress += task.getTaskCurrentProgress();
        }
        return currentProgress;
    }
}

