/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.common;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.backup.ExternalBackup;
import ru.dvdishka.backuper.backend.backup.FtpBackup;
import ru.dvdishka.backuper.backend.backup.GoogleDriveBackup;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.backup.SftpBackup;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class DeleteOldBackupsTask
extends Task {
    private static String taskName = "DeleteOldBackups";
    private ArrayList<Task> deleteBackupTasks = new ArrayList();

    public DeleteOldBackupsTask(boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
    }

    @Override
    public void run() {
        if (this.setLocked) {
            Backuper.lock(this);
        }
        try {
            Logger.getLogger().devLog("DeleteOldBackups task has been started");
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            for (Task deleteDirTask : this.deleteBackupTasks) {
                if (this.cancelled) continue;
                deleteDirTask.run();
            }
            Logger.getLogger().devLog("DeleteOldBackups task has been finished");
            if (this.setLocked) {
                Logger.getLogger().log("DeleteOldBackups task completed", this.sender);
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong while running DeleteOldBackups task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        try {
            if (!this.cancelled && Config.getInstance().getLocalConfig().isEnabled()) {
                this.deleteBackups("local");
            }
            if (!this.cancelled && Config.getInstance().getFtpConfig().isEnabled()) {
                this.deleteBackups("ftp");
            }
            if (!this.cancelled && Config.getInstance().getSftpConfig().isEnabled()) {
                this.deleteBackups("sftp");
            }
            if (!this.cancelled && Config.getInstance().getGoogleDriveConfig().isEnabled() && GoogleDriveUtils.isAuthorized(null)) {
                this.deleteBackups("googleDrive");
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("DeleteOldBackupsTask failed", this.sender);
            Logger.getLogger().warn(DeleteOldBackupsTask.class, e);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (Task deleteDirTask : this.deleteBackupTasks) {
            deleteDirTask.cancel();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deleteBackups(String storage) {
        if (this.cancelled || storage.equals("local") && Config.getInstance().getLocalConfig().getBackupsNumber() == 0 && Config.getInstance().getLocalConfig().getBackupsWeight() == 0L || storage.equals("ftp") && Config.getInstance().getFtpConfig().getBackupsNumber() == 0 && Config.getInstance().getFtpConfig().getBackupsWeight() == 0L || storage.equals("sftp") && Config.getInstance().getSftpConfig().getBackupsNumber() == 0 && Config.getInstance().getSftpConfig().getBackupsWeight() == 0L || storage.equals("googleDrive") && Config.getInstance().getGoogleDriveConfig().getBackupsNumber() == 0 && Config.getInstance().getGoogleDriveConfig().getBackupsWeight() == 0L) {
            return;
        }
        HashSet<LocalDateTime> backupsToDeleteList = new HashSet<LocalDateTime>();
        long backupsFolderByteSize = 0L;
        ArrayList<ExternalBackup> backups = new ArrayList<ExternalBackup>();
        if (storage.equals("local")) {
            backups.addAll(LocalBackup.getBackups());
        }
        if (storage.equals("sftp")) {
            backups.addAll(SftpBackup.getBackups());
        }
        if (storage.equals("ftp")) {
            backups.addAll(FtpBackup.getBackups());
        }
        if (storage.equals("googleDrive")) {
            backups.addAll(GoogleDriveBackup.getBackups());
        }
        if (this.cancelled) {
            return;
        }
        for (Backup backup : backups) {
            if (this.cancelled) {
                return;
            }
            try {
                backupsFolderByteSize += backup.getByteSize(this.sender);
            }
            catch (Exception exception) {
                Logger.getLogger().warn("Failed to get backup byte size", this.sender);
                Logger.getLogger().warn(this.getClass(), exception);
            }
        }
        ArrayList<LocalDateTime> backupDateTimes = new ArrayList<LocalDateTime>();
        for (Backup backup : backups) {
            backupDateTimes.add(backup.getLocalDateTime());
        }
        Utils.sortLocalDateTime(backupDateTimes);
        if (storage.equals("local") && Config.getInstance().getLocalConfig().getBackupsNumber() != 0 || storage.equals("sftp") && Config.getInstance().getSftpConfig().getBackupsNumber() != 0 || storage.equals("ftp") && Config.getInstance().getFtpConfig().getBackupsNumber() != 0 || storage.equals("googleDrive") && Config.getInstance().getGoogleDriveConfig().getBackupsNumber() != 0) {
            void var7_11;
            void var7_10;
            int n;
            int n2 = backups.size();
            if (storage.equals("local")) {
                n = n2 - Config.getInstance().getLocalConfig().getBackupsNumber();
            }
            if (storage.equals("sftp")) {
                var7_10 = n - Config.getInstance().getSftpConfig().getBackupsNumber();
            }
            if (storage.equals("ftp")) {
                var7_11 = var7_10 - Config.getInstance().getFtpConfig().getBackupsNumber();
            }
            if (storage.equals("googleDrive")) {
                void var7_12 = var7_11 - Config.getInstance().getGoogleDriveConfig().getBackupsNumber();
            }
            for (LocalDateTime fileName : backupDateTimes) {
                void var7_13;
                if (var7_13 <= 0) break;
                if (backupsToDeleteList.contains(fileName)) continue;
                for (Backup backup : backups) {
                    if (this.cancelled) {
                        return;
                    }
                    String string = backup.getName().replace(".zip", "");
                    try {
                        if (!LocalDateTime.parse(string, Config.getInstance().getDateTimeFormatter()).equals(fileName)) continue;
                        Backup.BackupDeleteTask deleteBackupTask = backup.getDeleteTask(false, this.sender);
                        ((Task)deleteBackupTask).prepareTask();
                        this.deleteBackupTasks.add(deleteBackupTask);
                        backupsToDeleteList.add(fileName);
                        backupsFolderByteSize -= backup.getByteSize(this.sender);
                    }
                    catch (Exception deleteBackupTask) {}
                }
                --var7_13;
            }
        }
        if (storage.equals("local") && Config.getInstance().getLocalConfig().getBackupsWeight() != 0L || storage.equals("sftp") && Config.getInstance().getSftpConfig().getBackupsWeight() != 0L || storage.equals("ftp") && Config.getInstance().getFtpConfig().getBackupsWeight() != 0L || storage.equals("googleDrive") && Config.getInstance().getGoogleDriveConfig().getBackupsWeight() != 0L) {
            long l = backupsFolderByteSize;
            if (storage.equals("local")) {
                l -= Config.getInstance().getLocalConfig().getBackupsWeight();
            }
            if (storage.equals("sftp")) {
                l -= Config.getInstance().getSftpConfig().getBackupsWeight();
            }
            if (storage.equals("ftp")) {
                l -= Config.getInstance().getFtpConfig().getBackupsWeight();
            }
            if (storage.equals("googleDrive")) {
                l -= Config.getInstance().getGoogleDriveConfig().getBackupsWeight();
            }
            for (LocalDateTime fileName : backupDateTimes) {
                if (l <= 0L) break;
                if (backupsToDeleteList.contains(fileName)) continue;
                for (Backup backup : backups) {
                    if (this.cancelled) {
                        return;
                    }
                    String backupFileName = backup.getName().replace(".zip", "");
                    try {
                        if (!LocalDateTime.parse(backupFileName, Config.getInstance().getDateTimeFormatter()).equals(fileName)) continue;
                        l -= backup.getByteSize(this.sender);
                        Backup.BackupDeleteTask deleteBackupTask = backup.getDeleteTask(false, this.sender);
                        ((Task)deleteBackupTask).prepareTask();
                        this.deleteBackupTasks.add(deleteBackupTask);
                        backupsToDeleteList.add(fileName);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @Override
    public long getTaskCurrentProgress() {
        if (this.cancelled) {
            return this.getTaskMaxProgress();
        }
        long currentProgress = 0L;
        for (Task deleteBackupTask : this.deleteBackupTasks) {
            currentProgress += deleteBackupTask.getTaskCurrentProgress();
        }
        return currentProgress;
    }

    @Override
    public long getTaskMaxProgress() {
        long maxProgress = 0L;
        for (Task deleteBackupTask : this.deleteBackupTasks) {
            maxProgress += deleteBackupTask.getTaskMaxProgress();
        }
        return maxProgress;
    }
}

