/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.FtpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class FtpAddLocalDirsToZipTask
extends Task {
    private static final String taskName = "FtpAddLocalDirToZip";
    private String targetZipPath;
    private final List<File> sourceDirsToAdd;
    private FTPClient ftpClient = null;
    private boolean forceExcludedDirs;
    private boolean createRootDirInTargetZIP;

    public FtpAddLocalDirsToZipTask(List<File> sourceDirsToAdd, String targetZipPath, boolean createRootDirInTargetZIP, boolean forceExcludedDirs, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.targetZipPath = targetZipPath;
        this.sourceDirsToAdd = sourceDirsToAdd;
        this.sender = sender;
        this.forceExcludedDirs = forceExcludedDirs;
        this.createRootDirInTargetZIP = createRootDirInTargetZIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.setLocked) {
            Backuper.lock(this);
        }
        try {
            Logger.getLogger().devLog("FtpAddLocalDirToZip task has been started");
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            if (!this.cancelled) {
                this.ftpClient = FtpUtils.getClient(this.sender);
                if (this.ftpClient == null) {
                    return;
                }
            }
            OutputStream outputStream = this.ftpClient.storeFileStream(this.targetZipPath);
            ZipOutputStream targetZipOutputStream = new ZipOutputStream(outputStream);
            try {
                for (File sourceDirToAdd : this.sourceDirsToAdd) {
                    if (this.cancelled) {
                        break;
                    }
                    if (this.createRootDirInTargetZIP) {
                        this.addDirToZip(targetZipOutputStream, sourceDirToAdd, sourceDirToAdd.getCanonicalFile().getParentFile().toPath());
                        continue;
                    }
                    this.addDirToZip(targetZipOutputStream, sourceDirToAdd, sourceDirToAdd.toPath());
                }
            }
            catch (Exception e) {
                Logger.getLogger().warn("FtpAddLocalDirToZip task failed", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
                Backuper.unlock();
            }
            finally {
                targetZipOutputStream.finish();
                targetZipOutputStream.close();
                outputStream.close();
                this.ftpClient.disconnect();
            }
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong while running FtpAddLocalDirToZip task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
        finally {
            Logger.getLogger().devLog("FtpAddLocalDirToZip task has been finished");
        }
    }

    private void addDirToZip(ZipOutputStream zip, File sourceDir, Path relativeDirPath) {
        if (this.cancelled) {
            return;
        }
        if (!sourceDir.exists()) {
            Logger.getLogger().warn("Something went wrong while running FtpAddLocalDirToZIP task", this.sender);
            Logger.getLogger().warn("Directory " + sourceDir.getAbsolutePath() + " does not exist", this.sender);
            return;
        }
        boolean isExcludedDirectory = Utils.isExcludedDirectory(sourceDir, this.sender);
        if (isExcludedDirectory && !this.forceExcludedDirs) {
            return;
        }
        if (!this.cancelled && sourceDir.isFile()) {
            try {
                int length;
                String relativeFilePath = relativeDirPath.toAbsolutePath().relativize(sourceDir.toPath().toAbsolutePath()).toString();
                zip.setLevel(Config.getInstance().getFtpConfig().getZipCompressionLevel());
                ZipEntry zipEntry = new ZipEntry(relativeFilePath);
                zip.putNextEntry(zipEntry);
                FileInputStream fileInputStream = new FileInputStream(sourceDir);
                byte[] buffer = new byte[1024];
                while ((length = fileInputStream.read(buffer)) >= 0 && !this.cancelled) {
                    zip.write(buffer, 0, length);
                    this.incrementCurrentProgress(length);
                }
                zip.closeEntry();
                fileInputStream.close();
            }
            catch (Exception e) {
                Logger.getLogger().warn("Something went wrong while running FtpAddLocalDirToZIP task", this.sender);
                Logger.getLogger().warn("Something went wrong while trying to put file in ZIP! " + sourceDir.getName(), this.sender);
                Logger.getLogger().warn(this.getClass(), e);
            }
        }
        if (sourceDir.listFiles() == null) {
            return;
        }
        for (File file : sourceDir.listFiles()) {
            if (file.getName().equals("session.lock")) continue;
            this.addDirToZip(zip, file, relativeDirPath);
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        if (!this.forceExcludedDirs) {
            for (File sourceDirToAdd : this.sourceDirsToAdd) {
                this.maxProgress += Utils.getFileFolderByteSizeExceptExcluded(sourceDirToAdd);
            }
        } else {
            for (File sourceDirToAdd : this.sourceDirsToAdd) {
                this.maxProgress += Utils.getFileFolderByteSize(sourceDirToAdd);
            }
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }
}

