/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.net.ftp.FTPClient;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.FtpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class FtpSendFileFolderTask
extends Task {
    private static final String taskName = "FtpSendFileFolder";
    private final File localDirToSend;
    private final boolean createRootDirInTargetDir;
    private String remoteTargetDir;
    private final boolean forceExcludedDirs;
    private final ArrayList<CompletableFuture<Void>> ftpTasks = new ArrayList();
    private FTPClient ftp;

    public FtpSendFileFolderTask(File localDirToSend, String remoteTargetDir, boolean createRootDirInTargetDir, boolean forceExcludedDirs, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.localDirToSend = localDirToSend;
        this.createRootDirInTargetDir = createRootDirInTargetDir;
        this.remoteTargetDir = remoteTargetDir;
        this.forceExcludedDirs = forceExcludedDirs;
    }

    @Override
    public void run() {
        try {
            if (this.setLocked) {
                Backuper.lock(this);
            }
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            Logger.getLogger().devLog("FtpSendFileFolderTask has been started");
            if (!this.cancelled) {
                this.ftp = FtpUtils.getClient(this.sender);
                if (this.ftp == null) {
                    return;
                }
            }
            if (this.createRootDirInTargetDir) {
                this.remoteTargetDir = FtpUtils.resolve(this.remoteTargetDir, this.localDirToSend.getName());
            }
            if (!this.cancelled) {
                this.sendFolder(this.localDirToSend, this.remoteTargetDir);
            }
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong when trying to send file/folder from FTP(S) server", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
        finally {
            try {
                this.ftp.disconnect();
            }
            catch (Exception e) {
                Logger.getLogger().warn(this.getClass(), e);
            }
            Logger.getLogger().devLog("FtpSendFileFolder task has been finished");
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        this.maxProgress = this.forceExcludedDirs ? Utils.getFileFolderByteSize(this.localDirToSend) : Utils.getFileFolderByteSizeExceptExcluded(this.localDirToSend);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (CompletableFuture<Void> task : this.ftpTasks) {
            task.cancel(true);
        }
    }

    private void sendFolder(File localDirToSend, String remotePath) {
        block10: {
            if (this.cancelled) {
                return;
            }
            if (!localDirToSend.exists()) {
                Logger.getLogger().warn("Something went wrong while trying to send files from " + localDirToSend.getAbsolutePath());
                Logger.getLogger().warn("Directory " + localDirToSend.getAbsolutePath() + " does not exist", this.sender);
                return;
            }
            boolean isExcludedDirectory = Utils.isExcludedDirectory(localDirToSend, this.sender);
            if (isExcludedDirectory && !this.forceExcludedDirs) {
                return;
            }
            if (localDirToSend.isFile() && !localDirToSend.getName().equals("session.lock")) {
                CompletableFuture<Void> ftpTask = CompletableFuture.runAsync(() -> {
                    try (FileInputStream inputStream = new FileInputStream(localDirToSend);){
                        if (!this.ftp.storeFile(remotePath, inputStream)) {
                            throw new IOException("Failed to send file \"" + localDirToSend.getCanonicalPath() + "\" to \"" + remotePath + "\"");
                        }
                        this.incrementCurrentProgress(localDirToSend.length());
                    }
                    catch (Exception e) {
                        Logger.getLogger().devWarn(this.getClass(), "Something went wrong while sending file \"" + localDirToSend.getPath() + "\" to FTP(S) server");
                        Logger.getLogger().devWarn(this.getClass(), Arrays.toString(e.getStackTrace()));
                    }
                });
                this.ftpTasks.add(ftpTask);
                try {
                    ftpTask.join();
                }
                catch (Exception e) {
                    if (this.cancelled) break block10;
                    Logger.getLogger().warn("Something went wrong while sending file \"" + localDirToSend.getPath() + "\" to FTP(S) server", this.sender);
                    Logger.getLogger().warn(this.getClass(), e);
                }
            }
        }
        if (localDirToSend.isDirectory() && localDirToSend.listFiles() != null) {
            try {
                this.ftp.makeDirectory(remotePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (File file : localDirToSend.listFiles()) {
                this.sendFolder(file, FtpUtils.resolve(remotePath, file.getName()));
            }
        }
    }
}

