/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.googleDrive;

import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.api.client.googleapis.media.MediaHttpDownloaderProgressListener;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class GoogleDriveGetFileFolderTask
extends Task {
    private static final String taskName = "GoogleDriveGetFileFolder";
    private final String sourceDirId;
    private File targetDir;
    private final boolean createRootDirInTargetDir;
    private final boolean setLocked;
    private final List<Permissions> permissions;
    private final CommandSender sender;
    private long dirSize = 0L;
    private ArrayList<CompletableFuture<Void>> tasks = new ArrayList();
    private ArrayList<GoogleDriveDownloadProgressListener> progressListeners = new ArrayList();

    public GoogleDriveGetFileFolderTask(String sourceDirId, File targetDir, boolean createRootDirInTargetDir, boolean setLocked, List<Permissions> permissions, CommandSender sender) {
        super(taskName, setLocked, permissions, sender);
        this.sourceDirId = sourceDirId;
        this.targetDir = targetDir;
        this.createRootDirInTargetDir = createRootDirInTargetDir;
        this.setLocked = setLocked;
        this.permissions = permissions;
        this.sender = sender;
    }

    @Override
    public void run() {
        try {
            if (this.setLocked) {
                Backuper.lock(this);
            }
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            Logger.getLogger().devLog("GoogleDriveGetFileFolder task has been started");
            if (!this.cancelled) {
                this.getRemoteDir(this.sourceDirId, this.targetDir, true);
            }
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong when trying to download file \"" + this.sourceDirId + "\" from Google Drive", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
        finally {
            Logger.getLogger().devLog("GoogleDriveGetFileFolder task has been finished");
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        try {
            this.dirSize = GoogleDriveUtils.getFileByteSize(this.sourceDirId, this.sender);
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to get directory size from Google Drive", e);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    private void getRemoteDir(String driveFileId, File localPath, boolean firstDir) {
        if (this.cancelled) {
            return;
        }
        try {
            if (!GoogleDriveUtils.isFolder(driveFileId, this.sender)) {
                localPath.createNewFile();
                GoogleDriveDownloadProgressListener progressListener = new GoogleDriveDownloadProgressListener();
                this.progressListeners.add(progressListener);
                CompletableFuture<Void> task = CompletableFuture.runAsync(() -> {
                    try {
                        GoogleDriveUtils.downloadFile(driveFileId, localPath, progressListener, this.sender);
                    }
                    catch (Exception e) {
                        Logger.getLogger().devWarn(this.getClass(), "Something went wrong when trying to download file \"" + driveFileId + "\" from Google Drive");
                        Logger.getLogger().devWarn(this.getClass(), e);
                    }
                });
                this.tasks.add(task);
                try {
                    task.join();
                }
                catch (Exception e) {
                    if (!this.cancelled) {
                        Logger.getLogger().warn("Something went wrong when trying to download file \"" + driveFileId + "\" from Google Drive", this.sender);
                        Logger.getLogger().warn(this.getClass(), e);
                    }
                }
            } else {
                Path newPath = localPath.toPath();
                localPath.mkdirs();
                if (firstDir && this.createRootDirInTargetDir) {
                    newPath = newPath.resolve(GoogleDriveUtils.getFileName(driveFileId, this.sender));
                }
                for (com.google.api.services.drive.model.File driveEntry : GoogleDriveUtils.ls(driveFileId, this.sender)) {
                    this.getRemoteDir(driveEntry.getId(), newPath.resolve(driveEntry.getName()).toFile(), false);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to get file/folder from Google Drive", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (CompletableFuture<Void> task : this.tasks) {
            task.cancel(true);
        }
    }

    @Override
    public long getTaskCurrentProgress() {
        long currentProgress = 0L;
        for (GoogleDriveDownloadProgressListener progressListener : this.progressListeners) {
            currentProgress += progressListener.getBytesDownloaded();
        }
        return currentProgress;
    }

    @Override
    public long getTaskMaxProgress() {
        return this.dirSize;
    }

    private static class GoogleDriveDownloadProgressListener
    implements MediaHttpDownloaderProgressListener {
        long progress = 0L;

        private GoogleDriveDownloadProgressListener() {
        }

        @Override
        public void progressChanged(MediaHttpDownloader mediaHttpDownloader) {
            this.progress = mediaHttpDownloader.getNumBytesDownloaded();
        }

        public long getBytesDownloaded() {
            return this.progress;
        }
    }
}

